/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.customPayment.CustomPaymentForm;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PaymentOptionConfigurationView
extends ConfigurationView {
    private Terminal terminal;
    private JCheckBox chkCashPayment;
    private JCheckBox chkCardPayment;
    private JCheckBox chkGiftCardPayment;
    private JCheckBox chkCustomPayment;
    private JCheckBox chkShowIndivBtn;
    private JCheckBox chkCustomerBlncePayment;
    private JTable table;

    public PaymentOptionConfigurationView(Terminal terminal) {
        this.terminal = terminal;
        this.setLayout(new BorderLayout());
        this.createUI();
        this.initData();
        this.initEvent();
    }

    public void initData() {
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension == null) {
            this.chkCustomerBlncePayment.setVisible(false);
        }
        List<CustomPayment> customPaymentList = CustomPaymentDAO.getInstance().findAll();
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        tableModel.removeAll();
        tableModel.addRows(customPaymentList);
    }

    private void initEvent() {
        this.chkCustomPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox chkBox = (JCheckBox)e.getSource();
                if (chkBox.isSelected()) {
                    PaymentOptionConfigurationView.this.chkShowIndivBtn.setSelected(false);
                    PaymentOptionConfigurationView.this.chkShowIndivBtn.setEnabled(false);
                } else {
                    PaymentOptionConfigurationView.this.chkShowIndivBtn.setEnabled(true);
                }
            }
        });
    }

    private void createUI() {
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3"));
        this.chkCashPayment = new JCheckBox("Hide CASH payment button");
        this.chkCardPayment = new JCheckBox("Hide CARD payment button");
        this.chkGiftCardPayment = new JCheckBox("Hide GIFT CARD payment button");
        this.chkCustomPayment = new JCheckBox("Hide CUSTOM payment");
        this.chkShowIndivBtn = new JCheckBox("Show custom payments as individual buttons");
        this.chkCustomerBlncePayment = new JCheckBox("Hide CUST. ACCT. payment button");
        this.table = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        BeanTableModel tableModel = new BeanTableModel(CustomPayment.class);
        tableModel.addColumn(Messages.getString("CustomPaymentBrowser.0"), CustomPayment.PROP_ID);
        tableModel.addColumn(Messages.getString("CustomPaymentBrowser.1"), CustomPayment.PROP_NAME);
        tableModel.addColumn(Messages.getString("CustomPaymentBrowser.2"), CustomPayment.PROP_REF_NUMBER_FIELD_NAME);
        this.table.setModel(tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    PaymentOptionConfigurationView.this.doEditPayment();
                }
            }
        });
        JPanel customPaymentPanel = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder(null, "CUSTOM PAYMENT", 2, 0);
        customPaymentPanel.setBorder(border);
        customPaymentPanel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        JButton btnNew = new JButton("NEW");
        JButton btnEdit = new JButton("EDIT");
        JButton btnDelete = new JButton("DELETE");
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentOptionConfigurationView.this.doAddPayment();
            }
        });
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentOptionConfigurationView.this.doEditPayment();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentOptionConfigurationView.this.doDeletePayment();
            }
        });
        buttonPanel.add(btnNew);
        buttonPanel.add(btnEdit);
        buttonPanel.add(btnDelete);
        customPaymentPanel.add((Component)buttonPanel, "South");
        mainPanel.add((Component)this.chkCashPayment, "wrap");
        mainPanel.add((Component)this.chkCardPayment, "wrap");
        mainPanel.add((Component)this.chkGiftCardPayment, "wrap");
        mainPanel.add((Component)this.chkCustomerBlncePayment, "wrap");
        mainPanel.add((Component)new JSeparator(), "grow, wrap");
        mainPanel.add((Component)this.chkCustomPayment, "wrap");
        mainPanel.add((Component)this.chkShowIndivBtn, "gapleft 15, wrap");
        mainPanel.add((Component)customPaymentPanel, "grow, span");
        this.add(mainPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalDAO termDAO = new TerminalDAO();
            termDAO.saveOrUpdate(this.terminal);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            if (this.terminal == null) {
                return;
            }
            boolean hideCashButton = this.terminal.getProperty("hideCashPayment") == null ? false : Boolean.valueOf(this.terminal.getProperty("hideCashPayment"));
            boolean hideCardButton = this.terminal.getProperty("hideCardPayment") == null ? false : Boolean.valueOf(this.terminal.getProperty("hideCardPayment"));
            boolean hideGiftCardButton = this.terminal.getProperty("hideGiftCardPayment") == null ? false : Boolean.valueOf(this.terminal.getProperty("hideGiftCardPayment"));
            boolean hideCustomPaymentButton = this.terminal.getProperty("hideCustomPayment") == null ? false : Boolean.valueOf(this.terminal.getProperty("hideCustomPayment"));
            boolean showIndivButton = this.terminal.getProperty("showIndivBtn") == null ? false : Boolean.valueOf(this.terminal.getProperty("showIndivBtn"));
            boolean hideCustBlnceButton = this.terminal.getProperty("hideCustBlncPayment") == null ? false : Boolean.valueOf(this.terminal.getProperty("hideCustBlncPayment"));
            this.chkCashPayment.setSelected(hideCashButton);
            this.chkCardPayment.setSelected(hideCardButton);
            this.chkGiftCardPayment.setSelected(hideGiftCardButton);
            this.chkCustomPayment.setSelected(hideCustomPaymentButton);
            this.chkShowIndivBtn.setSelected(showIndivButton);
            this.chkCustomerBlncePayment.setSelected(hideCustBlnceButton);
            this.chkShowIndivBtn.setEnabled(!hideCustomPaymentButton);
            this.setInitialized(true);
        }
        catch (Exception e) {
            PosLog.error(PaymentOptionConfigurationView.class, e);
        }
    }

    public boolean updateModel() {
        Terminal term = this.terminal;
        term.addProperty("hideCashPayment", String.valueOf(this.chkCashPayment.isSelected()));
        term.addProperty("hideCardPayment", String.valueOf(this.chkCardPayment.isSelected()));
        term.addProperty("hideGiftCardPayment", String.valueOf(this.chkGiftCardPayment.isSelected()));
        term.addProperty("hideCustomPayment", String.valueOf(this.chkCustomPayment.isSelected()));
        term.addProperty("showIndivBtn", String.valueOf(this.chkShowIndivBtn.isSelected()));
        term.addProperty("hideCustBlncPayment", String.valueOf(this.chkCustomerBlncePayment.isSelected()));
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return "Payment";
    }

    private void doAddPayment() {
        CustomPaymentForm customPaymentForm = new CustomPaymentForm();
        customPaymentForm.createNew();
        customPaymentForm.setFieldsEnable(true);
        BeanEditorDialog dialog = new BeanEditorDialog(customPaymentForm);
        dialog.openWithScale(500, 500);
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        if (((CustomPayment)customPaymentForm.getBean()).getId() != null && StringUtils.isNotEmpty((String)((CustomPayment)customPaymentForm.getBean()).getId())) {
            tableModel.addRow(customPaymentForm.getBean());
        }
    }

    private void doEditPayment() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        CustomPayment customPayment = (CustomPayment)tableModel.getRow(index);
        CustomPaymentForm customPaymentForm = new CustomPaymentForm(customPayment);
        customPaymentForm.setFieldsEnable(true);
        BeanEditorDialog dialog = new BeanEditorDialog(customPaymentForm);
        dialog.openWithScale(500, 500);
        tableModel.fireTableDataChanged();
    }

    private void doDeletePayment() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        BeanTableModel tableModel = (BeanTableModel)this.table.getModel();
        CustomPayment customPayment = (CustomPayment)tableModel.getRow(index);
        CustomPaymentForm customPaymentForm = new CustomPaymentForm(customPayment);
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to delete this custom payment?", "Delete Confirmation:");
        if (option != 0) {
            return;
        }
        customPaymentForm.delete();
        tableModel.removeRow(index);
        tableModel.fireTableDataChanged();
    }
}

