/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.MultiPrinterPane;
import com.floreantpos.config.ui.PrinterGroupView;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PrintConfigurationView
extends ConfigurationView {
    private JComboBox cbReceiptPrinterName;
    private JComboBox cbReportPrinterName;
    private JComboBox<PaperSize> cbReportPageSize;
    public static final String Ticket_Header = "ticket.header";
    public static final String Ticket_Footer = "ticket.footer";
    private PosPrinters printers;
    private Store store;
    private Terminal terminal;

    public PrintConfigurationView() {
        this(Application.getInstance().getTerminal());
    }

    public PrintConfigurationView(Terminal terminal) {
        this.printers = PosPrinters.load(terminal);
        this.terminal = terminal;
        this.initComponents();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_PRINT;
    }

    @Override
    public void initialize() throws Exception {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        this.cbReportPrinterName.setModel(new DefaultComboBoxModel<PrintService>(printServices));
        this.cbReceiptPrinterName.setModel(new DefaultComboBoxModel<PrintService>(printServices));
        PrintServiceComboRenderer comboRenderer = new PrintServiceComboRenderer();
        this.cbReportPrinterName.setRenderer(comboRenderer);
        this.cbReceiptPrinterName.setRenderer(comboRenderer);
        this.setSelectedPrinter(this.cbReportPrinterName, this.printers.getReportPrinter());
        this.setSelectedPrinter(this.cbReceiptPrinterName, this.printers.getReceiptPrinter());
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String property = currentTerminal.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)property)) {
            PaperSize paperSize = PaperSize.valueOf(property);
            this.cbReportPageSize.setSelectedItem((Object)paperSize);
        }
        this.store = Application.getInstance().getStore();
        this.setInitialized(true);
        if (printServices == null || printServices.length == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PrintConfigurationView.0"));
        }
    }

    private void setSelectedPrinter(JComboBox whichPrinter, String printerName) {
        int printerCount = whichPrinter.getItemCount();
        for (int i = 0; i < printerCount; ++i) {
            PrintService printService = (PrintService)whichPrinter.getItemAt(i);
            if (!printService.getName().equals(printerName)) continue;
            whichPrinter.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public boolean save() throws Exception {
        PrintService printService = (PrintService)this.cbReportPrinterName.getSelectedItem();
        this.printers.setReportPrinter(printService == null ? null : printService.getName());
        printService = (PrintService)this.cbReceiptPrinterName.getSelectedItem();
        this.printers.setReceiptPrinter(printService == null ? null : printService.getName());
        PaperSize selectedPaperSize = (PaperSize)((Object)this.cbReportPageSize.getSelectedItem());
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        currentTerminal.addProperty("report.paper_size", selectedPaperSize.name());
        TerminalDAO.getInstance().update(currentTerminal);
        StoreDAO.getInstance().saveOrUpdate(this.store);
        Application.getInstance().refreshStore();
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", ""));
        this.cbReportPrinterName = new JComboBox();
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(Messages.getString("PrintConfigurationView.8"));
        this.cbReceiptPrinterName = new JComboBox();
        MultiPrinterPane multiPrinterPane = new MultiPrinterPane(Messages.getString("PrintConfigurationView.1"), this.printers.getKitchenPrinters(), this.terminal);
        contentPanel.add((Component)multiPrinterPane, "cell 0 1 2 1,growx,h 200!");
        PrinterGroupView printerGroupView = new PrinterGroupView(Messages.getString("PrintConfigurationView.13"));
        printerGroupView.setPreferredSize(new Dimension(0, 400));
        contentPanel.add((Component)printerGroupView, "cell 0 2 2 1,growx,h 200!,wrap");
        JLabel lblTest = new JLabel();
        lblTest.setText("Report Paper Size:");
        contentPanel.add((Component)lblTest, "cell 0 3, growx");
        this.cbReportPageSize = new JComboBox<PaperSize>(PaperSize.values());
        contentPanel.add(this.cbReportPageSize, "cell 1 3, w 150! ,wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    private class PrintServiceComboRenderer
    extends DefaultListCellRenderer {
        private PrintServiceComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PrintService printService = (PrintService)value;
            if (printService != null) {
                listCellRendererComponent.setText(printService.getName());
            }
            return listCellRendererComponent;
        }
    }
}

