/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang.StringUtils;

public class ReceiptConfigurationView
extends JPanel {
    private boolean initialized = false;
    private JTextPane ticketHeaderTextArea;
    private JTextPane ticketfooterTextArea;
    private JTextPane ticketBottomTextArea;
    private JTextPane orderInfoTextPane;
    private JTextPane additionalOrderInfoTextPane;
    private JList<ReceiptParam> listParams;
    private OrderType selectedOrderType;
    private Store store;
    private ButtonGroup btnGroup2;
    private boolean kitchenReceipt;
    private OrderInfoView view;
    private KitchenReceiptView kitchenReceiptView;
    private JCheckBox cbTipsSuggestion = new JCheckBox("Show tips suggestion");
    private JComboBox cbModifierColor = new JComboBox();
    private JComboBox cbSeatColor = new JComboBox();
    private JComboBox cbHeaderTextFontFamily = new JComboBox();
    private JComboBox cbHeaderTextFontSize = new JComboBox();
    private JComboBox cbBodyTextFontFamily = new JComboBox();
    private JComboBox cbBodyTextFontSize = new JComboBox();
    private String[] fonts;
    private JComboBox cbCookingInstructionColor = new JComboBox();
    private JCheckBox chkModifierPrice = new JCheckBox("Show modifier price");
    private JCheckBox cbTipsBlock = new JCheckBox("Show tips block");
    private JCheckBox chkTaxBreakDown = new JCheckBox("Show tax breakdown");
    private POSToggleButton btnGuestCheck;
    private POSToggleButton btnGuestCheckCreditCard;
    private JComboBox<ReciptPaperSize> selectPageSize;

    public ReceiptConfigurationView() {
        this(false);
    }

    public ReceiptConfigurationView(boolean kitchenReceipt) {
        this.kitchenReceipt = kitchenReceipt;
        this.initComponents();
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            this.refresh();
            return;
        }
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        ReceiptParam[] receiptParams = ReceiptParam.values();
        this.listParams.setModel(new ListModel<ReceiptParam>(Arrays.asList(receiptParams)));
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String reciptPaperSizeStr = currentTerminal.getProperty("main.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String kitchenPaperSizeStr = currentTerminal.getProperty("kitchen.recipt.paper_size", ReciptPaperSize.Eighty.name());
        if (!this.kitchenReceipt) {
            ReciptPaperSize mainReciptPaperSize = ReciptPaperSize.fromName(reciptPaperSizeStr);
            this.selectPageSize.setSelectedItem((Object)mainReciptPaperSize);
        } else {
            ReciptPaperSize kitchenRecipPaperSize = ReciptPaperSize.fromName(kitchenPaperSizeStr);
            this.selectPageSize.setSelectedItem((Object)kitchenRecipPaperSize);
        }
        if (this.kitchenReceipt) {
            this.initKitchenReceiptPrintPreview();
        } else {
            this.initReceiptPrintPreview();
        }
        this.doUpdateFields();
        this.initialized = true;
    }

    private String getHtmlColorValue(Object selectedItem) {
        String hex = "#000000";
        Color color = Color.black;
        if (selectedItem != null) {
            color = ((SimpleColor)((Object)selectedItem)).color;
        }
        try {
            hex = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hex;
    }

    public boolean save(boolean isContainOrderTypeId) throws Exception {
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        this.ticketHeaderTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        this.orderInfoTextPane.getDocument().putProperty("__EndOfLine__", "<br>");
        this.additionalOrderInfoTextPane.getDocument().putProperty("__EndOfLine__", "<br>");
        this.ticketfooterTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        this.ticketBottomTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        String ticketHeader = this.ticketHeaderTextArea.getText();
        String orderInfo = this.orderInfoTextPane.getText();
        String extraOrderInfo = this.additionalOrderInfoTextPane.getText();
        String footerInfo = this.ticketfooterTextArea.getText();
        String bottomInfo = this.ticketBottomTextArea.getText();
        if (ticketHeader.replaceAll("<br>", "").isEmpty()) {
            ticketHeader = "";
        }
        if (orderInfo.replaceAll("<br>", "").isEmpty()) {
            orderInfo = "";
        }
        if (extraOrderInfo.replaceAll("<br>", "").isEmpty()) {
            extraOrderInfo = "";
        }
        if (footerInfo.replaceAll("<br>", "").isEmpty()) {
            footerInfo = "";
        }
        if (bottomInfo.replaceAll("<br>", "").isEmpty()) {
            bottomInfo = "";
        }
        String orderTypeId = "";
        if (this.selectedOrderType != null && isContainOrderTypeId) {
            orderTypeId = this.selectedOrderType.getId() + ".";
        }
        Map<String, String> properties = this.store.getProperties();
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        ReciptPaperSize selectedPageSize = (ReciptPaperSize)((Object)this.selectPageSize.getSelectedItem());
        if (!this.kitchenReceipt) {
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.header", ticketHeader, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.order.info", orderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.order.extrainfo1", extraOrderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.footer", footerInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.bottom", bottomInfo, 255);
            this.store.addProperty(orderTypeId + "ticket.modifier.color", this.getHtmlColorValue(this.cbModifierColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "ticket.seat.color", this.getHtmlColorValue(this.cbSeatColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "ticket.instruction.color", this.getHtmlColorValue(this.cbCookingInstructionColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "receipt.show_tips_suggestion", String.valueOf(this.cbTipsSuggestion.isSelected()));
            this.store.addProperty(orderTypeId + "receipt.show_tips_block", String.valueOf(this.cbTipsBlock.isSelected()));
            this.store.addProperty(orderTypeId + "receipt.show_tax_breakdown", String.valueOf(this.chkTaxBreakDown.isSelected()));
            boolean isShowModifierPrice = this.chkModifierPrice.isSelected();
            this.store.addProperty("showModifierPrice", String.valueOf(isShowModifierPrice));
            currentTerminal.addProperty("main.recipt.paper_size", selectedPageSize.name());
        } else {
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.header", ticketHeader, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.order.info", orderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.order.extrainfo1", extraOrderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.footer", footerInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.bottom", bottomInfo, 255);
            this.store.addProperty(orderTypeId + "kitchen_ticket.modifier.color", this.getHtmlColorValue(this.cbModifierColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "kitchen_ticket.seat.color", this.getHtmlColorValue(this.cbSeatColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "kitchen_ticket.instruction.color", this.getHtmlColorValue(this.cbCookingInstructionColor.getSelectedItem()));
            currentTerminal.addProperty("kitchen.recipt.paper_size", selectedPageSize.name());
        }
        String storeLogoParam = ReceiptParam.STORE_LOGO.getParamName();
        if (ticketHeader.contains(storeLogoParam) || extraOrderInfo.contains(storeLogoParam) || orderInfo.contains(storeLogoParam) || footerInfo.contains(storeLogoParam) || bottomInfo.contains(storeLogoParam)) {
            POSUtil.storeLongProperty(properties, this.kitchenReceipt ? orderTypeId + "kitchen.header.logo.show" : orderTypeId + "ticket.header.logo.show", "true", 255);
        } else {
            POSUtil.storeLongProperty(properties, this.kitchenReceipt ? orderTypeId + "kitchen.header.logo.show" : orderTypeId + "ticket.header.logo.show", "false", 255);
        }
        TerminalDAO.getInstance().update(currentTerminal);
        StoreDAO.getInstance().saveOrUpdate(this.store);
        Application.getInstance().refreshStore();
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        int size = Application.getPosWindow().getSize().width / 3 + 80;
        int width = PosUIManager.getSize(size);
        int height = PosUIManager.getSize(125);
        int fontSize = PosUIManager.getDefaultFontSize();
        contentPanel.setLayout((LayoutManager)new MigLayout("ins 0 5 0 5 ,wrap 1,filly", "[" + width + "]", "[" + height + "][grow," + height + "][grow," + height + "][grow," + height + "][" + height + "][]"));
        this.listParams = new JList();
        this.listParams.setFocusable(false);
        this.listParams.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReceiptConfigurationView.this.insertReceiptParam();
                }
            }
        });
        JScrollPane listParamScrollPane = new JScrollPane(this.listParams);
        listParamScrollPane.setBorder(BorderFactory.createTitledBorder("Params"));
        listParamScrollPane.setPreferredSize(PosUIManager.getSize(130, 200));
        JPanel westPanel = new JPanel(new BorderLayout());
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        filterPanel.setBorder(BorderFactory.createTitledBorder("Page Size"));
        this.selectPageSize = new JComboBox<ReciptPaperSize>(ReciptPaperSize.values());
        filterPanel.add(this.selectPageSize, "grow");
        westPanel.add((Component)filterPanel, "North");
        westPanel.add((Component)listParamScrollPane, "Center");
        this.add((Component)westPanel, "West");
        this.ticketHeaderTextArea = new JTextPane();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontSize(attributes, fontSize);
        StyleConstants.setAlignment(attributes, 1);
        this.ticketHeaderTextArea.setParagraphAttributes(attributes, true);
        JScrollPane headerSectionScrollPane = new JScrollPane(this.ticketHeaderTextArea);
        headerSectionScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.26")));
        contentPanel.add((Component)headerSectionScrollPane, "grow");
        this.orderInfoTextPane = new JTextPane();
        this.orderInfoTextPane.setParagraphAttributes(attributes, true);
        JScrollPane orderInfoScrollPane = new JScrollPane(this.orderInfoTextPane);
        orderInfoScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.28")));
        contentPanel.add((Component)orderInfoScrollPane, "grow");
        this.additionalOrderInfoTextPane = new JTextPane();
        StyleConstants.setAlignment(attributes, 0);
        this.additionalOrderInfoTextPane.setParagraphAttributes(attributes, true);
        JScrollPane orderExtraInfoScrollPane = new JScrollPane(this.additionalOrderInfoTextPane);
        orderExtraInfoScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.30")));
        contentPanel.add((Component)orderExtraInfoScrollPane, "grow");
        this.ticketBottomTextArea = new JTextPane();
        StyleConstants.setAlignment(attributes, 0);
        this.ticketBottomTextArea.setParagraphAttributes(attributes, true);
        JScrollPane bottomSectionScrollPane = new JScrollPane(this.ticketBottomTextArea);
        bottomSectionScrollPane.setBorder(BorderFactory.createTitledBorder("Bottom Section"));
        contentPanel.add((Component)bottomSectionScrollPane, "grow");
        this.ticketfooterTextArea = new JTextPane();
        StyleConstants.setAlignment(attributes, 1);
        this.ticketfooterTextArea.setParagraphAttributes(attributes, true);
        JScrollPane footerSectionScrollPane = new JScrollPane(this.ticketfooterTextArea);
        footerSectionScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.32")));
        contentPanel.add((Component)footerSectionScrollPane, "grow");
        contentPanel.add((Component)this.createTipsPanel(), "grow");
        contentPanel.add((Component)this.createColorSelectionPanel(), "grow");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        bottomPanel.add((Component)new JSeparator(), "span,growx");
        JButton btnRestoreDefault = new JButton(POSConstants.RESTORE_DEFAULTS);
        btnRestoreDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.35"), POSConstants.CONFIRM) == 1) {
                    return;
                }
                ReceiptConfigurationView.this.populateDefaultReceiptProperties();
            }
        });
        bottomPanel.add((Component)btnRestoreDefault, "split 2,center, gapbottom 0");
        JButton btnOk = new JButton(POSConstants.SAVE);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReceiptConfigurationView.this.save(true);
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                    if (ReceiptConfigurationView.this.kitchenReceipt) {
                        ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(false);
                    } else {
                        ReceiptConfigurationView.this.doShowPrintPriview(false);
                    }
                }
                catch (Exception e1) {
                    BOMessageDialog.showError(e1.getMessage());
                }
            }
        });
        bottomPanel.add(btnOk);
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createTipsPanel() {
        JPanel tipsPanel = new JPanel((LayoutManager)new MigLayout());
        tipsPanel.add(this.cbTipsSuggestion);
        tipsPanel.add(this.chkModifierPrice);
        tipsPanel.add(this.cbTipsBlock);
        tipsPanel.add(this.chkTaxBreakDown);
        return tipsPanel;
    }

    private JPanel createTextSelectionPanel() {
        JPanel textSelectionPanel = new JPanel(new GridLayout(0, 1));
        GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fonts = graphics.getAvailableFontFamilyNames();
        this.cbHeaderTextFontFamily.setModel(new DefaultComboBoxModel<String>(this.fonts));
        this.cbBodyTextFontFamily.setModel(new DefaultComboBoxModel<String>(this.fonts));
        Integer[] sizes = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.cbHeaderTextFontSize.setModel(new DefaultComboBoxModel<Integer>(sizes));
        this.cbBodyTextFontSize.setModel(new DefaultComboBoxModel<Integer>(sizes));
        JPanel headerTextPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        headerTextPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.72")));
        headerTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        headerTextPanel.add(this.cbHeaderTextFontFamily);
        headerTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        headerTextPanel.add(this.cbHeaderTextFontSize);
        JPanel bodyTextPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        bodyTextPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.71")));
        bodyTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        bodyTextPanel.add(this.cbBodyTextFontFamily);
        bodyTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        bodyTextPanel.add(this.cbBodyTextFontSize);
        textSelectionPanel.add((Component)headerTextPanel, "grow, wrap");
        textSelectionPanel.add((Component)bodyTextPanel, "grow");
        return textSelectionPanel;
    }

    private JPanel createColorSelectionPanel() {
        JPanel colorSelectionPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx"));
        colorSelectionPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.9")));
        this.cbModifierColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.cbCookingInstructionColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.cbSeatColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        colorSelectionPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.10")), "split 2");
        colorSelectionPanel.add((Component)this.cbModifierColor, "");
        colorSelectionPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.13")));
        colorSelectionPanel.add((Component)this.cbSeatColor, "");
        colorSelectionPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.15")));
        colorSelectionPanel.add((Component)this.cbCookingInstructionColor, "");
        return colorSelectionPanel;
    }

    private void populateDefaultReceiptProperties() {
        try {
            this.refresh();
            if (this.kitchenReceipt) {
                ReceiptUtil.populateDefaultKitchenReceiptProperties(this.store);
            } else {
                ReceiptUtil.populateDefaultTicketReceiptProperties(this.store);
            }
            this.deleteOrderTypeBasedProperties();
            this.initialized = false;
            this.initialize();
            this.save(false);
            if (this.kitchenReceipt) {
                this.doShowKitchenReceiptPrintPriview(false);
            } else {
                this.doShowPrintPriview(false);
            }
        }
        catch (Exception e1) {
            BOMessageDialog.showError(e1.getMessage());
        }
    }

    private void deleteOrderTypeBasedProperties() {
        if (this.selectedOrderType == null) {
            return;
        }
        String ordertypeId = this.selectedOrderType.getId();
        try {
            Map<String, String> propertyMap = this.store.getProperties();
            if (!this.kitchenReceipt) {
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.header");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.info");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.footer");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.extrainfo1");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.extrainfo2");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.modifier.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.seat.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.instruction.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.header.logo.show");
            } else {
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.header");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.info");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.footer");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.extrainfo1");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.extrainfo2");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.modifier.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.seat.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.instruction.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.header.logo.show");
            }
            StoreDAO.getInstance().saveOrUpdate(this.store);
            Application.getInstance().refreshStore();
        }
        catch (Exception e) {
            PosLog.error(ReceiptConfigurationView.class, e.getMessage(), e);
        }
    }

    private void initReceiptPrintPreview() {
        ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
        try {
            this.view = new OrderInfoView(ticketsToShow);
            this.view.setPreferredSize(PosUIManager.getSize(500, 0));
            this.view.setBorder(new EmptyBorder(8, 0, 5, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.view, "East");
        this.view.add(this.createReceiptViewButtonActionPanel(), "South");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 0 3 0 3", "sg,fill", ""));
        ActionListener reportPreviewAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.orderTypeButtonClicked(e);
            }
        };
        ButtonGroup btnGroup = new ButtonGroup();
        this.selectedOrderType = null;
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        String constraints = "w " + PosUIManager.getSize(90);
        if (orderTypes == null || orderTypes.isEmpty()) {
            this.doShowOrdertypeMissMessage();
            return;
        }
        for (OrderType orderType : orderTypes) {
            POSToggleButton btnOrderType = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
            btnGroup.add(btnOrderType);
            panel.add((Component)btnOrderType, constraints);
            btnOrderType.putClientProperty("orderType", orderType);
            btnOrderType.addActionListener(reportPreviewAction);
            if (this.selectedOrderType != null) continue;
            this.selectedOrderType = orderType;
            btnOrderType.setSelected(true);
            ticketsToShow.add(this.createNewTicket(orderType, null));
        }
        panel.add((Component)new JSeparator(), "gaptop 20");
        this.btnGroup2 = new ButtonGroup();
        this.btnGuestCheck = new POSToggleButton("<html><center>Guest Check</center></html>");
        this.btnGuestCheck.putClientProperty("guestCheck", "cash");
        this.btnGuestCheck.addActionListener(reportPreviewAction);
        this.btnGroup2.add(this.btnGuestCheck);
        panel.add((Component)this.btnGuestCheck, constraints);
        this.btnGuestCheckCreditCard = new POSToggleButton("<html><center>Guest Check (Credit Card)</center><html>");
        this.btnGuestCheckCreditCard.putClientProperty("guestCheck", "creditCard");
        this.btnGuestCheckCreditCard.addActionListener(reportPreviewAction);
        this.btnGroup2.add(this.btnGuestCheckCreditCard);
        panel.add((Component)this.btnGuestCheckCreditCard, constraints);
        this.view.add((Component)panel, "East");
        this.doShowPrintPriview(false);
    }

    private String getProperty(String orderTypeId, String propertyName) {
        String property;
        if (StringUtils.isNotEmpty((String)orderTypeId)) {
            orderTypeId = orderTypeId + ".";
        }
        if (StringUtils.isEmpty((String)(property = this.store.getProperty(orderTypeId + propertyName)))) {
            property = this.store.getProperty(propertyName);
        }
        return property;
    }

    private void doUpdateFields() {
        String ticketHeader = "";
        String orderInfo = "";
        String additionalOrderInfo = "";
        String footerInfo = "";
        String orderTypeId = "";
        if (this.selectedOrderType != null) {
            orderTypeId = this.selectedOrderType.getId();
        }
        if (!this.kitchenReceipt) {
            ticketHeader = ReceiptUtil.getReceiptSection(this.store, "ticket.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.order.info", orderTypeId);
            additionalOrderInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.order.extrainfo1", orderTypeId);
            footerInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.footer", orderTypeId);
            this.cbModifierColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.modifier.color")));
            this.cbSeatColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.seat.color")));
            this.cbCookingInstructionColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.instruction.color")));
            boolean isShowTips = this.store.getProperty(orderTypeId + "." + "receipt.show_tips_suggestion") == null ? false : Boolean.valueOf(this.store.getProperty(orderTypeId + "." + "receipt.show_tips_suggestion"));
            this.cbTipsSuggestion.setSelected(isShowTips);
            boolean isShowModifierPrice = this.store.getProperty("showModifierPrice") == null ? false : Boolean.valueOf(this.store.getProperty("showModifierPrice"));
            this.chkModifierPrice.setSelected(isShowModifierPrice);
            boolean isShowTipsBlock = this.store.getProperty(orderTypeId + "." + "receipt.show_tips_block") == null ? false : Boolean.valueOf(this.store.getProperty(orderTypeId + "." + "receipt.show_tips_block"));
            this.cbTipsBlock.setSelected(isShowTipsBlock);
            boolean isShowTaxBreakdown = this.store.getProperty(orderTypeId + "." + "receipt.show_tax_breakdown") == null ? false : Boolean.valueOf(this.store.getProperty(orderTypeId + "." + "receipt.show_tax_breakdown"));
            this.chkTaxBreakDown.setSelected(isShowTaxBreakdown);
        } else {
            ticketHeader = ReceiptUtil.getReceiptSection(this.store, "kitchen.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.order.info", orderTypeId);
            additionalOrderInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.order.extrainfo1", orderTypeId);
            footerInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.footer", orderTypeId);
            this.cbModifierColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.modifier.color")));
            this.cbSeatColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.seat.color")));
            this.cbCookingInstructionColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.instruction.color")));
        }
        this.chkModifierPrice.setVisible(!this.kitchenReceipt);
        ticketHeader = ticketHeader.replaceAll("<br>", "\n");
        orderInfo = orderInfo.replaceAll("<br>", "\n");
        additionalOrderInfo = additionalOrderInfo.replaceAll("<br>", "\n");
        footerInfo = footerInfo.replaceAll("<br>", "\n");
        this.ticketHeaderTextArea.setText(ticketHeader);
        this.orderInfoTextPane.setText(orderInfo);
        this.additionalOrderInfoTextPane.setText(additionalOrderInfo);
        this.ticketfooterTextArea.setText(footerInfo);
    }

    private void initKitchenReceiptPrintPreview() {
        try {
            this.kitchenReceiptView = new KitchenReceiptView();
            this.kitchenReceiptView.setBorder(new EmptyBorder(8, 0, 5, 0));
            this.kitchenReceiptView.setPreferredSize(PosUIManager.getSize(500, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.kitchenReceiptView, "East");
        this.kitchenReceiptView.add(this.createReceiptViewButtonActionPanel(), "South");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 0 3 0 3", "sg,fill", ""));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                POSToggleButton source = (POSToggleButton)e.getSource();
                OrderType clientProperty = (OrderType)source.getClientProperty("orderType");
                if (clientProperty != null) {
                    ReceiptConfigurationView.this.selectedOrderType = clientProperty;
                }
                ReceiptConfigurationView.this.doUpdateFields();
                ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(true);
            }
        };
        ButtonGroup btnGroup = new ButtonGroup();
        this.selectedOrderType = null;
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        if (orderTypes == null || orderTypes.isEmpty()) {
            this.doShowOrdertypeMissMessage();
            return;
        }
        for (OrderType orderType : orderTypes) {
            POSToggleButton btnOrderType = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
            btnGroup.add(btnOrderType);
            String constraints = "w " + PosUIManager.getSize(90);
            panel.add((Component)btnOrderType, constraints);
            btnOrderType.putClientProperty("orderType", orderType);
            btnOrderType.addActionListener(listener);
            if (this.selectedOrderType != null) continue;
            this.selectedOrderType = orderType;
            btnOrderType.setSelected(true);
        }
        this.kitchenReceiptView.add((Component)panel, "East");
        this.doShowKitchenReceiptPrintPriview(false);
    }

    private void doShowOrdertypeMissMessage() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.66"));
        this.removeAll();
    }

    private Component createReceiptViewButtonActionPanel() {
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 0 5"));
        JButton btnPrintPreview = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        btnPrintPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceiptConfigurationView.this.kitchenReceipt) {
                    ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(true);
                } else {
                    ReceiptConfigurationView.this.doShowPrintPriview(true);
                }
            }
        });
        JButton btnPrintTestPage = new JButton(Messages.getString("ReceiptConfigurationView.65"));
        btnPrintTestPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReceiptConfigurationView.this.save(false);
                    if (ReceiptConfigurationView.this.kitchenReceipt) {
                        ReceiptConfigurationView.this.kitchenReceiptView.print();
                    } else {
                        ReceiptConfigurationView.this.view.print();
                    }
                }
                catch (Exception e1) {
                    BOMessageDialog.showError(e1.getMessage());
                }
            }
        });
        bottomPanel.add((Component)btnPrintPreview, "gapleft 100!,split 2");
        bottomPanel.add(btnPrintTestPage);
        return bottomPanel;
    }

    private void doShowPrintPriview(boolean save) {
        try {
            block13: {
                if (save) {
                    this.save(true);
                }
                if (this.btnGuestCheckCreditCard.isSelected() || this.btnGuestCheck.isSelected()) {
                    String guestCheckType = null;
                    if (this.btnGuestCheck.isSelected()) {
                        guestCheckType = (String)this.btnGuestCheck.getClientProperty("guestCheck");
                    } else if (this.btnGuestCheckCreditCard.isSelected()) {
                        guestCheckType = (String)this.btnGuestCheckCreditCard.getClientProperty("guestCheck");
                    }
                    ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
                    Ticket createNewTicket = this.createNewTicket(this.selectedOrderType, guestCheckType);
                    ticketsToShow.add(createNewTicket);
                    this.doUpdateFields();
                    this.view.setTickets(ticketsToShow);
                    try {
                        this.view.getReportPanel().removeAll();
                        if (guestCheckType == null) {
                            this.view.createReport();
                            break block13;
                        }
                        this.view.createReport(createNewTicket.getTransactions().iterator().next());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
                    Ticket createNewTicket = this.createNewTicket(this.selectedOrderType, null);
                    ticketsToShow.add(createNewTicket);
                    this.view.setTickets(ticketsToShow);
                    try {
                        this.view.getReportPanel().removeAll();
                        this.view.createReport();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            this.view.revalidate();
            this.view.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doShowKitchenReceiptPrintPriview(boolean save) {
        try {
            if (save) {
                this.save(true);
            }
            Ticket createNewTicket = this.createNewTicket(this.selectedOrderType, null);
            try {
                this.kitchenReceiptView.getReportPanel().removeAll();
                this.kitchenReceiptView.createReport(createNewTicket);
                this.kitchenReceiptView.revalidate();
                this.kitchenReceiptView.repaint();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public Ticket createNewTicket(OrderType ticketType, String guestCheckType) {
        SalesArea salesArea;
        int numberOfGuests = 4;
        Date deliveryDate = null;
        boolean customerWillPickUp = false;
        String shippingAddress = null;
        String extraDeliveryInfo = null;
        String phoneExtension = null;
        String extraManagerInstruction = null;
        Double deliveryChargeAmount = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId("121");
        customer.setSignatureImageId("sig111");
        if (ticketType.isDelivery().booleanValue()) {
            deliveryDate = new Date();
            shippingAddress = "Customer address.....";
            extraDeliveryInfo = Messages.getString("ReceiptConfigurationView.70");
            phoneExtension = "Phone extension..";
            extraManagerInstruction = "Manager instructions..";
            customerWillPickUp = false;
            deliveryChargeAmount = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(ticketType);
        ticket.setNumberOfGuests(numberOfGuests);
        if (customerWillPickUp) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(deliveryDate);
            ticket.setDeliveryAddress(shippingAddress);
            ticket.setExtraDeliveryInfo(extraDeliveryInfo);
            ticket.addProperty("PHONE_EXTENSION", phoneExtension);
            ticket.addProperty("MANAGER_INSTRUCTION", extraManagerInstruction);
            ticket.setDeliveryCharge(deliveryChargeAmount);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User currentUser = Application.getCurrentUser();
        ticket.setOwner(currentUser);
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (this.selectedOrderType.isShowTableSelection().booleanValue()) {
            ArrayList<Integer> tables = new ArrayList<Integer>();
            tables.add(1);
            tables.add(2);
            ticket.setTableNumbers(tables);
        }
        Calendar currentTime = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(currentTime.getTime());
        ticket.setCreationHour(currentTime.get(11));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax1 = new TicketItemTax();
        ticketItemTax1.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax1.setName("US");
        ticketItemTax1.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName("BD");
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            TicketItemSeat seatItem;
            ModifiableTicketItem item = new ModifiableTicketItem();
            item.setId(NumericGlobalIdGenerator.generateGlobalId());
            item.setMenuItemId("0");
            item.setName("Item " + (i + 1));
            item.setQuantity((double)i + 1.0);
            item.setUnitPrice(2.5);
            item.setShouldPrintToKitchen(true);
            item.setTaxes(Arrays.asList(ticketItemTax1, ticketItemTax2));
            if (ticketType.isEnableCourse().booleanValue()) {
                Course course = new Course("C" + (i + 1));
                course.setShortName("C" + (i + 1));
                item.setCourseName("C" + (i + 1));
            }
            ticket.addToticketItems(item);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    TicketItemModifier newModifier = new TicketItemModifier();
                    newModifier.setId(NumericGlobalIdGenerator.generateGlobalId());
                    newModifier.setItemId("0");
                    newModifier.setGroupId("0");
                    newModifier.setItemQuantity(2.0);
                    newModifier.setName("Modifier " + (j + 1));
                    newModifier.setUnitPrice(1.5);
                    newModifier.setShouldPrintToKitchen(true);
                    newModifier.setTicketItem(item);
                    item.addToticketItemModifiers(newModifier);
                }
            } else if (i == 2) {
                TicketItemCookingInstruction cookingInstruction = new TicketItemCookingInstruction();
                cookingInstruction.setDescription("Fry (Cooking Ins.)");
                item.addCookingInstruction(cookingInstruction);
            }
            if (i == 2) {
                TicketItem seatTicketItem = new TicketItem();
                seatItem = new TicketItemSeat();
                seatTicketItem.setName("Seat** 1");
                seatTicketItem.setShouldPrintToKitchen(true);
                seatTicketItem.setTreatAsSeat(true);
                seatTicketItem.setSeatNumber(1);
                seatTicketItem.setPrintedToKitchen(false);
                seatTicketItem.setShouldPrintToKitchen(true);
                seatTicketItem.setSeat(seatItem);
                seatItem.setSeatNumber(1);
                ticket.addToticketItems(seatTicketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem seatTicketItem = new TicketItem();
            seatItem = new TicketItemSeat();
            seatTicketItem.setName("Seat** Shared");
            seatTicketItem.setShouldPrintToKitchen(true);
            seatTicketItem.setTreatAsSeat(true);
            seatTicketItem.setSeatNumber(null);
            seatTicketItem.setPrintedToKitchen(false);
            seatTicketItem.setShouldPrintToKitchen(true);
            seatTicketItem.setSeat(seatItem);
            seatItem.setSeatNumber(1);
            ticket.addToticketItems(seatTicketItem);
        }
        ticket.calculatePrice();
        PosTransaction transaction = null;
        PaymentType paymentType = null;
        if (guestCheckType != null && guestCheckType.equals("creditCard")) {
            paymentType = PaymentType.CREDIT_CARD;
            transaction = paymentType.createTransaction();
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway("Payment gateway name..");
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName("Card holder name");
            transaction.setCardNumber("4111111111111111");
            transaction.setCardExpMonth("12");
            transaction.setCardExpYear("2020");
            transaction.setCardType(CardTypeEnum.VISA.name());
            transaction.setCardAuthCode("00000");
            transaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(currentUser);
        } else {
            paymentType = PaymentType.CASH;
            transaction = paymentType.createTransaction();
        }
        transaction.setTenderAmount(ticket.getDueAmount());
        transaction.setAmount(ticket.getDueAmount());
        transaction.setTicket(ticket);
        ticket.addTotransactions(transaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
        if (ticket.isSourceOnline()) {
            ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
        } else {
            ticket.calculatePrice();
        }
        Date currentDate = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        transaction.setTerminal(terminal);
        transaction.setUser(currentUser);
        transaction.setServer(currentUser);
        transaction.setTransactionTime(currentDate);
        return ticket;
    }

    private void insertReceiptParam() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent textComponent = null;
        if (!(focusOwner instanceof JTextComponent)) {
            return;
        }
        textComponent = (JTextComponent)focusOwner;
        ReceiptParam receiptParam = this.listParams.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String text = "<" + receiptParam.getParamName() + ">$" + receiptParam.getParamName() + "</" + receiptParam.getParamName() + ">";
        textComponent.replaceSelection(text);
    }

    private void refresh() {
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
    }

    private void orderTypeButtonClicked(ActionEvent e) {
        try {
            String guestCheckType;
            POSToggleButton source = (POSToggleButton)e.getSource();
            OrderType clientProperty = (OrderType)source.getClientProperty("orderType");
            if (clientProperty != null) {
                this.selectedOrderType = clientProperty;
            }
            if (StringUtils.isEmpty((String)(guestCheckType = (String)source.getClientProperty("guestCheck")))) {
                guestCheckType = null;
                this.btnGroup2.clearSelection();
            }
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            Ticket createNewTicket = this.createNewTicket(this.selectedOrderType, guestCheckType);
            ticketsToShow.add(createNewTicket);
            this.doUpdateFields();
            this.view.setTickets(ticketsToShow);
            this.view.getReportPanel().removeAll();
            if (guestCheckType == null) {
                this.view.createReport();
            } else {
                this.view.createReport(createNewTicket.getTransactions().iterator().next());
            }
            this.view.revalidate();
            this.view.repaint();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, e1.getMessage(), e1);
        }
    }

    static enum SimpleColor {
        black(Color.black),
        red(Color.red);

        final Color color;

        private SimpleColor(Color color) {
            this.color = color;
        }

        public static SimpleColor getColor(String value) {
            Color color = SimpleColor.getAwtColor(value);
            if (color != null) {
                for (SimpleColor simpleColor : SimpleColor.values()) {
                    if (simpleColor.color.getRGB() != color.getRGB()) continue;
                    return simpleColor;
                }
            }
            return black;
        }

        public static Color getAwtColor(String propertyValue) {
            try {
                return Color.decode(propertyValue);
            }
            catch (Exception exception) {
                return Color.black;
            }
        }

        static String[] listModel() {
            List<SimpleColor> values = Arrays.asList(SimpleColor.values());
            String s = values.toString().replaceAll(" ", "");
            return s.substring(1, s.length() - 1).split(",");
        }
    }

    public class KitchenReceiptView
    extends JPanel {
        private JPanel reportPanel;
        private Ticket ticket;

        public KitchenReceiptView() {
            this.createUI();
        }

        public void createUI() {
            this.reportPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            PosScrollPane scrollPane = new PosScrollPane(this.reportPanel);
            scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add(scrollPane);
        }

        public void createReport(Ticket ticket) throws Exception {
            this.ticket = ticket;
            JasperPrint jasperPrint = ReceiptPrintService.getKitchenJasperPrint(ticket, true, true);
            TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
            this.reportPanel.add(receiptView.getReportPanel());
        }

        public void print() throws Exception {
            ReceiptPrintService.printToKitchen(this.ticket, false, false);
        }

        public JPanel getReportPanel() {
            return this.reportPanel;
        }
    }
}

