/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Address;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class StoreConfigurationView
extends ConfigurationView {
    private Store store;
    private FixedLengthTextField tfRestaurantName;
    private FixedLengthTextField tfOutletName;
    private FixedLengthTextField tfAddressLine1;
    private FixedLengthTextField tfAddressLine2;
    private FixedLengthTextField tfAddressLine3;
    private POSTextField tfTelephone;
    private JTextField tfZipCode;

    public StoreConfigurationView(Store store) {
        this.store = store;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][][grow]", ""));
        JLabel lblNewLabel = new JLabel(Messages.getString("RestaurantConfigurationView.3") + ":");
        contentPanel.add((Component)lblNewLabel, "cell 0 1,alignx trailing");
        this.tfRestaurantName = new FixedLengthTextField();
        this.tfRestaurantName.setLength(120);
        contentPanel.add((Component)this.tfRestaurantName, "cell 1 1 3 1,growx");
        JLabel lblOutletName = new JLabel("Outlet Name:");
        contentPanel.add((Component)lblOutletName, "cell 0 2,alignx trailing");
        this.tfOutletName = new FixedLengthTextField();
        this.tfOutletName.setLength(120);
        contentPanel.add((Component)this.tfOutletName, "cell 1 2 3 1,growx");
        JLabel lblAddressLine = new JLabel(Messages.getString("RestaurantConfigurationView.7") + ":");
        contentPanel.add((Component)lblAddressLine, "cell 0 3,alignx trailing");
        this.tfAddressLine1 = new FixedLengthTextField();
        this.tfAddressLine1.setLength(60);
        contentPanel.add((Component)this.tfAddressLine1, "cell 1 3 3 1,growx");
        JLabel lblAddressLine_1 = new JLabel(Messages.getString("RestaurantConfigurationView.11") + ":");
        contentPanel.add((Component)lblAddressLine_1, "cell 0 4,alignx trailing");
        this.tfAddressLine2 = new FixedLengthTextField();
        this.tfAddressLine2.setLength(60);
        contentPanel.add((Component)this.tfAddressLine2, "cell 1 4 3 1,growx");
        JLabel lblAddressLine_2 = new JLabel(Messages.getString("RestaurantConfigurationView.15") + ":");
        contentPanel.add((Component)lblAddressLine_2, "cell 0 5,alignx trailing");
        this.tfAddressLine3 = new FixedLengthTextField();
        this.tfAddressLine3.setLength(60);
        contentPanel.add((Component)this.tfAddressLine3, "cell 1 5 3 1,growx");
        JLabel lblZipCode = new JLabel(Messages.getString("RestaurantConfigurationView.19"));
        contentPanel.add((Component)lblZipCode, "cell 0 6,alignx trailing");
        this.tfZipCode = new JTextField();
        contentPanel.add((Component)this.tfZipCode, "cell 1 6,growx");
        this.tfZipCode.setColumns(10);
        JLabel lblPhone = new JLabel(Messages.getString("RestaurantConfigurationView.22"));
        contentPanel.add((Component)lblPhone, "cell 0 7,alignx trailing");
        this.tfTelephone = new POSTextField();
        contentPanel.add((Component)this.tfTelephone, "cell 1 7,growx");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        String name = null;
        String addr1 = null;
        String addr2 = null;
        String addr3 = null;
        String telephone = null;
        name = this.tfRestaurantName.getText();
        addr1 = this.tfAddressLine1.getText();
        addr2 = this.tfAddressLine2.getText();
        addr3 = this.tfAddressLine3.getText();
        telephone = this.tfTelephone.getText();
        this.store.setName(name);
        this.store.setOutletName(this.tfOutletName.getText());
        this.store.setAddressLine1(addr1);
        this.store.setAddressLine2(addr2);
        this.store.setAddressLine3(addr3);
        this.store.setZipCode(this.tfZipCode.getText());
        this.store.setTelephone(telephone);
        Address address = new Address();
        address.setAddressLine(addr1);
        address.setStreet(addr2);
        address.setCity(addr3);
        address.setZipCode(this.tfZipCode.getText());
        if (this.store.getAddress() == null) {
            AddressDAO.getInstance().save(address);
        } else {
            String addressId = this.store.getAddress().getId();
            address = AddressDAO.getInstance().findAddressById(addressId);
            address.setAddressLine(this.store.getAddressLine1());
            address.setStreet(this.store.getAddressLine2());
            address.setCity(this.store.getAddressLine3());
            address.setZipCode(this.store.getZipCode());
            AddressDAO.getInstance().update(address);
        }
        this.store.setAddress(address);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.tfRestaurantName.setText(this.store.getName());
        this.tfOutletName.setText(this.store.getOutletName());
        this.tfAddressLine1.setText(this.store.getAddressLine1());
        this.tfAddressLine2.setText(this.store.getAddressLine2());
        this.tfAddressLine3.setText(this.store.getAddressLine3());
        this.tfZipCode.setText(this.store.getZipCode());
        this.tfTelephone.setText(this.store.getTelephone());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }
}

