/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class CustomerExplorer
extends TransparentPanel {
    private JTable table;
    private BeanTableModel<Customer> tableModel;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JTextField tfSearch;

    public CustomerExplorer() {
        this.initComponents();
        this.updateCustomer();
    }

    private void updateCustomer() {
        String searchString = this.tfSearch.getText();
        CustomerDAO.getInstance().findByPhoneOrName(searchString, this.tableModel);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    private void initComponents() {
        this.tableModel = new BeanTableModel(Customer.class, 50);
        this.tableModel.addColumn("NAME", "name");
        this.tableModel.addColumn("PHONE", "mobileNo");
        this.tableModel.addColumn("EMAIL", "email");
        this.tableModel.addColumn("ADDRESS", "address");
        this.tableModel.addColumn("CITY", "city");
        this.tableModel.addColumn("COUNTRY", "country");
        this.tableModel.addColumn("BALANCE", "balance");
        this.tableModel.addColumn("CREDIT LIMIT", "creditLimit");
        this.tableModel.addColumn("LOYALTY", "loyaltyNo");
        this.tableModel.addColumn("VIP", "vip");
        this.tableModel.addColumn("TAX EXEMPT", "taxExempt");
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        PosGuiUtil.setColumnWidth(this.table, 0, 150);
        PosGuiUtil.setColumnWidth(this.table, 1, 150);
        PosGuiUtil.setColumnWidth(this.table, 2, 120);
        PosGuiUtil.setColumnWidth(this.table, 3, 150);
        PosGuiUtil.setColumnWidth(this.table, 4, 100);
        PosGuiUtil.setColumnWidth(this.table, 5, 100);
        PosGuiUtil.setColumnWidth(this.table, 6, 35);
        PosGuiUtil.setColumnWidth(this.table, 7, 55);
        PosGuiUtil.setColumnWidth(this.table, 8, 30);
        PosGuiUtil.setColumnWidth(this.table, 9, 20);
        PosGuiUtil.setColumnWidth(this.table, 10, 50);
        this.setLayout(new BorderLayout(5, 0));
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 10"));
        JLabel lblSearchTxt = new JLabel("Name: ");
        this.tfSearch = new JTextField(20);
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.updateCustomer();
            }
        });
        JButton btnSearch = new JButton("Search");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.updateCustomer();
            }
        });
        JButton btnClear = new JButton("Clear");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.tfSearch.setText("");
                CustomerExplorer.this.updateCustomer();
            }
        });
        searchPanel.add((Component)lblSearchTxt, "split 4");
        searchPanel.add((Component)this.tfSearch, "");
        searchPanel.add(btnSearch);
        searchPanel.add(btnClear);
        this.add((Component)searchPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.doAddCustomer();
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.doEditCustomer();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.doDeleteCustomer();
            }
        });
        this.btnBack = new JButton("<<< Previous");
        this.btnForward = new JButton("Next >>>");
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.tableModel.setCurrentRowIndex(CustomerExplorer.this.tableModel.getPreviousRowIndex());
                CustomerExplorer.this.updateCustomer();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerExplorer.this.tableModel.setCurrentRowIndex(CustomerExplorer.this.tableModel.getNextRowIndex());
                CustomerExplorer.this.updateCustomer();
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        panel.add((Component)addButton, "right, split 3");
        panel.add(editButton);
        panel.add(deleteButton);
        panel.add((Component)this.lblNumberOfItem, "right, split 3");
        panel.add(this.btnBack);
        panel.add(this.btnForward);
        this.add((Component)panel, "South");
    }

    private void doAddCustomer() {
        try {
            boolean setKeyPad = true;
            CustomerForm editor = new CustomerForm(setKeyPad);
            editor.enableCustomerFields(true);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog dialog = new BeanEditorDialog(windowAncestor, (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(960, 700));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            Customer customer = (Customer)editor.getBean();
            this.tableModel.addRow(customer);
            this.updateCustomer();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEditCustomer() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            Customer customer = this.tableModel.getRow(index);
            boolean setKeyPad = true;
            CustomerForm editor = new CustomerForm(setKeyPad);
            editor.enableCustomerFields(true);
            editor.setBean(customer);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog dialog = new BeanEditorDialog(windowAncestor, (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(960, 700));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteCustomer() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Customer customer = this.tableModel.getRow(index);
                CustomerDAO dao = new CustomerDAO();
                dao.delete(customer);
                this.tableModel.removeRow(customer);
                this.updateCustomer();
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

