/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Main {
    private static final String DEVELOPMENT_MODE = "developmentMode";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(DEVELOPMENT_MODE, true, "State if this is developmentMode");
        BasicParser parser = new BasicParser();
        CommandLine commandLine = parser.parse(options, args);
        String optionValue = commandLine.getOptionValue(DEVELOPMENT_MODE);
        Locale defaultLocale = TerminalConfig.getDefaultLocale();
        if (defaultLocale != null) {
            // empty if block
        }
        Application application = Application.getInstance();
        if (optionValue != null) {
            application.setDevelopmentMode(Boolean.valueOf(optionValue));
        }
        application.start();
    }

    public static void restart() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String classPath = System.getProperty("java.class.path");
            String mainClass = System.getProperty("sun.java.command");
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-cp");
            command.add(classPath);
            command.add(mainClass);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            System.exit(0);
        }
        catch (Exception e) {
            PosLog.error(Main.class, e);
        }
    }
}

