/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseImageResource;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;

public class ImageResource
extends BaseImageResource {
    private static final long serialVersionUID = 1L;
    private Image image;

    public ImageResource() {
    }

    public ImageResource(String id) {
        super(id);
    }

    public IMAGE_CATEGORY getImageCategory() {
        return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
    }

    public void setImageCategory(IMAGE_CATEGORY imageCategory) {
        super.setImageCategoryNum(imageCategory.getType());
    }

    @Override
    public void setImageData(Blob imageData) {
        super.setImageData(imageData);
        if (imageData != null) {
            try {
                int blobLength = (int)imageData.length();
                this.image = new ImageIcon(imageData.getBytes(1L, blobLength)).getImage();
            }
            catch (SQLException e) {
                PosLog.error(this.getClass(), e);
            }
        }
    }

    public ImageIcon getScaledImage(int w, int h) {
        Image scaledInstance = null;
        if (this.image != null) {
            scaledInstance = this.image.getScaledInstance(w, h, 4);
            return new ImageIcon(scaledInstance);
        }
        return null;
    }

    public Image getImage() {
        return this.image;
    }

    public ImageIcon getAsIcon() {
        if (this.image == null) {
            return null;
        }
        return new ImageIcon(this.image.getScaledInstance(80, 80, 1));
    }

    public static enum IMAGE_CATEGORY {
        UNLISTED(0),
        FLOORPLAN(1),
        PRODUCTS(2),
        PEOPLE(3),
        DELETED(4);

        private int type;

        private IMAGE_CATEGORY(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public static IMAGE_CATEGORY fromInt(int type) {
            IMAGE_CATEGORY[] values;
            for (IMAGE_CATEGORY cat : values = IMAGE_CATEGORY.values()) {
                if (cat.type != type) continue;
                return cat;
            }
            return UNLISTED;
        }
    }
}

