/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={})
public class InventoryUnit
extends BaseInventoryUnit
implements IUnit {
    private static final long serialVersionUID = 1L;
    private InventoryUnitGroup unitGroup;

    public InventoryUnit() {
    }

    public InventoryUnit(String id) {
        super(id);
    }

    public InventoryUnit(String id, String code) {
        super(id, code);
    }

    @Override
    public String toString() {
        return this.getCode();
    }

    @Override
    @JsonIgnore
    public String getUniqueCode() {
        return super.getCode();
    }

    @XmlTransient
    public InventoryUnitGroup getUnitGroup() {
        String unitGroupId = this.getUnitGroupId();
        if (StringUtils.isEmpty((String)unitGroupId)) {
            return null;
        }
        if (this.unitGroup != null && unitGroupId.equals(this.unitGroup.getId())) {
            return this.unitGroup;
        }
        this.unitGroup = InventoryUnitGroupDAO.getInstance().get(unitGroupId);
        return this.unitGroup;
    }

    public void setUnitGroup(InventoryUnitGroup unitGroup) {
        this.unitGroup = unitGroup;
    }

    public String getUniqueId() {
        return ("unit_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getBaseUnitConversionValue() {
        double baseConversionValue = 0.0;
        List<InventoryUnit> units = this.getUnitGroup().getUnits();
        if (units != null && units.size() > 0) {
            for (InventoryUnit groupUnit : units) {
                if (!groupUnit.isBaseUnit().booleanValue()) continue;
                baseConversionValue = groupUnit.getConversionRate();
                break;
            }
        }
        return baseConversionValue * this.getConversionRate();
    }
}

