/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.base.BaseMenuGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import java.awt.Color;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "discounts", "menuPages"})
@XmlRootElement(name="menu-group")
public class MenuGroup
extends BaseMenuGroup
implements IdContainer {
    private static final long serialVersionUID = 1L;
    private Color buttonColor;
    private Color textColor;

    public MenuGroup() {
    }

    public MenuGroup(String id) {
        super(id);
    }

    public MenuGroup(String id, String name) {
        super(id, name);
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null || this.getButtonColorCode() == 0) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    public void setMenuCategory(MenuCategory category) {
        if (category == null) {
            this.setMenuCategoryId(null);
            this.setMenuCategoryName(null);
            this.setBeverage(false);
        } else {
            this.setMenuCategoryId(category.getId());
            this.setMenuCategoryName(category.getDisplayName());
            this.setBeverage(category.isBeverage());
        }
    }

    public void setParent(MenuCategory category) {
        this.setMenuCategory(category);
    }

    @XmlTransient
    public MenuCategory getParent() {
        String categoryId = this.getMenuCategoryId();
        if (StringUtils.isNotEmpty((String)categoryId)) {
            return MenuCategoryDAO.getInstance().get(categoryId);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public String getUniqueId() {
        return ("menu_group_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }
}

