/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "image", "orderTypeList", "properties", "menuItemModiferSpecs", "pizzaPriceList", "discounts", "variants", "comboGroups", "comboItems", "stockUnits", "terminals", "recepieItems", "units", "sizes", "attributes", "variantName"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MenuItem
extends BaseMenuItem {
    private static final long serialVersionUID = 1L;
    public static final String TRANSIENT_PROP_VENDOR_NAME = "vendorNames";
    private transient String vendorNames;
    @XmlTransient
    private Color buttonColor;
    @XmlTransient
    private Color textColor;
    @XmlTransient
    private ImageIcon image;
    private Double priceRulePrice;
    private MenuItem parentMenuItem;
    private MenuItemInventoryStatus stockStatus;
    public static final String TYPE_RAW_METARIAL = "Raw Material";
    public static final String TYPE_INVENTORY_ITEM = "Inventory Item";
    public static final String TYPE_MENU_ITEM = "Menu Item";
    private transient JSONObject properties;

    public MenuItem() {
    }

    public MenuItem(String id) {
        super(id);
    }

    public MenuItem(String id, String name, Double price) {
        super(id, name, price);
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 80, 80);
    }

    public ImageIcon getImage(int w, int h) {
        return IconFactory.getIconFromImageResource(this.getImageId(), w - 20, h - 20);
    }

    public ImageIcon getScaledImageIcon(int w, int h) {
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(this.getImageId());
        if (imageResource != null) {
            this.image = new ImageIcon(imageResource.getImage().getScaledInstance(w, h, 1));
        }
        return this.image;
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null && this.buttonColor.getRGB() == this.getButtonColorCode().intValue()) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null && this.textColor.getRGB() == this.getTextColorCode().intValue()) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @XmlTransient
    public String getDisplayName() {
        if (StringUtils.isNotEmpty((String)super.getTranslatedName())) {
            return super.getTranslatedName();
        }
        String name = super.getName();
        return name;
    }

    @XmlTransient
    public String getVariantName() {
        String name = super.getName();
        List<Attribute> attributes = this.getAttributes();
        if (attributes == null) {
            return name;
        }
        name = name + " (";
        Iterator<Attribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            name = name + attribute.getName();
            if (!iterator.hasNext()) continue;
            name = name + ", ";
        }
        name = name + ")";
        return name;
    }

    public void setVariantName(String variantName) {
    }

    public void setDisplayName(String displayName) {
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String getUniqueId() {
        return ("menu_item_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public TicketItem convertToTicketItem(Ticket ticket, double itemQuantity) {
        return this.convertToTicketItem(ticket, itemQuantity, false);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double itemQuantity, boolean hasComboModifiers) {
        Customer customer;
        TicketItem ticketItem = null;
        MenuItem menuItem = this;
        boolean isComboItem = this.isComboItem();
        Terminal terminal = Application.getInstance().getTerminal();
        Department department = terminal.getDepartment();
        SalesArea salesArea = null;
        OrderType orderType = null;
        String customerId = null;
        CustomerGroup customerGroup = null;
        if (this.isVariant().booleanValue()) {
            menuItem = this.getParentMenuItem();
            isComboItem = menuItem.isComboItem();
        }
        ticketItem = isComboItem ? new ComboTicketItem() : (menuItem.isPizzaType() != false || menuItem.hasModifiers() || hasComboModifiers ? new ModifiableTicketItem() : new TicketItem());
        ticketItem.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        if (ticket != null) {
            orderType = ticket.getOrderType();
            salesArea = ticket.getSalesArea();
            customerId = ticket.getCustomerId();
        }
        if (orderType != null && orderType.isEnableCourse().booleanValue()) {
            String courseId = menuItem.getCourseOrganizeId();
            ticketItem.setCourseId(courseId);
            if (StringUtils.isNotEmpty((String)courseId)) {
                Course course = DataProvider.get().getCourse(courseId);
                ticketItem.setCourseName(course.getShortName());
            }
        }
        if (customerId != null && (customer = DataProvider.get().getCustomer(customerId)) != null) {
            customerGroup = customer.getCustomerGroup();
        }
        ticketItem.setMenuItemId(this.getId());
        ticketItem.setMenuItem(this);
        ticketItem.setComboItem(menuItem.isComboItem());
        ticketItem.setPizzaType(this.isPizzaType());
        ticketItem.setFractionalUnit(menuItem.isFractionalUnit());
        if (menuItem.isFractionalUnit().booleanValue()) {
            ticketItem.setQuantity(itemQuantity);
            ticketItem.setUnitName(menuItem.getUnitName());
        } else {
            ticketItem.setQuantity(itemQuantity);
        }
        ticketItem.setName(this.getDisplayName());
        ticketItem.setGroupId(menuItem.getMenuGroupId());
        ticketItem.setGroupName(menuItem.getMenuGroupName());
        ticketItem.setCategoryName(menuItem.getMenuCategoryName());
        ticketItem.setCategoryId(menuItem.getMenuCategoryId());
        ticketItem.setServiceChargeApplicable(menuItem.isServiceChargeApplicable());
        ticketItem.setServiceChargeRate(menuItem.getServiceCharge());
        ticketItem.setTaxOnServiceCharge(menuItem.isTaxOnServiceCharge());
        if (this.priceRulePrice == null) {
            this.priceRulePrice = DataProvider.get().getPriceFromPriceRule(this, ticket.getOrderType(), department, salesArea, customerGroup);
        }
        if (this.isVariant().booleanValue()) {
            ticketItem.setUnitPrice(this.priceRulePrice + this.getParentMenuItem().getPrice());
        } else {
            ticketItem.setUnitPrice(this.priceRulePrice);
        }
        ticketItem.setUnitCost(this.getCost());
        ticketItem.setInventoryItem(menuItem.isInventoryItem());
        ticketItem.setTicket(ticket);
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setBeverage(menuItem.isBeverage());
        ticketItem.setPrinterGroup(menuItem.getPrinterGroup());
        MenuItem.setItemTaxes(ticketItem, menuItem.getTaxGroup(), ticket.getOrderType());
        ticketItem.setShouldPrintToKitchen(menuItem.isShouldPrintToKitchen());
        ticketItem.setPrintKitchenSticker(menuItem.isPrintKitchenSticker());
        List<Discount> discountList = menuItem.getDiscounts();
        if (discountList != null) {
            for (Discount discount : discountList) {
                if (!discount.isAutoApply().booleanValue()) continue;
                TicketItemDiscount ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
                ticketItem.addTodiscounts(ticketItemDiscount);
            }
        }
        return ticketItem;
    }

    public String getCourseOrganizeId() {
        String courseId = super.getCourseId();
        if (StringUtils.isEmpty((String)courseId)) {
            courseId = DataProvider.get().getDefaultCourseId();
        }
        return courseId;
    }

    public static TicketItemDiscount convertToTicketItemDiscount(Discount discount, TicketItem ticketItem) {
        TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
        ticketItemDiscount.setDiscountId(discount.getId());
        ticketItemDiscount.setAutoApply(discount.isAutoApply());
        ticketItemDiscount.setName(discount.getName());
        ticketItemDiscount.setType(discount.getType());
        ticketItemDiscount.setMinimumAmount(discount.getMinimumBuy());
        ticketItemDiscount.setValue(discount.getValue());
        ticketItemDiscount.setCouponQuantity(1.0);
        ticketItemDiscount.setTicketItem(ticketItem);
        return ticketItemDiscount;
    }

    public boolean hasModifiers() {
        return super.isHasModifiers();
    }

    public boolean hasMandatoryModifiers() {
        return super.isHasMandatoryModifiers();
    }

    public boolean hasAutoShowGroup() {
        List<MenuItemModifierSpec> modiferGroups = this.getMenuItemModiferSpecs();
        if (modiferGroups == null || modiferGroups.size() == 0) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierGroup : modiferGroups) {
            if (!menuItemModifierGroup.isAutoShow().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static TaxGroup getOutletTaxGroup() {
        Outlet outlet = Application.getOutlet();
        if (outlet != null) {
            TaxGroup outletTaxGroup = outlet.getTaxGroup();
            return outletTaxGroup;
        }
        return null;
    }

    public static void setItemTaxes(TicketItem ticketItem, TaxGroup itemTaxGroup, OrderType orderType) {
        ArrayList<TicketItemTax> ticketItemTaxes = new ArrayList<TicketItemTax>();
        if (ticketItem.getTicket() != null) {
            boolean isFound;
            String forHereToGo = ticketItem.getTicket().getProperty("ticket.ForHereToGo");
            boolean bl = isFound = forHereToGo != null;
            if (isFound) {
                if (forHereToGo.equals("FOR HERE")) {
                    itemTaxGroup = orderType.getForHereTaxGroup();
                } else if (forHereToGo.equals("TO GO")) {
                    itemTaxGroup = orderType.getToGoTaxGroup();
                }
            }
        }
        if (itemTaxGroup == null) {
            TaxGroup orderTypeTaxGroup = orderType.getDefaultTaxGroup();
            itemTaxGroup = orderTypeTaxGroup != null ? orderTypeTaxGroup : MenuItem.getOutletTaxGroup();
        }
        if (itemTaxGroup == null) {
            return;
        }
        List<Tax> taxes = itemTaxGroup.getTaxes();
        if (taxes != null) {
            for (Tax tax : taxes) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(tax.getId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                ticketItemTaxes.add(ticketItemTax);
            }
            ticketItem.setTaxes(ticketItemTaxes);
        }
    }

    public String getStringWithUnderScore(String orderType, String additionalString) {
        orderType = orderType.replaceAll(" ", "_");
        return orderType + additionalString;
    }

    @XmlTransient
    public Set<MenuItemSize> getSizes() {
        HashSet<MenuItemSize> sizes = new HashSet<MenuItemSize>();
        List<PizzaPrice> priceList = this.getPizzaPriceList();
        if (priceList != null) {
            for (PizzaPrice pizzaPrice : priceList) {
                sizes.add(pizzaPrice.getSize());
            }
        }
        return sizes;
    }

    public Set<PizzaCrust> getCrustsForSize(MenuItemSize size) {
        HashSet<PizzaCrust> crusts = new HashSet<PizzaCrust>();
        List<PizzaPrice> priceList = this.getPizzaPriceList();
        if (priceList != null) {
            for (PizzaPrice pizzaPrice : priceList) {
                if (!size.equals(pizzaPrice.getSize())) continue;
                crusts.add(pizzaPrice.getCrust());
            }
        }
        return crusts;
    }

    public Set<PizzaPrice> getAvailablePrices(MenuItemSize size) {
        HashSet<PizzaPrice> prices = new HashSet<PizzaPrice>();
        List<PizzaPrice> priceList = this.getPizzaPriceList();
        if (priceList != null) {
            for (PizzaPrice pizzaPrice : priceList) {
                if (!size.equals(pizzaPrice.getSize())) continue;
                prices.add(pizzaPrice);
            }
        }
        return prices;
    }

    public List<IUnit> getUnits() {
        List<InventoryUnit> groupUnits;
        ArrayList<IUnit> units = new ArrayList<IUnit>();
        InventoryUnit unit = this.getUnit();
        if (unit != null && (groupUnits = unit.getUnitGroup().getUnits()) != null) {
            units.addAll(groupUnits);
        }
        if (this.getStockUnits() != null) {
            for (InventoryStockUnit stockUnit : this.getStockUnits()) {
                units.add(stockUnit.getPackagingUnit());
            }
        }
        return units;
    }

    public Double getCost(IUnit selectedUnit) {
        if (selectedUnit == null) {
            return this.getCost();
        }
        if (selectedUnit instanceof InventoryUnit) {
            InventoryUnit inventoryUnit = (InventoryUnit)selectedUnit;
            return this.getCost() * this.getUnit().getConversionRate() / inventoryUnit.getBaseUnitConversionValue();
        }
        if (selectedUnit instanceof PackagingUnit) {
            PackagingUnit stockUnit = (PackagingUnit)selectedUnit;
            for (InventoryStockUnit itemStockUnit : this.getStockUnits()) {
                if (!stockUnit.getCode().equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                return itemStockUnit.getConversionValue() * this.getBaseUnitQuantity(itemStockUnit.getUnit().getUniqueCode()) * this.getCost();
            }
        }
        return this.getCost();
    }

    public Double getCost(String unitCode) {
        if (unitCode == null) {
            return this.getCost();
        }
        InventoryUnit unit = this.getUnit();
        if (unit != null && unitCode.equals(unit.getCode())) {
            return this.getCost();
        }
        List<InventoryStockUnit> stockUnits = this.getStockUnits();
        if (stockUnits != null) {
            for (InventoryStockUnit itemStockUnit : stockUnits) {
                if (!unitCode.equals(itemStockUnit.getPackagingUnit().getCode())) continue;
                return itemStockUnit.getConversionValue() * this.getCost();
            }
        }
        return this.getCost();
    }

    public double getBaseUnitQuantity(String unit) {
        if (this.getUnit() == null || this.getUnit().getCode().equals(unit)) {
            return 1.0;
        }
        if (this.getStockUnits() != null) {
            for (InventoryStockUnit packUnit : this.getStockUnits()) {
                if (!packUnit.getPackagingUnit().getCode().equals(unit)) continue;
                return packUnit.getConversionValue() * this.getBaseUnitQuantity(packUnit.getUnit().getUniqueCode());
            }
        }
        for (InventoryUnit groupUnit : this.getUnit().getUnitGroup().getUnits()) {
            if (!groupUnit.getCode().equals(unit)) continue;
            return this.getUnit().getConversionRate() / groupUnit.getConversionRate();
        }
        return 1.0;
    }

    @Override
    public Double getAverageUnitPurchasePrice() {
        Double avgprice = super.getAverageUnitPurchasePrice();
        if (avgprice == 0.0) {
            return this.getCost();
        }
        return avgprice;
    }

    @Override
    public String getSku() {
        String sku2 = super.getSku();
        if (StringUtils.isEmpty((String)sku2)) {
            return super.getBarcode();
        }
        return sku2;
    }

    public Double getAvailableUnit() {
        if (this.stockStatus != null) {
            return this.stockStatus.getAvailableUnit();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getAvailableUnit();
    }

    public Double getUnitOnHand() {
        if (this.stockStatus != null) {
            return this.stockStatus.getUnitOnHand();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getUnitOnHand();
    }

    public void setUnitOnHand(Double unitOnHand) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setUnitOnHand(unitOnHand);
    }

    public void setAvailableUnit(Double availableUnit) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setAvailableUnit(availableUnit);
    }

    public Double getRetailPrice() {
        return this.getPrice();
    }

    @Deprecated
    public MenuGroup getParent() {
        String groupId = this.getMenuGroupId();
        if (StringUtils.isNotEmpty((String)groupId)) {
            return MenuGroupDAO.getInstance().get(groupId);
        }
        return null;
    }

    public void setParent(MenuGroup menuGroup) {
        this.setMenuGroup(menuGroup);
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null) {
            this.setMenuGroupId(null);
            this.setMenuGroupName(null);
            this.setMenuCategoryId(null);
            this.setMenuCategoryName(null);
        } else {
            this.setMenuGroupId(menuGroup.getId());
            this.setMenuGroupName(menuGroup.getDisplayName());
            this.setMenuCategoryId(menuGroup.getMenuCategoryId());
            this.setMenuCategoryName(menuGroup.getMenuCategoryName());
        }
    }

    public PrinterGroup getPrinterGroup() {
        return DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String printerGroupId = null;
        if (printerGroup != null) {
            printerGroupId = printerGroup.getId();
        }
        super.setPrinterGroupId(printerGroupId);
    }

    public InventoryUnit getUnit() {
        return DataProvider.get().getInventoryUnitById(this.getUnitId());
    }

    public void setUnit(InventoryUnit unit) {
        String unitId = null;
        if (unit != null) {
            unitId = unit.getId();
        }
        super.setUnitId(unitId);
    }

    public ReportGroup getReportGroup() {
        return DataProvider.get().getReportGroupById(this.getReportGroupId());
    }

    public void setReportGroup(ReportGroup reportGroup) {
        String reportGroupId = null;
        if (reportGroup != null) {
            reportGroupId = reportGroup.getId();
        }
        super.setReportGroupId(reportGroupId);
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String taxGroupId = null;
        if (taxGroup != null) {
            taxGroupId = taxGroup.getId();
        }
        super.setTaxGroupId(taxGroupId);
    }

    public void setOrderTypeList(List checkedValues) {
    }

    public MenuItem getParentMenuItem() {
        if (this.parentMenuItem != null) {
            return this.parentMenuItem;
        }
        String parentMenuItemId = this.getParentMenuItemId();
        if (StringUtils.isEmpty((String)parentMenuItemId)) {
            return null;
        }
        this.parentMenuItem = MenuItemDAO.getInstance().get(parentMenuItemId);
        return this.parentMenuItem;
    }

    public void setParentMenuItem(MenuItem parentMenuItem) {
        this.parentMenuItem = parentMenuItem;
        String parentMenuItemId = null;
        if (parentMenuItem != null) {
            parentMenuItemId = parentMenuItem.getId();
        }
        super.setParentMenuItemId(parentMenuItemId);
    }

    @Override
    public String getParentMenuItemId() {
        if (this.parentMenuItem != null && StringUtils.isNotEmpty((String)this.parentMenuItem.getId())) {
            return this.parentMenuItem.getId();
        }
        return super.getParentMenuItemId();
    }

    public MenuItemInventoryStatus getStockStatus() {
        if (!this.isInventoryItem().booleanValue()) {
            return null;
        }
        if (this.stockStatus != null || this.getId() == null) {
            return this.stockStatus;
        }
        this.stockStatus = DataProvider.get().getMenuItemStockStatus(this);
        return this.stockStatus;
    }

    public void setStockStatus(MenuItemInventoryStatus stockStatus) {
        this.stockStatus = stockStatus;
    }

    @Override
    public void setPropertiesJson(String propertiesJson) {
        super.setPropertiesJson(propertiesJson);
        this.properties = StringUtils.isNotEmpty((String)propertiesJson) ? new JSONObject(propertiesJson) : new JSONObject();
    }

    private void buildPropertis() {
        if (this.properties != null) {
            return;
        }
        String json = this.getPropertiesJson();
        if (StringUtils.isEmpty((String)json)) {
            this.properties = new JSONObject();
            return;
        }
        this.properties = new JSONObject(json);
    }

    public void addProperty(String key, String value) {
        this.buildPropertis();
        this.properties.put(key, (Object)value);
        this.setPropertiesJson(this.properties.toString());
    }

    public String getProperty(String key) {
        this.buildPropertis();
        if (this.properties.has(key)) {
            return this.properties.getString(key);
        }
        return null;
    }

    public void removeProperty(String key) {
        this.buildPropertis();
        this.properties.remove(key);
    }

    @Deprecated
    public Course getCourse() {
        String courseId = this.getCourseId();
        if (StringUtils.isNotEmpty((String)courseId)) {
            return CourseDAO.getInstance().get(courseId);
        }
        return null;
    }

    public void setCourse(Course course) {
        this.setCourseId(course == null ? null : course.getId());
    }

    public MenuItem clone() {
        List<PizzaPrice> list;
        List<ComboGroup> list2;
        List<ComboItem> comboItems;
        MenuItem newMenuItem = new MenuItem();
        newMenuItem = (MenuItem)SerializationUtils.clone((Serializable)this);
        String newName = MenuItem.doDuplicateName(this.getName());
        newMenuItem.setName(newName);
        newMenuItem.setId(null);
        List<InventoryStockUnit> stockUnits = newMenuItem.getStockUnits();
        if (stockUnits != null) {
            for (InventoryStockUnit inventoryStockUnit : stockUnits) {
                inventoryStockUnit.setId(null);
                inventoryStockUnit.setMenuItem(newMenuItem);
            }
        }
        if ((comboItems = newMenuItem.getComboItems()) != null) {
            for (ComboItem comboItem : comboItems) {
                comboItem.setId(null);
            }
        }
        if ((list2 = newMenuItem.getComboGroups()) != null) {
            for (ComboGroup comboGroup : list2) {
                comboGroup.setId(null);
            }
        }
        MenuItem.copyModifierSpecsToMenuItem(newMenuItem, newMenuItem.getMenuItemModiferSpecs());
        if (newMenuItem.isPizzaType().booleanValue() && (list = newMenuItem.getPizzaPriceList()) != null) {
            ArrayList<PizzaPrice> newPriceList = new ArrayList<PizzaPrice>();
            for (PizzaPrice pizzaPrice : list) {
                PizzaPrice newPrice = (PizzaPrice)SerializationUtils.clone((Serializable)pizzaPrice);
                newPrice.setId(null);
                newPriceList.add(newPrice);
            }
            newMenuItem.setPizzaPriceList(newPriceList);
        }
        newMenuItem.setVariants(null);
        return newMenuItem;
    }

    public static void copyModifierSpecsToMenuItem(MenuItem newMenuItem, List<MenuItemModifierSpec> menuItemModifierSpecs) {
        ArrayList<MenuItemModifierSpec> newSpecs = new ArrayList<MenuItemModifierSpec>();
        if (menuItemModifierSpecs != null) {
            for (MenuItemModifierSpec menuModifierSpec : menuItemModifierSpecs) {
                menuModifierSpec.setId(null);
                Set<MenuItemModifierPage> specPages = menuModifierSpec.getModifierPages();
                HashSet<MenuItemModifierPage> newPages = new HashSet<MenuItemModifierPage>();
                if (specPages != null) {
                    for (MenuItemModifierPage menuItemModifierPage : specPages) {
                        ArrayList<MenuItemModifierPageItem> newPageItems = new ArrayList<MenuItemModifierPageItem>();
                        menuItemModifierPage.setId(null);
                        menuItemModifierPage.setModifierSpecId(menuModifierSpec.getId());
                        List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
                        if (pageItems != null) {
                            for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                                menuItemModifierPageItem.setId(null);
                                menuItemModifierPageItem.setParentPage(menuItemModifierPage);
                                newPageItems.add(menuItemModifierPageItem);
                            }
                        }
                        menuItemModifierPage.setPageItems(newPageItems);
                        newPages.add(menuItemModifierPage);
                    }
                }
                menuModifierSpec.setModifierPages(newPages);
                newSpecs.add(menuModifierSpec);
            }
        }
        newMenuItem.setMenuItemModiferSpecs(newSpecs);
    }

    private static String doDuplicateName(String existingName) {
        String newName = new String();
        int lastIndexOf = existingName.lastIndexOf(" ");
        if (lastIndexOf == -1) {
            newName = existingName + " 1";
        } else {
            String processName = existingName.substring(lastIndexOf + 1, existingName.length());
            if (StringUtils.isNumeric((String)processName)) {
                Integer count = Integer.valueOf(processName);
                count = count + 1;
                newName = existingName.replace(processName, String.valueOf(count));
            } else {
                newName = existingName + " 1";
            }
        }
        return newName;
    }

    public String getVendorNames() {
        return this.vendorNames;
    }

    public void setVendorNames(String vendorName) {
        this.vendorNames = vendorName;
    }
}

