/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.base.BaseMenuItemModifierPage;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MenuItemModifierPage
extends BaseMenuItemModifierPage {
    private static final long serialVersionUID = 1L;
    private Map<String, MenuItemModifierPageItem> cellItemMap;
    private MenuItemModifierSpec modifierSpec;

    public MenuItemModifierPage() {
    }

    public MenuItemModifierPage(String id) {
        super(id);
    }

    public MenuItemModifierPage(String id, String name) {
        super(id, name);
    }

    @Override
    public Integer getButtonWidth() {
        Integer buttonWidth = super.getButtonWidth();
        if (buttonWidth < 30) {
            return 30;
        }
        return buttonWidth;
    }

    @Override
    public Integer getButtonHeight() {
        Integer buttonHeight = super.getButtonHeight();
        if (buttonHeight < 30) {
            return 30;
        }
        return buttonHeight;
    }

    public MenuItemModifierPageItem getItemForCell(int col, int row) {
        List<MenuItemModifierPageItem> pageItems = this.getPageItems();
        if (pageItems == null || pageItems.size() == 0) {
            return null;
        }
        if (this.cellItemMap == null) {
            this.cellItemMap = new HashMap<String, MenuItemModifierPageItem>();
            for (MenuItemModifierPageItem menuPageItem : pageItems) {
                String cellKey = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
                this.cellItemMap.put(cellKey, menuPageItem);
            }
        }
        String cellKey = String.valueOf(col) + String.valueOf(row);
        return this.cellItemMap.get(cellKey);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public void setModifierSpec(MenuItemModifierSpec modifierSpec) {
        this.modifierSpec = modifierSpec;
        this.setModifierSpecId(modifierSpec == null ? null : modifierSpec.getId());
    }

    public MenuItemModifierSpec getModifierSpec() {
        if (this.modifierSpec != null) {
            return this.modifierSpec;
        }
        if (StringUtils.isNotEmpty((String)this.getModifierSpecId())) {
            return MenuItemModifierSpecDAO.getInstance().get(this.getModifierSpecId());
        }
        return null;
    }
}

