/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.util.DataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "image", "properties", "pizzaModifierPriceList", "multiplierPriceList"})
@XmlRootElement
public class MenuModifier
extends BaseMenuModifier {
    private static final long serialVersionUID = 1L;
    private transient MenuItemModifierSpec menuItemModifierGroup;
    private String pageItemId;

    public MenuModifier() {
    }

    public MenuModifier(String id) {
        super(id);
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String taxGroupId = null;
        if (taxGroup != null) {
            taxGroupId = taxGroup.getId();
        }
        super.setTaxGroupId(taxGroupId);
    }

    public MenuItemModifierSpec getMenuItemModifierGroup() {
        return this.menuItemModifierGroup;
    }

    public void setMenuItemModifierGroup(MenuItemModifierSpec menuItemModifierGroup) {
        this.menuItemModifierGroup = menuItemModifierGroup;
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColor() {
        Integer buttonColor = super.getButtonColor();
        return buttonColor == 0 ? null : buttonColor;
    }

    @Override
    public Integer getTextColor() {
        Integer textColor = super.getTextColor();
        return textColor == 0 ? null : textColor;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menu_modifier_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getPriceForSize(MenuItemSize size, boolean extra) {
        double defaultPrice = this.getPrice();
        if (size == null) {
            return defaultPrice;
        }
        List<PizzaModifierPrice> priceList = this.getPizzaModifierPriceList();
        if (priceList == null) {
            return defaultPrice;
        }
        for (PizzaModifierPrice pizzaModifierPrice : priceList) {
            if (!size.equals(pizzaModifierPrice.getSize())) continue;
            if (extra) {
                return pizzaModifierPrice.getExtraPrice();
            }
            return pizzaModifierPrice.getPrice();
        }
        return defaultPrice;
    }

    public double getPriceForMultiplier(Multiplier multiplier) {
        double defaultPrice = this.getPrice();
        if (multiplier == null || multiplier.isMain().booleanValue()) {
            return defaultPrice;
        }
        List<ModifierMultiplierPrice> priceList = this.getMultiplierPriceList();
        if (priceList == null || priceList.isEmpty()) {
            return defaultPrice * multiplier.getRate() / 100.0;
        }
        for (ModifierMultiplierPrice multiplierPrice : priceList) {
            if (!multiplier.getId().equals(multiplierPrice.getMultiplier().getId())) continue;
            return multiplierPrice.getPrice();
        }
        return defaultPrice * multiplier.getRate() / 100.0;
    }

    public double getPriceForSizeAndMultiplier(MenuItemSize size, boolean extra, Multiplier multiplier) {
        List<PizzaModifierPrice> priceList = this.getPizzaModifierPriceList();
        double regularPrice = 0.0;
        if (this.isPizzaModifier().booleanValue() && priceList != null) {
            for (PizzaModifierPrice pizzaModifierPrice : priceList) {
                List<ModifierMultiplierPrice> multiplierPriceList;
                if (!size.equals(pizzaModifierPrice.getSize()) || (multiplierPriceList = pizzaModifierPrice.getMultiplierPriceList()) == null) continue;
                Double multiplierPrice = null;
                for (ModifierMultiplierPrice price : multiplierPriceList) {
                    String priceTableMultiplierName = price.getMultiplier().getId();
                    if (priceTableMultiplierName.equals("Regular")) {
                        regularPrice = price.getPrice();
                        if (!multiplier.getId().equals("Regular")) continue;
                        return regularPrice;
                    }
                    if (!priceTableMultiplierName.equals(multiplier.getId())) continue;
                    multiplierPrice = price.getPrice();
                }
                if (multiplierPrice == null) continue;
                return multiplierPrice;
            }
        }
        return regularPrice * multiplier.getRate() / 100.0;
    }

    public List<TicketItemTax> getTaxByOrderType(OrderType type) {
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup == null) {
            return null;
        }
        ArrayList<TicketItemTax> ticketItemTaxes = new ArrayList<TicketItemTax>();
        List<Tax> taxes = taxGroup.getTaxes();
        if (taxes != null) {
            for (Tax tax : taxes) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(tax.getId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setRate(tax.getRate());
                ticketItemTaxes.add(ticketItemTax);
            }
        }
        return ticketItemTaxes;
    }

    @Override
    @JsonIgnoreProperties
    public List<ModifierMultiplierPrice> getMultiplierPriceList() {
        return super.getMultiplierPriceList();
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 80, 80);
    }

    public void setPageItemId(String id) {
        this.pageItemId = id;
    }

    public String getPageItemId() {
        return this.pageItemId;
    }
}

