/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.IconFactory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.base.BaseMenuPageItem;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.awt.Color;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlTransient;

public class MenuPageItem
extends BaseMenuPageItem {
    private static final long serialVersionUID = 1L;
    private transient MenuItem menuItem;
    private transient ImageIcon image;
    private transient Color buttonColor;
    private transient Color textColor;
    private final String randomId = UUID.randomUUID().toString();

    public MenuPageItem() {
    }

    public MenuPageItem(String id) {
        super(id);
    }

    public MenuPageItem(Integer col, Integer row) {
        super.setCol(col);
        super.setRow(row);
    }

    public MenuPageItem(Integer col, Integer row, MenuItem menuItem, MenuPage menuPage) {
        super.setCol(col);
        super.setRow(row);
        this.setMenuItem(menuItem);
        this.setMenuPage(menuPage);
    }

    public void setMenuPage(MenuPage menuPage) {
        if (menuPage != null) {
            this.setMenuPageId(menuPage.getId());
        } else {
            this.setMenuPageId(null);
        }
    }

    public MenuItem getMenuItem() {
        if (this.menuItem == null && this.getMenuItemId() != null) {
            this.menuItem = MenuItemDAO.getInstance().get(this.getMenuItemId());
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            this.setMenuItemId(menuItem.getId());
            this.setMenuItemName(menuItem.getDisplayName());
            this.setButtonColorCode(menuItem.getButtonColorCode());
            this.setTextColorCode(menuItem.getTextColorCode());
            this.setImageId(menuItem.getImageId());
            this.setShowImageOnly(menuItem.isShowImageOnly());
        } else {
            this.setMenuItemId(null);
        }
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 80, 80);
    }

    public ImageIcon getImage(int w, int h) {
        return IconFactory.getIconFromImageResource(this.getImageId(), w - 20, h - 20);
    }

    public ImageIcon getScaledImageIcon(int w, int h) {
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(this.getImageId());
        if (imageResource != null) {
            this.image = new ImageIcon(imageResource.getImage().getScaledInstance(w, h, 1));
        }
        return this.image;
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public String getRandomId() {
        return this.randomId;
    }
}

