/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@JsonIgnoreProperties(ignoreUnknown=true, value={"terminalTypes", "categories", "departments"})
@XmlRootElement
public class OrderType
extends BaseOrderType {
    private static final long serialVersionUID = 1L;
    public static final String BAR_TAB = "BAR_TAB";
    public static final String FOR_HERE = "FOR HERE";
    public static final String TO_GO = "TO GO";
    private ImageIcon image;
    private Color buttonColor;
    private Color textColor;

    public OrderType() {
    }

    public TaxGroup getDefaultTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getDefaultTaxGroupId());
    }

    public void setDefaultTaxGroup(TaxGroup defaultTaxGroup) {
        this.setDefaultTaxGroupId(defaultTaxGroup == null ? null : defaultTaxGroup.getId());
    }

    public TaxGroup getForHereTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getForHereTaxGroupId());
    }

    public void setForHereTaxGroup(TaxGroup forHereTaxGroup) {
        this.setForHereTaxGroupId(forHereTaxGroup == null ? null : forHereTaxGroup.getId());
    }

    public TaxGroup getToGoTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getToGoTaxGroupId());
    }

    public void setToGoTaxGroup(TaxGroup toGoTaxGroup) {
        this.setToGoTaxGroupId(toGoTaxGroup == null ? null : toGoTaxGroup.getId());
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        if (this.getTextColorCode() == null) {
            return null;
        }
        this.textColor = new Color(this.getTextColorCode());
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @XmlTransient
    public Color getButtonColor() {
        if (this.buttonColor != null) {
            return this.buttonColor;
        }
        if (this.getButtonColorCode() == null) {
            return null;
        }
        this.buttonColor = new Color(this.getButtonColorCode());
        return this.buttonColor;
    }

    public OrderType(String id) {
        super(id);
    }

    public String name() {
        return super.getName();
    }

    public OrderType valueOf() {
        return this;
    }

    @Override
    public String toString() {
        return this.getName().replaceAll("_", " ");
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public Image getStoredImage() {
        ImageIcon tempImageIcon = this.getImage();
        if (tempImageIcon == null) {
            return null;
        }
        Image tempImage = tempImageIcon.getImage();
        return tempImage;
    }

    @Override
    public void setImageData(Blob imageData) {
        super.setImageData(imageData);
        if (imageData != null) {
            try {
                int blobLength = (int)imageData.length();
                this.image = new ImageIcon(imageData.getBytes(1L, blobLength));
            }
            catch (SQLException e) {
                PosLog.error(this.getClass(), e);
            }
        }
    }

    public ImageIcon getScaledImage(int width, int height) {
        Image scaledInstance = null;
        if (this.image != null) {
            scaledInstance = this.image.getImage().getScaledInstance(width, height, 4);
            return new ImageIcon(scaledInstance);
        }
        return null;
    }

    public String getUniqueId() {
        return ("order_type_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }
}

