/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Department;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"ticketItems"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PosTransaction
extends BasePosTransaction {
    private static final long serialVersionUID = 1L;
    private transient boolean refunded = false;
    private transient boolean syncEdited;
    private CashDrawer cashDrawer;
    private String cardTrack;
    private String cardNo;
    private String cardExpYear;
    private String cardExpMonth;
    public static final String CASH = "CASH";
    public static final String GIFT_CERT = "GIFT_CERT";
    public static final String CREDIT_CARD = "CREDIT_CARD";
    public static final String DEBIT_CARD = "DEBIT_CARD";
    public static final String CASH_DROP = "CASH_DROP";
    public static final String REFUND = "REFUND";
    public static final String PAY_OUT = "PAY_OUT";
    public static final String VOID_TRANS = "VOID_TRANS";
    public static final String GIFT_CARD_BALANCE_ADD = "GIFT_CARD_BALANCE_ADD";
    private transient String ticketId;

    public PosTransaction() {
    }

    public PosTransaction(String id) {
        super(id);
    }

    public PosTransaction(String id, String transactionType, String paymentTypeString) {
        super(id, transactionType, paymentTypeString);
    }

    @Override
    public String getTransactionType() {
        String type = super.getTransactionType();
        if (StringUtils.isEmpty((String)type)) {
            return TransactionType.CREDIT.name();
        }
        return type;
    }

    public void updateTerminalBalance() {
        Terminal terminal = this.getTerminal();
        if (terminal == null) {
            return;
        }
        Double amount = this.getAmount();
        if (amount == null || amount == 0.0) {
            return;
        }
    }

    public boolean isCard() {
        return this instanceof CreditCardTransaction || this instanceof DebitCardTransaction;
    }

    public void addProperty(String name, String value) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        this.getProperties().put(name, value);
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public Double calculateTotalAmount() {
        return this.getAmount() + this.getTipsAmount();
    }

    public Double calculateAuthorizeAmount() {
        double advanceTipsPercentage = CardConfig.getAdvanceTipsPercentage();
        return this.getTenderAmount() + this.getTenderAmount() * (advanceTipsPercentage / 100.0);
    }

    @XmlTransient
    public String getCardTrack() {
        return this.cardTrack;
    }

    public void setCardTrack(String cardTrack) {
        this.cardTrack = cardTrack;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardExpYear() {
        return this.cardExpYear;
    }

    public void setCardExpYear(String expYear) {
        this.cardExpYear = expYear;
    }

    public String getCardExpMonth() {
        return this.cardExpMonth;
    }

    public void setCardExpMonth(String expMonth) {
        this.cardExpMonth = expMonth;
    }

    public String getGlobalId() {
        return super.getId();
    }

    public String getTicketId() {
        if (StringUtils.isNotEmpty((String)this.ticketId)) {
            return this.ticketId;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return "";
        }
        return ticket.getId();
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public void calculateTaxAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getTotalAmount() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setTaxAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getTaxAmount() / ticket.getTotalAmount()));
    }

    public void calculateServiceChargeAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getServiceCharge() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setServiceChargeAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getServiceCharge() / ticket.getTotalAmount()));
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public void setRefunded(boolean refunded) {
        this.refunded = refunded;
    }

    @XmlTransient
    public Department getDepartment() {
        return DataProvider.get().getDepartmentById(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        String departmentId = null;
        if (department != null) {
            departmentId = department.getId();
        }
        super.setDepartmentId(departmentId);
    }

    @XmlTransient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer terminalId = null;
        if (terminal != null) {
            terminalId = terminal.getId();
        }
        super.setTerminalId(terminalId);
    }

    @XmlTransient
    public User getUser() {
        return DataProvider.get().getUserById(this.getUserId());
    }

    public void setUser(User user) {
        String userId = null;
        if (user != null) {
            userId = user.getId();
        }
        super.setUserId(userId);
    }

    public void setServer(User server) {
        if (server == null) {
            this.setServerId(null);
        } else {
            this.setServerId(server.getId());
        }
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        this.cashDrawer = cashDrawer;
        if (cashDrawer != null) {
            super.setCashDrawerId(cashDrawer.getId());
        }
    }

    @XmlTransient
    public CashDrawer getCashDrawer() {
        if (this.cashDrawer != null) {
            return this.cashDrawer;
        }
        return CashDrawerDAO.getInstance().get(this.getCashDrawerId());
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean syncEdited) {
        this.syncEdited = syncEdited;
    }

    public void setPaymentType(PaymentType paymentType) {
        if (paymentType != null) {
            this.setPaymentTypeString(paymentType.name());
        } else {
            this.setPaymentTypeString(null);
        }
    }

    @XmlTransient
    public PaymentType getPaymentType() {
        String paymentTypeString = super.getPaymentTypeString();
        if (paymentTypeString == null) {
            return null;
        }
        try {
            return PaymentType.valueOf(paymentTypeString);
        }
        catch (Exception e) {
            return PaymentType.fromDisplayString(paymentTypeString);
        }
    }

    public double getAmountWithTolerance() {
        return super.getAmount() - super.getToleranceAmount();
    }
}

