/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.base.BasePurchaseOrder;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PurchaseOrder
extends BasePurchaseOrder {
    private static final long serialVersionUID = 1L;
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_RECEIVED = 4;
    public static final int ORDER_PARTIALLY_RECEIVED = 5;
    public static final int ORDER_PARTIALLY_RECEIVED_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    public static final String[] ORDER_STATUS = new String[]{"Pending", "Verified", "Fully Invoiced", "Partially Invoiced", "Fully Received", "Partially Received", "Partially Received and Invoiced", "Closed", "Cancelled"};
    public static final String PO_VERIFIED_BY = "Verified_By";
    public static final String PO_SENT_BY = "Sent_By";
    public static final String PO_RECEIVED_BY = "Received_By";
    public static final String PO_INVOICED_BY = "Invoiced_By";
    public static final String PO_CLOSED_BY = "Closed_By";
    public String orderStatusDisplay;
    public static final String DEBIT = "DEBIT";
    public static final String CREDIT = "CREDIT";
    public String statusDisplay;

    public PurchaseOrder() {
    }

    public PurchaseOrder(String id) {
        super(id);
    }

    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getStatus()];
    }

    public void setOrderStatusDisplay(String orderStatusDisplay) {
        this.orderStatusDisplay = ORDER_STATUS[this.getStatus()];
    }

    @Override
    public List<PurchaseOrderItem> getOrderItems() {
        List<PurchaseOrderItem> items = super.getOrderItems();
        if (items == null) {
            items = new ArrayList<PurchaseOrderItem>();
            super.setOrderItems(items);
        }
        return items;
    }

    public void calculatePrice() {
        List<PurchaseOrderItem> items = this.getOrderItems();
        if (items == null) {
            return;
        }
        double subtotalAmount = 0.0;
        double discountAmount = 0.0;
        double taxAmount = 0.0;
        for (PurchaseOrderItem item : items) {
            item.calculatePrice();
            subtotalAmount += item.getSubtotalAmount().doubleValue();
            discountAmount += item.getDiscountAmount().doubleValue();
            taxAmount += item.getTaxAmount().doubleValue();
        }
        this.setSubtotalAmount(subtotalAmount);
        this.setDiscountAmount(discountAmount);
        this.setTaxAmount(taxAmount);
        double totalAmount = subtotalAmount - discountAmount + taxAmount;
        totalAmount = this.fixInvalidAmount(totalAmount);
        this.setTotalAmount(NumberUtil.roundToTwoDigit(totalAmount));
        double dueAmount = totalAmount - this.getPaidAmount();
        this.setDueAmount(NumberUtil.roundToTwoDigit(dueAmount));
    }

    private double fixInvalidAmount(double tax) {
        if (tax < 0.0 || Double.isNaN(tax)) {
            tax = 0.0;
        }
        return tax;
    }

    public void addProperty(String name, String value) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        this.getProperties().put(name, value);
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperties() == null) {
            return null;
        }
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return string;
    }

    public void removeProperty(String propertyName) {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return;
        }
        properties.remove(propertyName);
    }

    public String getStatusDisplay() {
        int status = this.getStatus();
        if (status == 0) {
            return "Verify";
        }
        if (status == 1 || status == 5) {
            return "Receive";
        }
        return "";
    }

    public void setStatusDisplay(String statusDisplay) {
        this.statusDisplay = statusDisplay;
    }
}

