/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.IconFactory;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.base.BaseShopFloor;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlTransient;

public class ShopFloor
extends BaseShopFloor {
    private static final long serialVersionUID = 1L;
    private Color foregroundColor;
    private Color backgroundColor;

    public ShopFloor() {
    }

    public ShopFloor(String id) {
        super(id);
    }

    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasTableWithNumber(String number) {
        Set<ShopTable> tables = this.getTables();
        if (tables == null) {
            return false;
        }
        for (ShopTable shopTable : tables) {
            if (!shopTable.getTableNumber().equals(number)) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public Color getForegroundColor() {
        if (this.getForegroundColorCode() == null) {
            return null;
        }
        if (this.foregroundColor != null) {
            return this.foregroundColor;
        }
        this.foregroundColor = new Color(this.getForegroundColorCode());
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        if (foregroundColor != null) {
            this.setForegroundColorCode(foregroundColor.getRGB());
        }
    }

    @XmlTransient
    public Color getBackgroundColor() {
        if (this.getBackgroundColorCode() == null) {
            return null;
        }
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        this.backgroundColor = new Color(this.getBackgroundColorCode());
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (backgroundColor != null) {
            this.setBackgroundColorCode(backgroundColor.getRGB());
        }
    }

    @XmlTransient
    public Dimension getFloorSize() {
        Integer height = this.getHeight();
        Integer width = this.getWidth();
        if (width <= 0) {
            width = 850;
        }
        if (height <= 0) {
            height = 500;
        }
        return new Dimension(width, height);
    }
}

