/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.util.GlobalIdGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"typesAsString"})
public class ShopTable
extends BaseShopTable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_RECTANGLE = 0;
    public static final int TYPE_ROUNDED_RECTANGLE = 1;
    public static final int TYPE_ROUND = 2;
    public static final int TYPE_POLYGON = 3;
    public static final int TYPE_CUSTOM = 4;
    private String typesAsString;
    private Date ticketCreateTime;
    private boolean showStatus;
    private boolean reArrange;
    private int guestNumber;
    private boolean isTemporary;

    public TableStatus getTableStatus() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getTableStatus();
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.setTableStatusNum(tableStatus.getValue());
    }

    private void setTableStatusNum(int value) {
        ShopTableStatus status = this.getStatus();
        status.setTableStatusNum(value);
    }

    public ShopTable() {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer id) {
        super(id);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer id, String globalId) {
        super(id, globalId);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer x, Integer y) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setX(x);
        this.setY(y);
    }

    public ShopTable(ShopFloor floor, Integer x, Integer y, Integer id) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setCapacity(4);
        this.setId(id);
        this.setFloorId(floor.getId());
        this.setX(x);
        this.setY(y);
    }

    public Integer getTableNumber() {
        return this.getId();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTableNumber());
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public String getTypesAsString() {
        List<ShopTableType> tableTypes = this.getTypes();
        String strTableTypes = "";
        if (tableTypes == null || tableTypes.size() == 0) {
            return "";
        }
        boolean getComma = false;
        for (ShopTableType shopTableType : tableTypes) {
            if (getComma) {
                strTableTypes = strTableTypes + ", ";
            }
            strTableTypes = strTableTypes + shopTableType.getName();
            getComma = true;
        }
        return strTableTypes;
    }

    public void setTypesAsString(String typesAsString) {
        this.typesAsString = typesAsString;
    }

    public String getTicketId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        List<String> ticketNumbers = status.getListOfTicketNumbers();
        if (ticketNumbers != null && ticketNumbers.size() > 0) {
            return ticketNumbers.get(0);
        }
        return null;
    }

    public String getUserId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getUserId();
    }

    public String getUserName() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getUserName();
    }

    public String getTicketShortId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getTokenNo();
    }

    public ShopTableStatus getStatus() {
        ShopTableStatus shopTableStatus = super.getShopTableStatus();
        if (shopTableStatus != null) {
            return shopTableStatus;
        }
        return this.saveAndGetNewStatus();
    }

    public ShopTableStatus saveAndGetNewStatus() {
        ShopTableStatus shopTableStatus = new ShopTableStatus();
        Integer tableId = this.getId();
        shopTableStatus.setId(tableId);
        shopTableStatus.setTableStatus(TableStatus.Available);
        if (tableId != null) {
            ShopTableStatusDAO.getInstance().save(shopTableStatus);
        }
        this.setShopTableStatus(shopTableStatus);
        return shopTableStatus;
    }

    public Date getTicketCreateTime() {
        return this.ticketCreateTime;
    }

    public void setTicketCreateTime(Date ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }

    public boolean isShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public boolean isReArrange() {
        return this.reArrange;
    }

    public void setReArrange(boolean reArrange) {
        this.reArrange = reArrange;
    }

    public int getGuestNumber() {
        return this.guestNumber;
    }

    public void setGuestNumber(int guestNumber) {
        this.guestNumber = guestNumber;
    }

    public ShopFloor getFloor() {
        if (StringUtils.isNotEmpty((String)this.getFloorId())) {
            return ShopFloorDAO.getInstance().get(this.getFloorId());
        }
        return null;
    }

    public void setFloor(ShopFloor shopFloor) {
        String shopFloorId = null;
        if (shopFloor != null) {
            shopFloorId = shopFloor.getId();
        }
        super.setFloorId(shopFloorId);
    }

    public SalesArea getSalesArea() {
        if (StringUtils.isNotEmpty((String)this.getSalesAreaId())) {
            return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
        }
        return null;
    }

    public void setSalesArea(SalesArea salesArea) {
        String salesAreaId = null;
        if (salesArea != null) {
            salesAreaId = salesArea.getId();
        }
        super.setSalesAreaId(salesAreaId);
    }
}

