/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DataProvider;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="terminal")
public class Terminal
extends BaseTerminal {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_MOBILE = 1;

    public Terminal() {
    }

    public Terminal(Integer id) {
        super(id);
    }

    public User getAssignedUser() {
        return DataProvider.get().getUserById(this.getAssignedUserId());
    }

    public void setAssignedUser(User assignedUser) {
        this.setAssignedUserId(assignedUser == null ? null : assignedUser.getId());
    }

    public Outlet getOutlet() {
        if (this.getOutletId() == null) {
            return null;
        }
        return OutletDAO.getInstance().get(this.getOutletId());
    }

    public void setOutlet(Outlet outlet) {
        this.setOutletId(outlet == null ? null : outlet.getId());
    }

    public Department getDepartment() {
        if (this.getDepartmentId() == null) {
            return null;
        }
        return DepartmentDAO.getInstance().get(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        this.setDepartmentId(department == null ? null : department.getId());
    }

    public SalesArea getSalesArea() {
        if (this.getSalesAreaId() == null) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
    }

    public void setSalesArea(SalesArea salesArea) {
        this.setSalesAreaId(salesArea == null ? null : salesArea.getId());
    }

    public TerminalType getTerminalType() {
        return DataProvider.get().getTerminalType(this.getTerminalTypeId());
    }

    public void setTerminalType(TerminalType terminalType) {
        this.setTerminalTypeId(terminalType == null ? null : terminalType.getId());
    }

    public boolean isCashDrawerAssigned() {
        return this.getAssignedUser() != null;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperties() == null) {
            return defaultValue;
        }
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return string;
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isShowTableNumber() {
        return this.getProperty("floorplan.showTableNumber") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTableNumber"));
    }

    public boolean isShowServerName() {
        return this.getProperty("floorplan.showServerName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showServerName"));
    }

    public boolean isShowTokenNum() {
        return this.getProperty("floorplan.showTokenName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTokenName"));
    }
}

