/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTicketDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import org.json.JSONObject;

public class TicketDiscount
extends BaseTicketDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    private String ticketId;

    public TicketDiscount() {
    }

    public TicketDiscount(String id) {
        super(id);
    }

    public TicketDiscount(String id, String name, double quantity, double value, int type, Ticket ticket) {
        this.setId(id);
        this.setDiscountId(id);
        this.setName(name);
        this.setCouponQuantity(quantity);
        this.setValue(value);
        this.setType(type);
        this.setTicket(ticket);
        this.setTicketId(ticket.getId());
    }

    @Override
    public Double getCouponQuantity() {
        Double couponQuantity = super.getCouponQuantity();
        if (couponQuantity == 0.0) {
            return 1.0;
        }
        return couponQuantity;
    }

    @Override
    public String getNameDisplay() {
        double couponQuantity = this.getCouponQuantity();
        String display = couponQuantity > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(couponQuantity) + "x " + this.getName() : this.getName().trim();
        return display;
    }

    @Override
    public String getItemCode() {
        return null;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public Double getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public Double getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getSubTotalAmountDisplay() {
        return -this.getTotalDiscountAmount().doubleValue();
    }

    @Override
    public Double getSubTotalAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public void setDiscountAmount(Double amount) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jsonObject.put(PROP_NAME, (Object)this.getName());
        jsonObject.put(PROP_TYPE, (Object)this.getType());
        jsonObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jsonObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jsonObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jsonObject.put(PROP_VALUE, (Object)this.getValue());
        jsonObject.put(PROP_TOTAL_DISCOUNT_AMOUNT, (Object)this.getTotalDiscountAmount());
        return jsonObject;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }
}

