/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"image", "status", "linkedUser", "linkedUsersIfExists"})
@XmlRootElement(name="user")
public class User
extends BaseUser {
    private static final long serialVersionUID = 1L;
    public static final String USER_TYPE_MANAGER = "MANAGER";
    public static final String USER_TYPE_CASHIER = "CASHIER";
    public static final String USER_TYPE_SERVER = "SERVER";

    public User() {
    }

    public User(String id) {
        super(id);
    }

    public UserType getType() {
        String userTypeId2 = this.getUserTypeId();
        if (userTypeId2 != null) {
            return DataProvider.get().getUserType(userTypeId2);
        }
        return null;
    }

    public void setType(UserType userType) {
        if (userType != null) {
            super.setUserTypeId(userType.getId());
        } else {
            super.setUserTypeId(null);
        }
    }

    public Shift getCurrentShift() {
        return DataProvider.get().getShiftById(this.getCurrentShiftId());
    }

    public void setCurrentShift(Shift shift) {
        if (shift != null) {
            super.setCurrentShiftId(shift.getId());
        } else {
            super.setCurrentShiftId(null);
        }
    }

    @Override
    public Boolean isActive() {
        return super.isActive() == null ? Boolean.TRUE : super.isActive();
    }

    public boolean hasPermission(UserPermission permission) {
        return this.getType().hasPermission(permission);
    }

    @Override
    public CashDrawer getCurrentCashDrawer() {
        return super.getCurrentCashDrawer();
    }

    public CashDrawer getActiveDrawerPullReport() {
        CashDrawer currentDrawerPullReport = super.getCurrentCashDrawer();
        if (currentDrawerPullReport != null) {
            return currentDrawerPullReport;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null) {
            return terminal.getCurrentCashDrawer();
        }
        return null;
    }

    public void doClockIn(Terminal terminal, Shift shift, Calendar currentTime) {
        UserDAO.getInstance().refresh(this);
        if (this.isClockedIn().booleanValue()) {
            throw new PosException("Duplicate clock in attempt for user " + this.getFullName());
        }
        List<User> linkedUsers = this.getLinkedUser();
        if (linkedUsers != null) {
            for (User user : linkedUsers) {
                if (!user.isClockedIn().booleanValue()) continue;
                throw new PosException("Duplicate clock in attempt for user " + this.getFullName());
            }
        }
        this.setClockedIn(true);
        this.setCurrentShift(shift);
        this.setLastClockInTime(currentTime.getTime());
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(true);
        }
        AttendenceHistory attendenceHistory = new AttendenceHistory();
        attendenceHistory.setClockInTime(currentTime.getTime());
        attendenceHistory.setClockInHour((short)currentTime.get(11));
        attendenceHistory.setUser(this);
        attendenceHistory.setTerminal(terminal);
        attendenceHistory.setShift(shift);
        UserDAO.getInstance().saveClockIn(this, attendenceHistory, shift, currentTime);
    }

    public void doClockOut(AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        this.setClockedIn(false);
        this.setCurrentShift(null);
        this.setLastClockInTime(null);
        this.setLastClockOutTime(null);
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(false);
        }
        attendenceHistory.setClockedOut(true);
        attendenceHistory.setClockOutTime(currentTime.getTime());
        attendenceHistory.setClockOutHour((short)currentTime.get(11));
        UserDAO.getInstance().saveClockOut(this, attendenceHistory, shift, currentTime);
    }

    public boolean canViewAllOpenTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> permissions = this.getType().getPermissions();
        if (permissions == null) {
            return false;
        }
        for (UserPermission permission : permissions) {
            if (!permission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public boolean canViewAllCloseTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> permissions = this.getType().getPermissions();
        if (permissions == null) {
            return false;
        }
        for (UserPermission permission : permissions) {
            if (!permission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public void setFullName(String str) {
    }

    public String getStatus() {
        if (this.isClockedIn().booleanValue()) {
            if (this.isAvailableForDelivery().booleanValue()) {
                return "Available";
            }
            return "Driving";
        }
        return "Not available";
    }

    public String getFullName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String toString() {
        return this.getFirstName() + " " + this.getLastName();
    }

    public boolean isManager() {
        return this.hasPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    public boolean isAdministrator() {
        return this.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK);
    }

    public void setImage(ImageIcon image) {
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId(), 150, 150);
    }

    public boolean hasLinkedUser() {
        List<User> linkedUser = this.getLinkedUser();
        if (linkedUser != null && linkedUser.size() > 0) {
            return true;
        }
        if (this.getParentUser() == null) {
            return false;
        }
        return this.getParentUser().hasLinkedUser();
    }

    public List<User> getLinkedUsersIfExists() {
        List<User> linkedUser = this.getLinkedUser();
        if (linkedUser != null) {
            if (!linkedUser.contains(this)) {
                linkedUser.add(0, this);
            }
            return linkedUser;
        }
        if (this.getParentUser() == null) {
            return null;
        }
        return this.getParentUser().getLinkedUsersIfExists();
    }

    public void setEncryptedPassword(String plainText) {
        try {
            super.setPassword(AESencrp.encrypt(plainText));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    @JsonIgnoreProperties
    public String getPasswordAsPlainText() {
        String secretKey = super.getPassword();
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                return AESencrp.decrypt(secretKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }
}

