/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.BaseCashDrawerDAO;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class CashDrawerDAO
extends BaseCashDrawerDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findReports(Date start, Date end) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)start));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)end));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession data, Boolean openDrawer) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            if (openDrawer != null) {
                criteria.add(openDrawer != false ? Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME) : Restrictions.isNotNull((String)CashDrawer.PROP_REPORT_TIME));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCashDrawerIds(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)CashDrawer.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer loadFullCashDrawer(String id) {
        Session session = null;
        try {
            session = this.createNewSession();
            CashDrawer cashDrawer = (CashDrawer)session.get(this.getReferenceClass(), (Serializable)((Object)id));
            Hibernate.initialize(cashDrawer.getTransactions());
            CashDrawer cashDrawer2 = cashDrawer;
            return cashDrawer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer loadFullCashDrawer(CashDrawer cashDrawer) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)cashDrawer);
            Hibernate.initialize(cashDrawer.getTransactions());
            CashDrawer cashDrawer2 = cashDrawer;
            return cashDrawer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfOpeningBalance(StoreSession storeSession) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
            Double openingBalance = (Double)criteria.uniqueResult();
            if (openingBalance == null) {
                double d = 0.0;
                return d;
            }
            double d = openingBalance;
            return d;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByUnSyncStoreOperationData(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)CashDrawer.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)CashDrawer.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateCashDrawerSync(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update CashDrawer set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, CashDrawer.PROP_CLOUD_SYNCED, CashDrawer.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)true);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCashDrawer(List<CashDrawer> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (CashDrawer item : dataList) {
                CashDrawerDAO dao = CashDrawerDAO.getInstance();
                CashDrawer existingItem = dao.get(item.getId());
                String userId = item.getAssignedUserId();
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    existingItem.setAssignedUserId(userId);
                    this.update(existingItem, session);
                    continue;
                }
                item.setVersion(0L);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

