/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.dao.BaseCustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PaginationSupport;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class CustomerDAO
extends BaseCustomerDAO {
    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)Customer.PROP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findBy(String mobile, String loyalty, String name, PaginatedTableModel tableModel) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobile)) {
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_MOBILE_NO, (Object)("%" + mobile + "%")));
            }
            if (StringUtils.isNotEmpty((String)loyalty)) {
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_LOYALTY_NO, (Object)("%" + loyalty + "%")));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_FIRST_NAME, (Object)("%" + name + "%")));
            }
            criteria.add((Criterion)disjunction);
            criteria.setFirstResult(0);
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setNumRows(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(String searchString) {
        Session session;
        block5: {
            Criteria criteria;
            block4: {
                int n;
                session = null;
                criteria = null;
                try {
                    if (!StringUtils.isEmpty((String)searchString)) break block4;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
                this.closeSession(session);
                return n;
            }
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + searchString + "%")));
            disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + searchString + "%")));
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list == null) break block5;
            int n = list.size();
            this.closeSession(session);
            return n;
        }
        int n = 0;
        this.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(String mobile, String loyalty, String name) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobile)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + mobile + "%")));
            }
            if (StringUtils.isNotEmpty((String)loyalty)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + loyalty + "%")));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + name + "%")));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list != null) {
                int n = list.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findBy(String mobile, String loyalty, String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobile)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + mobile + "%")));
            }
            if (StringUtils.isNotEmpty((String)loyalty)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + loyalty + "%")));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + name + "%")));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void findBy(String searchString, PaginationSupport tableModel) {
        this.findByPhoneOrName(searchString, tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByPhoneOrName(String searchString, PaginationSupport tableModel) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)searchString)) {
                disjunction.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchString, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchString, (MatchMode)MatchMode.ANYWHERE)));
            }
            criteria.add((Criterion)disjunction);
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            tableModel.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByMobileNumber(String mobileNo) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)mobileNo)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)mobileNo));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByName(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_FIRST_NAME, (String)(name + "%".trim()), (MatchMode)MatchMode.ANYWHERE));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer findById(String customerId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_ID, (Object)customerId));
            Customer customer = (Customer)criteria.uniqueResult();
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer findByPhoneOrEmail(String mobileNo, String email) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isEmpty((String)mobileNo)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)mobileNo), (Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email)));
            }
            List list = criteria.list();
            if (list.size() > 0) {
                Customer customer = (Customer)list.get(0);
                return customer;
            }
            Customer customer = null;
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public boolean deleteAll(List<Customer> customerList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            String queryDeliveryAddress = "update DELIVERY_ADDRESS set CUSTOMER_ID = null";
            String queryTableBookingInfo = "update TABLE_BOOKING_INFO set customer_id = null";
            String queryTicketItemSeat = "update TICKET_ITEM_SEAT set MEMBER_ID = null";
            SQLQuery deliveryAddressUpdateQuery = session.createSQLQuery(queryDeliveryAddress);
            SQLQuery tableBookingInfoUpdateQuery = session.createSQLQuery(queryTableBookingInfo);
            SQLQuery ticketItemSeatUpdateQuery = session.createSQLQuery(queryTicketItemSeat);
            deliveryAddressUpdateQuery.executeUpdate();
            tableBookingInfoUpdateQuery.executeUpdate();
            ticketItemSeatUpdateQuery.executeUpdate();
            for (Customer customer : customerList) {
                session.delete((Object)customer);
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(CustomerDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.list();
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(CustomerGroup customerGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "customer");
            criteria.setProjection(Projections.rowCount());
            if (customerGroup != null) {
                criteria.createAlias("customer.customerGroups", "customerGroup");
                criteria.add(Restrictions.in((String)"customerGroup.id", Arrays.asList(customerGroup.getId())));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(PaginatedTableModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(CustomerGroup customerGroup, PaginatedListModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "customer");
            criteria.addOrder(this.getDefaultOrder());
            if (customerGroup != null) {
                criteria.createAlias("customer.customerGroups", "customerGroup");
                criteria.add(Restrictions.in((String)"customerGroup.id", Arrays.asList(customerGroup.getId())));
            }
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setData(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String searchString) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(String searchString, BeanTableModel<Customer> listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer initialize(Customer customer) {
        if (customer == null || customer.getId() == null) {
            return customer;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customer);
            Hibernate.initialize(customer.getDeliveryAddresses());
            Hibernate.initialize(customer.getDeliveryInstructions());
            Customer customer2 = customer;
            return customer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findAllUnSyncCustomer() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)Customer.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)Customer.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateCustomers(List<Customer> customers) throws Exception {
        if (customers == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Customer customer : customers) {
                Customer existingCustomer = this.get(customer.getId());
                if (existingCustomer == null) {
                    this.save(customer, session);
                    continue;
                }
                String id = existingCustomer.getId();
                long version = existingCustomer.getVersion();
                PropertyUtils.copyProperties((Object)existingCustomer, (Object)customer);
                existingCustomer.setId(id);
                existingCustomer.setVersion(version);
                this.update(existingCustomer, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateCustomerSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update Customer set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, Customer.PROP_CLOUD_SYNCED, Customer.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

