/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseDepartmentDAO;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class DepartmentDAO
extends BaseDepartmentDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department initialize(Department dept) {
        if (dept == null || dept.getId() == null) {
            return dept;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)dept);
            Hibernate.initialize(dept.getOutlets());
            Department department = dept;
            return department;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findByOrderType(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("orderTypes", "o");
            criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDepartment(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (orderType != null) {
                criteria.createAlias("orderTypes", "o");
                criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            }
            boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findDepartmentbyOutlet(Outlet outlet) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                List<Department> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department findById(String departmentId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Department.PROP_ID, (Object)departmentId));
            Department department = (Department)criteria.uniqueResult();
            return department;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findAllUnSyncDepartment() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)Department.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)Department.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateDepartmentSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update Department set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, Department.PROP_CLOUD_SYNCED, Department.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateDepartments(List<Department> departments) throws Exception {
        if (departments == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Department department : departments) {
                Department existingItem = this.get(department.getId());
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)department);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                department.setVersion(0L);
                this.save(department, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

