/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseGratuityDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.StoreUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GratuityDAO
extends BaseGratuityDAO {
    public List<Gratuity> findByUser(User user) throws PosException {
        return this.findByUser(user, false);
    }

    public List<Gratuity> findByUser(User user, boolean includePaid) throws PosException {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (!includePaid) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_PAID, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            throw new PosException("" + user.getFirstName() + " " + user.getLastName());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void payGratuities(List<Gratuity> gratuities, List<GratuityPaymentHistory> gratuityPaymentList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Gratuity gratuity : gratuities) {
                session.saveOrUpdate((Object)gratuity);
            }
            for (GratuityPaymentHistory gratuityPayment : gratuityPaymentList) {
                session.saveOrUpdate((Object)gratuityPayment);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new PosException("");
        }
        finally {
            this.closeSession(session);
        }
    }

    public TipsCashoutReport createReport(Date fromDate, Date toDate, User user) {
        return this.createReport(fromDate, toDate, user, false);
    }

    public TipsCashoutReport createReport(Date fromDate, Date toDate, User user, boolean showCurrentSessionHistory) {
        Session session = null;
        try {
            Object uniqueResult;
            session = this.getSession();
            if (fromDate != null) {
                fromDate = DateUtil.startOfDay(fromDate);
            }
            if (toDate != null) {
                toDate = DateUtil.endOfDay(toDate);
            }
            Criteria criteria = session.createCriteria(Ticket.class);
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            TipsCashoutReport report = new TipsCashoutReport();
            StoreSession currentData = StoreUtil.getCurrentStoreOperation().getCurrentData();
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_GRATUITY));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)new Double(0.0)));
            if (showCurrentSessionHistory) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)currentData.getOpenTime()));
                report.setFromDate(currentData.getOpenTime());
                report.setToDate(new Date());
            } else if (fromDate == null && toDate == null) {
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_PAID), (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_REFUNDED), (Object)Boolean.FALSE));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
            }
            List list = criteria.list();
            report.setServer(user == null ? "ALL" : user.getId() + "/" + user.toString());
            report.setReportTime(new Date());
            if (!showCurrentSessionHistory) {
                report.setFromDate(fromDate);
                report.setToDate(toDate);
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Set<PosTransaction> transactions;
                Ticket ticket = (Ticket)iter.next();
                Gratuity gratuity = ticket.getGratuity();
                TipsCashoutReportData data = new TipsCashoutReportData();
                data.setTicketId(String.valueOf(ticket.getTokenNo()));
                data.setTicketTotal(ticket.getTotalAmountWithTips());
                if (gratuity != null) {
                    data.setDeclareTipsAmount(gratuity.getDeclareTipsAmount());
                }
                if ((ticket = TicketDAO.getInstance().loadCouponsAndTransactions(ticket.getId())) != null && (transactions = ticket.getTransactions()) != null && transactions.size() > 0) {
                    for (PosTransaction posTransaction : transactions) {
                        if (posTransaction instanceof CashTransaction) {
                            data.setCashTips(data.getCashTips() + posTransaction.getTipsAmount());
                            continue;
                        }
                        data.setChargedTips(data.getChargedTips() + posTransaction.getTipsAmount());
                    }
                }
                if (gratuity != null && !gratuity.isRefunded().booleanValue()) {
                    if (fromDate == null && toDate == null && data.getCashTips() + data.getChargedTips() + data.getDeclareTipsAmount() <= 0.0) {
                        iter.remove();
                        continue;
                    }
                    if (gratuity.getAmount() > 0.0) {
                        data.setSaleType("");
                    }
                    data.setPaid(gratuity.isPaid());
                    data.setTipsPaidAmount(gratuity.getTipsPaidAmount());
                }
                report.addReportData(data);
            }
            criteria = session.createCriteria(DeclaredTips.class);
            criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
            if (fromDate == null && toDate == null) {
                criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)currentData.getId()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)DeclaredTips.PROP_DECLARED_TIME, (Object)fromDate));
                criteria.add((Criterion)Restrictions.le((String)DeclaredTips.PROP_DECLARED_TIME, (Object)toDate));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((uniqueResult = criteria.uniqueResult()) != null) {
                report.setDeclaredTipsAmount((Double)uniqueResult);
            }
            report.calculateOthers();
            TipsCashoutReport tipsCashoutReport = report;
            return tipsCashoutReport;
        }
        catch (Exception e) {
            if (user != null) {
                throw new PosException("" + user.getFirstName() + " " + user.getLastName(), e);
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findTotalGratuityAmount(Date fromDate, Date toDate, User user) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_OWNER_ID, (Object)user.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_REFUNDED, (Object)Boolean.FALSE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)Gratuity.PROP_AMOUNT), Gratuity.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            Number totalAmount = (Number)criteria.uniqueResult();
            if (totalAmount != null) {
                double d = totalAmount.doubleValue();
                return d;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0.0;
    }

    public void saveOrUpdateGratuity(Gratuity gratuity, Session session) throws Exception {
        if (gratuity == null) {
            return;
        }
        Gratuity existingItem = this.get(gratuity.getId());
        if (existingItem != null) {
            String id = existingItem.getId();
            long version = existingItem.getVersion();
            PropertyUtils.copyProperties((Object)existingItem, (Object)gratuity);
            existingItem.setId(id);
            existingItem.setVersion(version);
            this.update(existingItem, session);
        } else {
            gratuity.setVersion(0L);
            this.save(gratuity, session);
        }
    }
}

