/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseInventoryClosingBalanceDAO;
import com.floreantpos.model.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

public class InventoryClosingBalanceDAO
extends BaseInventoryClosingBalanceDAO {
    public void closeStock(Date closingMonth, Date closingDate) throws Exception {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<InventoryClosingBalance> dataList = this.closeInventoryStock(session, DateUtil.endOfMonth(closingMonth), closingDate, true);
            if (dataList == null || dataList.isEmpty()) {
                throw new PosException("No data found");
            }
            closingDate = DateUtil.startOfDay(closingDate);
            for (InventoryClosingBalance data : dataList) {
                data.setClosingDate(closingDate);
                session.saveOrUpdate((Object)data);
            }
            tx.commit();
        }
    }

    public List<InventoryClosingBalance> closeInventoryStock(Session session, Date closingUpToDate, Date closingDate, boolean includeAllItems) {
        Date lastClosingDate;
        Criteria criteria = null;
        Map<String, InventoryClosingBalance> itemMap = this.getInventoryItems(session);
        HashMap<String, InventoryClosingBalance> dataMap = new HashMap<String, InventoryClosingBalance>();
        Date existingClosingDate = this.getExistingClosingDate(closingUpToDate, closingDate);
        if (existingClosingDate != null) {
            List dataList;
            criteria = session.createCriteria(InventoryClosingBalance.class);
            if (existingClosingDate != null) {
                existingClosingDate = DateUtil.startOfDay(existingClosingDate);
                criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)existingClosingDate));
                criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay(existingClosingDate)));
            }
            if ((dataList = criteria.list()) != null && dataList.size() > 0) {
                for (InventoryClosingBalance inventoryStockData : dataList) {
                    inventoryStockData.setBalance(0.0);
                    dataMap.put(this.generateKey(inventoryStockData), inventoryStockData);
                }
            }
        }
        if ((lastClosingDate = this.getLastClosingDate(closingUpToDate)) != null) {
            List dataList;
            lastClosingDate = DateUtil.startOfDay(lastClosingDate);
            criteria = session.createCriteria(InventoryClosingBalance.class);
            if (lastClosingDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)lastClosingDate));
                criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay(lastClosingDate)));
            }
            if ((dataList = criteria.list()) != null && dataList.size() > 0) {
                for (InventoryClosingBalance inventoryStockData : dataList) {
                    String key = this.generateKey(inventoryStockData);
                    InventoryClosingBalance stockData = (InventoryClosingBalance)dataMap.get(key);
                    if (stockData != null) {
                        stockData.setBalance(stockData.getBalance() + inventoryStockData.getBalance());
                        continue;
                    }
                    InventoryClosingBalance nextClosingBalance = new InventoryClosingBalance();
                    nextClosingBalance.setMenuItemId(inventoryStockData.getMenuItemId());
                    nextClosingBalance.setLocationId(inventoryStockData.getLocationId());
                    nextClosingBalance.setUnit(inventoryStockData.getUnit());
                    nextClosingBalance.setBalance(inventoryStockData.getBalance());
                    dataMap.put(key, nextClosingBalance);
                }
            }
        }
        this.populateInventoryTransactions(session, dataMap, closingDate, lastClosingDate);
        ArrayList<InventoryClosingBalance> stockDataList = new ArrayList<InventoryClosingBalance>(dataMap.values());
        Iterator iterator = stockDataList.iterator();
        while (iterator.hasNext()) {
            InventoryClosingBalance itemData;
            InventoryClosingBalance data = (InventoryClosingBalance)iterator.next();
            if (!includeAllItems && data.getBalance() == 0.0) {
                iterator.remove();
            }
            if ((itemData = itemMap.get(data.getMenuItemId())) == null || !includeAllItems || itemData == null) continue;
            itemMap.remove(data.getMenuItemId());
        }
        if (includeAllItems && itemMap.values().size() > 0) {
            stockDataList.addAll(itemMap.values());
        }
        return stockDataList;
    }

    private String generateKey(InventoryClosingBalance inventoryStockData) {
        return inventoryStockData.getMenuItemId() + inventoryStockData.getUnit() + inventoryStockData.getLocationId();
    }

    private void populateInventoryTransactions(Session session, Map<String, InventoryClosingBalance> dataMap, Date closingDate, Date lastClosingDate) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.setProjection((Projection)Projections.property((String)InventoryLocation.PROP_ID));
        List locationIds = criteria.list();
        if (locationIds != null) {
            for (String locationId : locationIds) {
                criteria = session.createCriteria(InventoryTransaction.class);
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                ProjectionList projections = Projections.projectionList();
                projections.add((Projection)Projections.property((String)"item.id"), InventoryClosingBalance.PROP_MENU_ITEM_ID);
                projections.add((Projection)Projections.property((String)InventoryTransaction.PROP_UNIT), InventoryClosingBalance.PROP_UNIT);
                projections.add(Projections.sqlProjection((String)("sum(quantity*tran_type) AS " + InventoryClosingBalance.PROP_BALANCE), (String[])new String[]{InventoryClosingBalance.PROP_BALANCE}, (Type[])new Type[]{new DoubleType()}));
                projections.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT));
                projections.add((Projection)Projections.groupProperty((String)"item.id"));
                criteria.setProjection((Projection)projections);
                if (lastClosingDate != null) {
                    criteria.add((Criterion)Restrictions.gt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)lastClosingDate));
                }
                criteria.add((Criterion)Restrictions.lt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)closingDate));
                if (locationId != null) {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)locationId), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TO_LOCATION_ID, (Object)locationId)));
                }
                criteria.setResultTransformer(Transformers.aliasToBean(InventoryClosingBalance.class));
                List dataList = criteria.list();
                if (dataList == null || dataList.size() <= 0) continue;
                for (InventoryClosingBalance tData : dataList) {
                    tData.setLocationId(locationId);
                    String key = this.generateKey(tData);
                    InventoryClosingBalance stockData = dataMap.get(key);
                    if (stockData != null) {
                        stockData.setBalance(stockData.getBalance() + tData.getBalance());
                        continue;
                    }
                    dataMap.put(key, tData);
                }
            }
        }
    }

    private Map<String, InventoryClosingBalance> getInventoryItems(Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        ProjectionList list = Projections.projectionList();
        list.add((Projection)Projections.property((String)MenuItem.PROP_ID), InventoryClosingBalance.PROP_MENU_ITEM_ID);
        list.add((Projection)Projections.property((String)MenuItem.PROP_UNIT_NAME), InventoryClosingBalance.PROP_UNIT);
        criteria.setProjection((Projection)list);
        criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
        criteria.setResultTransformer(Transformers.aliasToBean(InventoryClosingBalance.class));
        List dataList = criteria.list();
        HashMap<String, InventoryClosingBalance> itemMap = new HashMap<String, InventoryClosingBalance>();
        if (dataList != null && dataList.size() > 0) {
            for (InventoryClosingBalance inventoryStockData : dataList) {
                itemMap.put(inventoryStockData.getMenuItemId(), inventoryStockData);
            }
        }
        return itemMap;
    }

    public Date getExistingClosingDate(Date previousMonthEndDate, Date closingDate) {
        Criteria criteria = this.getSession().createCriteria(this.getReferenceClass());
        Date from = DateUtil.startOfDay(previousMonthEndDate);
        Date to = DateUtil.endOfDay(closingDate);
        criteria.setProjection((Projection)Projections.property((String)InventoryClosingBalance.PROP_CLOSING_DATE));
        criteria.add((Criterion)Restrictions.gt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)from));
        criteria.add((Criterion)Restrictions.le((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)to));
        criteria.setMaxResults(1);
        return (Date)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastClosingDate(Date closingDate) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.distinct((Projection)Projections.max((String)InventoryClosingBalance.PROP_CLOSING_DATE)));
            criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)closingDate));
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstInventoryTransactionDate() {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(InventoryTransaction.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.min((String)InventoryTransaction.PROP_TRANSACTION_DATE)));
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
    }
}

