/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseInventoryStockDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryStockDAO
extends BaseInventoryStockDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock initialize(InventoryStock inventoryStock) {
        if (inventoryStock == null || inventoryStock.getId() == null) {
            return inventoryStock;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryStock);
            InventoryStock inventoryStock2 = inventoryStock;
            return inventoryStock2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<InventoryStock> getInventoryStock(String itemName, Object selectedType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryStock.class);
            if (StringUtils.isNotEmpty((String)itemName)) {
                Disjunction or = Restrictions.disjunction();
                or.add(Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)InventoryStock.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)InventoryStock.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)or);
            }
            List similarItems = criteria.list();
            if (selectedType instanceof InventoryLocation) {
                InventoryLocation location = (InventoryLocation)selectedType;
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
                similarItems = criteria.list();
            }
            if (similarItems != null) {
                Iterator iterator = similarItems.iterator();
                while (iterator.hasNext()) {
                    InventoryStock inventoryStock = (InventoryStock)iterator.next();
                    MenuItem menuItem = MenuItemDAO.getInstance().get(inventoryStock.getMenuItemId());
                    if (menuItem == null || menuItem.isInventoryItem().booleanValue()) continue;
                    iterator.remove();
                }
            }
            return similarItems;
        }
        catch (Exception exception) {
            return criteria.list();
        }
    }

    public void addNewStock(InventoryStock stock, InventoryTransaction transaction, MenuItem menuItem) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)stock);
            session.saveOrUpdate((Object)transaction);
            session.saveOrUpdate((Object)menuItem);
            tx.commit();
        }
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, InventoryLocation location, String unitCode) {
        if (location == null) {
            return this.getInventoryStock(menuItem, (String)null, unitCode);
        }
        return this.getInventoryStock(menuItem, location.getId(), unitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock getInventoryStock(MenuItem menuItem, String locationId, String unitCode) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryStock inventoryStock = this.getInventoryStock(menuItem, locationId, unitCode, session);
            return inventoryStock;
        }
        catch (Exception e) {
            PosLog.error(InventoryStockDAO.class, e.getMessage(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, String locationId, String unitCode, Session session) {
        List list;
        Criteria criteria = session.createCriteria(InventoryStock.class);
        if (menuItem != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        }
        if (locationId != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)locationId));
        }
        if (unitCode != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_UNIT, (Object)unitCode));
        }
        if ((list = criteria.list()) != null && list.size() > 0) {
            return (InventoryStock)list.get(0);
        }
        return null;
    }

    public List<InventoryStock> getInventoryStocks(MenuItem menuItem) {
        return this.getInventoryStocks(menuItem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStock> getInventoryStocks(MenuItem menuItem, InventoryLocation location) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryStock.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            if (location != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public void addTransfer(InventoryTransaction inTransaction, InventoryTransaction outTransaction, InventoryStock inStock, InventoryStock outStock, MenuItem menuItem) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)inStock);
            session.saveOrUpdate((Object)outStock);
            session.saveOrUpdate((Object)inTransaction);
            session.saveOrUpdate((Object)outTransaction);
            session.saveOrUpdate((Object)menuItem);
            tx.commit();
        }
    }

    public List<InventoryStock> getInventoryOnhandReprotData(String nameOrSku, InventoryLocation location) {
        Session session = null;
        Criteria criteria = null;
        HashMap inventoryLocMap = new HashMap();
        HashMap menuItemMap = new HashMap();
        session = this.getSession();
        criteria = session.createCriteria(InventoryStock.class);
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
        if (StringUtils.isNotEmpty((String)nameOrSku)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)nameOrSku, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)InventoryStock.PROP_SKU, (Object)nameOrSku)));
        }
        if (location != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
        }
        List stockList = criteria.list();
        for (InventoryStock inventoryStock : stockList) {
            String menuItemId = inventoryStock.getMenuItemId();
            String locationId = inventoryStock.getLocationId();
            Double cost = (Double)menuItemMap.get(menuItemId);
            String locationName = (String)inventoryLocMap.get(locationId);
            if (cost == null) {
                cost = this.getMenuItemCost(menuItemId, session);
            }
            if (locationName == null) {
                locationName = this.getLocationName(locationId, session);
            }
            inventoryStock.setMenuItemCost(cost);
            inventoryStock.setLocationName(locationName);
        }
        return stockList;
    }

    private String getLocationName(String locationId, Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ID, (Object)locationId));
        criteria.setProjection((Projection)Projections.property((String)InventoryLocation.PROP_NAME));
        Object result = criteria.uniqueResult();
        if (result instanceof String) {
            return ((String)result).toString();
        }
        return null;
    }

    private Double getMenuItemCost(String menuItemId, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItemId));
        criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_COST));
        Object result = criteria.uniqueResult();
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStock> findStocksForStockCountMultiItemSelection(MenuGroup group, InventoryVendor vendor, InventoryLocation location) {
        Criteria criteria;
        Session session;
        block9: {
            List<InventoryStock> list;
            session = null;
            criteria = null;
            try {
                if (location != null) break block9;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.createNewSession();
        List commonMenuItemsId = null;
        if (vendor != null) {
            criteria = session.createCriteria(InventoryVendorItems.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
            criteria.setProjection((Projection)Projections.property((String)"item.id"));
            commonMenuItemsId = criteria.list();
        }
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
        criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
        if (group != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)group.getId()));
        }
        if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)commonMenuItemsId));
        }
        criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_ID));
        if (commonMenuItemsId == null) {
            commonMenuItemsId = criteria.list();
        } else {
            commonMenuItemsId.retainAll(criteria.list());
        }
        criteria = session.createCriteria(InventoryStock.class);
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_UNIT));
        criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
        if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
            criteria.add(Restrictions.in((String)InventoryStock.PROP_MENU_ITEM_ID, (Collection)commonMenuItemsId));
        }
        List list = criteria.list();
        this.closeSession(session);
        return list;
    }
}

