/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseInventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginationSupport;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryTransactionDAO
extends BaseInventoryTransactionDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction initialize(InventoryTransaction inventoryTransaction) {
        if (inventoryTransaction == null || inventoryTransaction.getId() == null) {
            return inventoryTransaction;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryTransaction);
            InventoryTransaction inventoryTransaction2 = inventoryTransaction;
            return inventoryTransaction2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventoryStock(InventoryTransaction trans, Session session) {
        this.adjustInventoryStock(trans, session, true, true);
    }

    public void adjustInventoryStock(InventoryTransaction trans, Session session, boolean updateAvailableUnit, boolean updateOnHandUnit) {
        MenuItem menuItem = trans.getMenuItem();
        double baseUnitQuantity = menuItem.getBaseUnitQuantity(trans.getUnit());
        String baseUnit = "";
        if (menuItem.getUnit() != null) {
            baseUnit = menuItem.getUnit().getCode();
        }
        trans.setBaseUnit(baseUnit);
        trans.setBaseUnitQuantity(baseUnitQuantity);
        InventoryLocation inventoryFromLocation = null;
        InventoryLocation inventoryToLocation = null;
        InventoryStock stockItem = null;
        double unitQuantity = 0.0;
        PosLog.info(this.getClass(), menuItem.getDisplayName() + " |" + (Object)((Object)trans.getTransactionType()) + "| |" + trans.getQuantity() + "| " + trans.getReason());
        if (trans.getTransactionType() == InventoryTransactionType.IN) {
            inventoryToLocation = trans.getToInventoryLocation();
            stockItem = InventoryStockDAO.getInstance().getInventoryStock(menuItem, trans.getToLocationId(), trans.getUnit(), session);
            unitQuantity = this.createStockItem(trans, session, menuItem, baseUnitQuantity, stockItem, inventoryToLocation);
            session.saveOrUpdate((Object)trans);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), unitQuantity, updateAvailableUnit, updateOnHandUnit, session);
        }
        if (trans.getTransactionType() == InventoryTransactionType.OUT) {
            inventoryFromLocation = trans.getFromInventoryLocation();
            stockItem = InventoryStockDAO.getInstance().getInventoryStock(menuItem, trans.getFromLocationId(), trans.getUnit(), session);
            unitQuantity = this.createStockItem(trans, session, menuItem, baseUnitQuantity, stockItem, inventoryFromLocation);
            InventoryTransactionDAO.getInstance().saveOrUpdate(trans, session);
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), unitQuantity, updateAvailableUnit, updateOnHandUnit, session);
        }
        if (trans.getTransactionType() == InventoryTransactionType.UNCHANGED) {
            inventoryFromLocation = trans.getFromInventoryLocation();
            inventoryToLocation = trans.getToInventoryLocation();
            this.createStockItemForTransfer(trans, session, menuItem, baseUnitQuantity, trans.getFromLocationId(), trans.getToLocationId());
            InventoryTransactionDAO.getInstance().saveOrUpdate(trans, session);
        }
        if (trans.getTransactionType() == InventoryTransactionType.CONVERSION) {
            inventoryFromLocation = trans.getFromInventoryLocation();
            inventoryToLocation = trans.getToInventoryLocation();
            InventoryStock fromStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, trans.getFromLocationId(), trans.getUnit(), session);
            InventoryStock toStock = InventoryStockDAO.getInstance().getInventoryStock(menuItem, trans.getToLocationId(), trans.getBaseUnit(), session);
            this.createConversionStockItem(trans, session, menuItem, baseUnitQuantity, fromStock, toStock, inventoryToLocation);
            InventoryTransactionDAO.getInstance().saveOrUpdate(trans, session);
        }
    }

    private void createStockItemForTransfer(InventoryTransaction trans, Session session, MenuItem menuItem, double baseUnitQuantity, String fromLocationId, String toLocationId) {
        InventoryStock stockItemFromLocation = InventoryStockDAO.getInstance().getInventoryStock(menuItem, fromLocationId, trans.getUnit(), session);
        InventoryStock stockItemToLocation = InventoryStockDAO.getInstance().getInventoryStock(menuItem, toLocationId, trans.getUnit(), session);
        if (stockItemFromLocation == null) {
            return;
        }
        if (stockItemToLocation == null) {
            stockItemToLocation = new InventoryStock();
            stockItemToLocation.setMenuItem(menuItem);
            stockItemToLocation.setLocationId(toLocationId);
            stockItemToLocation.setUnit(trans.getUnit());
        }
        stockItemFromLocation.setQuantityInHand(stockItemFromLocation.getQuantityInHand() - trans.getQuantity());
        stockItemToLocation.setQuantityInHand(stockItemToLocation.getQuantityInHand() + trans.getQuantity());
        if (stockItemFromLocation.getQuantityInHand() == 0.0) {
            session.delete((Object)stockItemFromLocation);
        } else {
            session.saveOrUpdate((Object)stockItemFromLocation);
        }
        session.saveOrUpdate((Object)stockItemToLocation);
    }

    private double createStockItem(InventoryTransaction trans, Session session, MenuItem menuItem, double baseUnitQuantity, InventoryStock stockItem, InventoryLocation inventoryLocation) {
        if (stockItem == null) {
            stockItem = new InventoryStock();
            stockItem.setMenuItem(menuItem);
            stockItem.setLocationId(inventoryLocation.getId());
            stockItem.setUnit(trans.getUnit());
        }
        if (trans.getTransactionType() == InventoryTransactionType.IN) {
            stockItem.setQuantityInHand(stockItem.getQuantityInHand() + trans.getQuantity());
        }
        if (trans.getTransactionType() == InventoryTransactionType.OUT) {
            stockItem.setQuantityInHand(stockItem.getQuantityInHand() - trans.getQuantity());
        }
        double unitQuantity = 0.0;
        if (trans.getTransactionType() == InventoryTransactionType.IN) {
            unitQuantity += baseUnitQuantity * trans.getQuantity();
        }
        if (trans.getTransactionType() == InventoryTransactionType.OUT) {
            unitQuantity -= baseUnitQuantity * trans.getQuantity();
        }
        if (stockItem.getQuantityInHand() == 0.0) {
            session.delete((Object)stockItem);
        } else {
            session.saveOrUpdate((Object)stockItem);
        }
        return unitQuantity;
    }

    private void createConversionStockItem(InventoryTransaction trans, Session session, MenuItem menuItem, double baseUnitQuantity, InventoryStock fromStockItem, InventoryStock toStockItem, InventoryLocation inventoryLocation) {
        if (toStockItem == null) {
            toStockItem = new InventoryStock();
            toStockItem.setMenuItem(menuItem);
            toStockItem.setLocationId(inventoryLocation.getId());
            toStockItem.setUnit(trans.getBaseUnit());
        }
        toStockItem.setQuantityInHand(toStockItem.getQuantityInHand() + trans.getQuantity() * baseUnitQuantity);
        fromStockItem.setQuantityInHand(fromStockItem.getQuantityInHand() - trans.getQuantity());
        if (fromStockItem.getQuantityInHand() == 0.0) {
            session.delete((Object)fromStockItem);
        } else {
            session.saveOrUpdate((Object)fromStockItem);
        }
        session.saveOrUpdate((Object)toStockItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInventoryTransaction(InventoryTransaction trans) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.adjustInventoryStock(trans, session);
            tx.commit();
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex);
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInventoryTransactionList(List<InventoryTransaction> inventoryTransactions) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (InventoryTransaction inventoryTransaction : inventoryTransactions) {
                this.adjustInventoryStock(inventoryTransaction, session);
                if (inventoryTransaction.getReason().equals("PURCHASE")) {
                    InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
                    continue;
                }
                if (!inventoryTransaction.getReason().equals("NEW STOCK")) continue;
                InventoryVendorItemsDAO.getInstance().saveItems(inventoryTransaction, session);
            }
            tx.commit();
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex);
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInventoryTransfer(InventoryTransaction inTrans, InventoryTransaction outTrans) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            InventoryStock stockIn = InventoryStockDAO.getInstance().getInventoryStock(inTrans.getMenuItem(), inTrans.getToLocationId(), inTrans.getUnit());
            if (stockIn == null) {
                stockIn = new InventoryStock();
                stockIn.setMenuItem(inTrans.getMenuItem());
                stockIn.setLocationId(inTrans.getToLocationId());
                stockIn.setQuantityInHand(inTrans.getQuantity());
                stockIn.setUnit(inTrans.getUnit());
            } else {
                stockIn.setQuantityInHand(stockIn.getQuantityInHand() + inTrans.getQuantity());
            }
            InventoryStock stockOut = InventoryStockDAO.getInstance().getInventoryStock(outTrans.getMenuItem(), outTrans.getFromLocationId(), outTrans.getUnit());
            if (stockOut == null) {
                stockOut = new InventoryStock();
                stockOut.setMenuItem(outTrans.getMenuItem());
                stockOut.setLocationId(outTrans.getFromLocationId());
                stockOut.setQuantityInHand(outTrans.getQuantity());
                stockOut.setUnit(outTrans.getUnit());
            } else {
                stockOut.setQuantityInHand(stockOut.getQuantityInHand() - outTrans.getQuantity());
            }
            session.saveOrUpdate((Object)inTrans);
            session.saveOrUpdate((Object)outTrans);
            session.saveOrUpdate((Object)stockIn);
            session.saveOrUpdate((Object)stockOut);
            tx.commit();
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex);
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            InventoryTransaction transaction = this.get(id, session);
            MenuItem menuItem = transaction.getMenuItem();
            menuItem.setAvailableUnit(menuItem.getAvailableUnit() - transaction.getQuantity());
            session.saveOrUpdate((Object)menuItem);
            session.delete((Object)transaction);
            tx.commit();
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex);
            tx.rollback();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction getInventoryTransaction(int referenceId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.createAlias(InventoryTransaction.PROP_REFERENCE_NO, "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)referenceId));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                InventoryTransaction inventoryTransaction = null;
                return inventoryTransaction;
            }
            InventoryTransaction inventoryTransaction = (InventoryTransaction)result.get(0);
            return inventoryTransaction;
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurchaseOrder getPurchaseOrderId(String referenceId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(PurchaseOrder.class);
            criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_ORDER_ID, (Object)referenceId));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                PurchaseOrder purchaseOrder = null;
                return purchaseOrder;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)result.get(0);
            return purchaseOrder;
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsByType(String menuItemNameOrSku, List<Integer> transactionTypes, MenuGroup menuGroup, MenuCategory menuCategory, Date fromDate, Date toDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromDate, (Object)toDate));
            if (transactionTypes != null && !transactionTypes.isEmpty()) {
                criteria.add(Restrictions.in((String)InventoryTransaction.PROP_TYPE, transactionTypes));
            }
            if (StringUtils.isNotEmpty((String)menuItemNameOrSku)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"menuItem.name", (String)menuItemNameOrSku, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)"menuItem.sku", (Object)menuItemNameOrSku)));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_GROUP_ID), (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_MENU_CATEGORY_ID), (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)"menuItem.name"));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryTransaction findOpeningBalance(MenuItem menuItem, Date fromdate, Date toDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromdate));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)toDate));
            List list = criteria.list();
            InventoryTransaction sum = new InventoryTransaction();
            double openingQty = 0.0;
            double openingCost = 0.0;
            double openingTotalCost = 0.0;
            for (InventoryTransaction inventoryTransaction : list) {
                openingQty += inventoryTransaction.getQuantity().doubleValue();
                openingTotalCost += inventoryTransaction.getTotal().doubleValue();
            }
            openingCost = openingTotalCost / openingQty;
            if (Double.isNaN(openingCost)) {
                openingCost = 0.0;
            }
            sum.setQuantity(openingQty);
            sum.setTotal(openingTotalCost);
            sum.setUnitCost(openingCost);
            InventoryTransaction inventoryTransaction = sum;
            return inventoryTransaction;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactionsForAvgCosting(MenuGroup menuGroup, Date fromdate, Date toDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromdate));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)toDate));
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "menuItem");
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_MENU_ITEM));
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String itemName, Object selectedType, Date fromDate, Date toDate) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromDate, (Object)toDate));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + itemName + "%")));
            }
            if (selectedType instanceof InventoryLocation) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)((InventoryLocation)selectedType).getId()));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void getInventoryTransactions(PaginationSupport model, String itemName, Object selectedType, Date fromDate, Date toDate) {
        Session session = null;
        Criteria criteria = null;
        session = this.getSession();
        criteria = session.createCriteria(InventoryTransaction.class);
        criteria.add(Restrictions.between((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromDate, (Object)toDate));
        if (StringUtils.isNotEmpty((String)itemName)) {
            criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
            criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + itemName + "%")));
        }
        if (selectedType instanceof InventoryLocation) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)((InventoryLocation)selectedType).getId()));
        }
        criteria.setFirstResult(model.getCurrentRowIndex());
        criteria.setMaxResults(model.getPageSize());
        List list = criteria.list();
        model.setRows(list);
        criteria.setProjection(Projections.rowCount());
        Number rowCount = (Number)criteria.uniqueResult();
        if (rowCount != null) {
            model.setNumRows(rowCount.intValue());
        }
    }

    public List<InventoryTransaction> getInventoryTransactionsByItemName(String itemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            List similarItems;
            session = this.getSession();
            criteria = session.createCriteria(InventoryTransaction.class);
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                criteria.add(Restrictions.ilike((String)"item.name", (Object)("%" + itemName + "%")));
            }
            if ((similarItems = criteria.list()) == null || similarItems.size() == 0) {
                return null;
            }
            return similarItems;
        }
        catch (Exception exception) {
            return criteria.list();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket getTicketId(int referenceId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)referenceId));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                Ticket ticket = null;
                return ticket;
            }
            Ticket ticket = (Ticket)result.get(0);
            return ticket;
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findItemAvgCost(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_MENU_ITEM, (Object)menuItem));
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            calendar.set(5, 1);
            Date lastMonthStart = DateUtil.startOfDay(calendar.getTime());
            calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            Date thisMonthEnd = DateUtil.endOfDay(calendar.getTime());
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)lastMonthStart));
            criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)thisMonthEnd));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
            projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            Object[] object = (Object[])list.get(0);
            double quantity = 0.0;
            if (object[0] != null) {
                quantity = ((Number)object[0]).doubleValue();
            }
            double total = 0.0;
            if (object[1] != null) {
                total = ((Number)object[1]).doubleValue();
            }
            if (quantity == 0.0) {
                double d = 0.0;
                return d;
            }
            double d = total / quantity;
            return d;
        }
        finally {
            this.closeSession(session);
        }
    }

    public double findItemAvgCost(String menuItemId, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
        criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItemId));
        criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        Date lastMonthStart = DateUtil.startOfDay(calendar.getTime());
        calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        Date thisMonthEnd = DateUtil.endOfDay(calendar.getTime());
        criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)lastMonthStart));
        criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)thisMonthEnd));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_QUANTITY));
        projectionList.add((Projection)Projections.sum((String)InventoryTransaction.PROP_TOTAL));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        Object[] object = (Object[])list.get(0);
        double quantity = 0.0;
        if (object[0] != null) {
            quantity = ((Number)object[0]).doubleValue();
        }
        double total = 0.0;
        if (object[1] != null) {
            total = ((Number)object[1]).doubleValue();
        }
        if (quantity == 0.0) {
            return 0.0;
        }
        return total / quantity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryTransaction> findTransactions(String reason, InventoryTransactionType transactionType) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (transactionType != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)transactionType.getType()));
            }
            if (reason != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)reason));
            }
            criteria.addOrder(Order.asc((String)InventoryTransaction.PROP_TRANSACTION_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

