/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuItemDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;

public class MenuItemDAO
extends BaseMenuItemDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        ((MenuItem)obj).setLastUpdateTime(StoreDAO.getServerTimestamp());
        Serializable serializable = super.save(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
        return serializable;
    }

    @Override
    protected void update(Object obj, Session s) {
        ((MenuItem)obj).setLastUpdateTime(StoreDAO.getServerTimestamp());
        super.update(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        ((MenuItem)obj).setLastUpdateTime(StoreDAO.getServerTimestamp());
        super.saveOrUpdate(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
    }

    private void updateDependentModels(MenuItem menuItem, Session session) {
        this.saveInventoryStockStatus(menuItem, session);
        MenuPageItemDAO menuPageItemDAO = MenuPageItemDAO.getInstance();
        List<MenuPageItem> pageItems = menuPageItemDAO.getPageItemFor(menuItem, session);
        if (pageItems != null) {
            for (MenuPageItem menuPageItem : pageItems) {
                menuPageItem.setMenuItem(menuItem);
                menuPageItemDAO.saveOrUpdate(menuPageItem, session);
            }
        }
        List<ComboItem> comboItems = ComboItemDAO.getInstance().getByMenuItem(menuItem.getId(), session);
        for (ComboItem comboItem : comboItems) {
            comboItem.setMenuItem(menuItem);
            ComboItemDAO.getInstance().update(comboItem, session);
        }
        this.updateDependentStockModel(menuItem, session);
    }

    private void updateDependentStockModel(MenuItem menuItem, Session session) throws HibernateException {
        String hqlString = "update InventoryStock set %s=:itemName, %s=:sku, %s=:barCode where %s=:menuItemId";
        hqlString = String.format(hqlString, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_BARCODE, InventoryStock.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("itemName", (Object)menuItem.getName());
        query.setParameter("sku", (Object)menuItem.getSku());
        query.setParameter("barCode", (Object)menuItem.getBarcode());
        query.setParameter("menuItemId", (Object)menuItem.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<MenuItem> items) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItem menuItem : items) {
                menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
                session.merge((Object)menuItem);
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveInventoryStockStatus(MenuItem menuItem, Session session) {
        if (!menuItem.isInventoryItem().booleanValue()) {
            return;
        }
        MenuItemInventoryStatus stockStatus = menuItem.getStockStatus();
        if (stockStatus == null) {
            stockStatus = new MenuItemInventoryStatus();
            menuItem.setStockStatus(stockStatus);
        }
        if (stockStatus.getId() == null) {
            stockStatus.setId(menuItem.getId());
            MenuItemInventoryStatusDAO.getInstance().save(stockStatus, session);
        }
    }

    @Override
    public void saveOrUpdate(MenuItem menuItem) throws HibernateException {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
            if (menuItem.getId() == null) {
                this.save(menuItem, session);
            } else {
                this.update(menuItem, session);
            }
            if (!menuItem.isInventoryItem().booleanValue()) {
                tx.commit();
                return;
            }
            MenuItemInventoryStatus stockStatus = menuItem.getStockStatus();
            if (stockStatus == null) {
                stockStatus = new MenuItemInventoryStatus();
                stockStatus.setId(menuItem.getId());
                menuItem.setStockStatus(stockStatus);
                MenuItemInventoryStatusDAO.getInstance().save(stockStatus, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeUnits(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            if (!Hibernate.isInitialized(menuItem.getStockUnits())) {
                Hibernate.initialize(menuItem.getStockUnits());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String searchString) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(String searchString, BeanTableModel<MenuItem> listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName, Object selectedType, boolean variant) {
        return this.rowCount(menuItem, menuGroup, itemName, selectedType, variant, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName, Object selectedType, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem loadInitialized(String menuItemId) throws HibernateException {
        MenuItem menuItem = super.get(menuItemId);
        this.initialize(menuItem);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getInitialized(String menuItemId) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            MenuItem menuItem = this.get(menuItemId, session);
            this.initialize(menuItem, session);
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            this.initialize(menuItem, session);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeVariants(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.update((Object)menuItem);
            Hibernate.initialize(menuItem.getVariants());
            Hibernate.initialize(menuItem.getAttributes());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuItem menuItem, Session session) {
        List<MenuItemModifierSpec> modiferSpecs;
        Hibernate.initialize(menuItem.getStockUnits());
        Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
        Hibernate.initialize(menuItem.getPizzaPriceList());
        Hibernate.initialize(menuItem.getDiscounts());
        Hibernate.initialize(menuItem.getComboGroups());
        Hibernate.initialize(menuItem.getComboItems());
        Hibernate.initialize(menuItem.getVariants());
        List<MenuItem> variants = menuItem.getVariants();
        if (variants != null) {
            for (MenuItem menuItem2 : variants) {
                Hibernate.initialize(menuItem2.getAttributes());
            }
        }
        if ((modiferSpecs = menuItem.getMenuItemModiferSpecs()) != null) {
            for (MenuItemModifierSpec modifierSpec : modiferSpecs) {
                Hibernate.initialize(modifierSpec.getDefaultModifierList());
                Hibernate.initialize(modifierSpec.getModifierPages());
            }
        }
    }

    public List<MenuItem> findByParent(Terminal terminal, MenuGroup menuGroup, boolean includeInvisibleItems) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuItem> getVariants(MenuItem parentItem) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (parentItem != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PARENT_MENU_ITEM_ID, (Object)parentItem.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            this.addOrderTypeFilter(selectedOrderType, session, criteria);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType, boolean includeInvisibleItems, PaginatedListModel listModel, boolean variant) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            this.addOrderTypeFilter(selectedOrderType, session, criteria);
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItemModifierSpec> findModifierGroups(MenuItem item) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)item.getId()));
            MenuItem newItem = (MenuItem)criteria.uniqueResult();
            Hibernate.initialize(newItem.getMenuItemModiferSpecs());
            List<MenuItemModifierSpec> list = newItem.getMenuItemModiferSpecs();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String itemName, MenuGroup menuGroup, Object selectedType, String type) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (type.equals("InventoryItem")) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems(String itemName, MenuGroup menuGroup, Object selectedType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseParent(List<MenuItem> menuItemList) {
    }

    public void releaseParentAndDelete(MenuItem item) {
        if (item == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            String queryStringForDiscount = "delete from MENUITEM_DISCOUNT where MENUITEM_ID='%s'";
            queryStringForDiscount = String.format(queryStringForDiscount, item.getId());
            SQLQuery query = session.createSQLQuery(queryStringForDiscount);
            query.executeUpdate();
            String queryString = "delete from MENU_PAGE_ITEM where MENU_ITEM_ID='%s'";
            queryString = String.format(queryString, item.getId());
            SQLQuery queryForPageItem = session.createSQLQuery(queryString);
            queryForPageItem.executeUpdate();
            String queryStringReleaseRecipe = "delete from RECIPE_TABLE where MENU_ITEM_ID='%s'";
            queryStringReleaseRecipe = String.format(queryStringReleaseRecipe, item.getId());
            SQLQuery queryReleaseRecipe = session.createSQLQuery(queryStringReleaseRecipe);
            queryReleaseRecipe.executeUpdate();
            session.delete((Object)item);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getMenuItemByBarcodeOrSKU(String barcode) {
        MenuItem menuItem = this.getMenuItemByBarcode(barcode);
        if (menuItem == null) {
            menuItem = this.getMenuItemBySKU(barcode);
        }
        return menuItem;
    }

    public MenuItem getMenuItemByBarcode(String barcode) {
        return this.getMenuItemByBarcode(barcode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcode(String barcode, boolean showVisibleItems) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (showVisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showVisibleItems));
            }
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)barcode));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemBySKU(String skuNo) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)skuNo));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemByName(String itemName) {
        return this.getMenuItemByName(itemName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemByName(String itemName, boolean showVisibleItems) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (showVisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showVisibleItems));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String itemName) {
        return this.getMenuItemsByName(menuGroup, itemName, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if ((result = criteria.list()) == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuCategory menuCategory, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if ((result = criteria.list()) == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String itemName, boolean hideInvisibleItems) {
        return this.getMenuItemsByName(orderType, menuCategory, menuGroup, itemName, hideInvisibleItems, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        if (menuGroup != null) {
            return this.getMenuItemsByName(menuGroup, itemName, hideInvisibleItems, includeVariantParent);
        }
        if (menuCategory != null) {
            return this.getMenuItemsByName(menuCategory, itemName, hideInvisibleItems, includeVariantParent);
        }
        List<MenuCategory> activeCategories = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
        ArrayList<String> catIdList = new ArrayList<String>();
        for (MenuCategory menuCategory2 : activeCategories) {
            catIdList.add(menuCategory2.getId());
        }
        if (catIdList == null || catIdList.isEmpty()) {
            return null;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, catIdList));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String sku, String name, String barcode, ReportGroup reportGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)barcode)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
            }
            if (StringUtils.isNotEmpty((String)sku)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)name, (MatchMode)MatchMode.START));
            }
            if (reportGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_REPORT_GROUP_ID, (Object)reportGroup.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItemsForStockCount(String searchString, MenuGroup group, InventoryVendor vendor, InventoryLocation location) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            List commonMenuItemsId = null;
            if (vendor != null) {
                criteria = session.createCriteria(InventoryVendorItems.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
                criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
                criteria.setProjection((Projection)Projections.property((String)"item.id"));
                commonMenuItemsId = criteria.list();
            }
            if (location != null) {
                criteria = session.createCriteria(InventoryStock.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
                criteria.setProjection((Projection)Projections.property((String)InventoryStock.PROP_MENU_ITEM_ID));
                if (commonMenuItemsId == null) {
                    commonMenuItemsId = criteria.list();
                } else {
                    commonMenuItemsId.retainAll(criteria.list());
                }
            }
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)searchString), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)searchString), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START))));
            }
            if (group != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)group.getId()));
            }
            if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)commonMenuItemsId));
            }
            criteria.setMaxResults(200);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            List list = result = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)false), (Criterion)Restrictions.isNull((String)MenuItem.PROP_PIZZA_TYPE)));
            List list = result = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getInventortItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = result = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getReplenishedMenuItem(Integer id, Session session) {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)id));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        Double reorderLevel = 0.0;
        if (menuItem != null) {
            reorderLevel = menuItem.getReorderLevel();
        }
        if (reorderLevel == 0.0) {
            return null;
        }
        criteria = session.createCriteria(MenuItemInventoryStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemInventoryStatus.PROP_ID, (Object)id));
        criteria.add((Criterion)Restrictions.lt((String)MenuItemInventoryStatus.PROP_AVAILABLE_UNIT, (Object)reorderLevel));
        MenuItemInventoryStatus inventoryStatus = (MenuItemInventoryStatus)criteria.uniqueResult();
        if (inventoryStatus == null) {
            return null;
        }
        menuItem.setStockStatus(inventoryStatus);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getReOrderedMenuItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "item");
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private DetachedCriteria getDetachedCriteriaForStockStatus(String propItemId) {
        DetachedCriteria stockStatusSubCriteria = DetachedCriteria.forClass(MenuItemInventoryStatus.class, (String)"status").setProjection((Projection)Projections.property((String)MenuItemInventoryStatus.PROP_ID)).add((Criterion)Restrictions.eqProperty((String)MenuItemInventoryStatus.PROP_ID, (String)propItemId)).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND)), (Criterion)Restrictions.leProperty((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND), (String)("item." + MenuItem.PROP_REORDER_LEVEL))));
        return stockStatusSubCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowReOrderedItemCount(MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.setProjection(Projections.rowCount());
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReorderedMenuItems(PaginationSupport model, MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String sku, String name, String barcode, MenuGroup menuGroup, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, sku, name, barcode, menuGroup);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, sku, name, barcode, menuGroup);
            if (pagination != null) {
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, String sku, String name, String barcode, MenuGroup menuGroup) {
        if (StringUtils.isNotEmpty((String)barcode)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
        }
        if (StringUtils.isNotEmpty((String)sku)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
        }
        if (StringUtils.isNotEmpty((String)name)) {
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)name, (MatchMode)MatchMode.ANYWHERE));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
    }

    public void loadMenuItems(PaginationSupport model, Boolean menuItem) {
        this.loadMenuItems(model, menuItem, null, null, null, false);
    }

    public void loadMenuItems(PaginationSupport model, Boolean menuItem, MenuGroup menuGroup, String itemName, MenuCategory selectedType, boolean variant) {
        this.loadMenuItems(model, menuItem, menuGroup, itemName, selectedType, variant, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem() {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            List list = result = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem(String nameOrSku, MenuGroup menuGroup, MenuCategory menuCategory) {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_MENU_GROUP_ID));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (StringUtils.isNotEmpty((String)nameOrSku)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)nameOrSku, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)nameOrSku)));
            }
            List list = result = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, Boolean menuItem, MenuGroup menuGroup, String itemName, MenuCategory menuCategory, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                Disjunction or = Restrictions.disjunction();
                or.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)or);
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void addOrderTypeFilter(Object selectedType, Session session, Criteria criteria) {
        if (selectedType instanceof OrderType) {
            OrderType orderType = (OrderType)selectedType;
            Criteria criteria2 = session.createCriteria(MenuCategory.class);
            criteria2.createAlias("orderTypes", "ot");
            criteria2.add(Restrictions.in((String)("ot." + OrderType.PROP_ID), Arrays.asList(orderType.getId())));
            List list = criteria2.list();
            if (list != null && !list.isEmpty()) {
                ArrayList<String> idList = new ArrayList<String>();
                for (MenuCategory object : list) {
                    idList.add(object.getId());
                }
                criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, idList));
            }
        }
    }

    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantItem, Boolean pizzaType, Boolean showInvisibleItems) {
        this.findByBarcodeOrName(paginationSupport, inventoryItemOnly, menuGroup, itemNameOrBarcode, includeVariantItem, pizzaType, showInvisibleItems, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantParent, Boolean pizzaType, Boolean showInvisibleItems, String ... fields) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            if (StringUtils.isNotEmpty((String)itemNameOrBarcode)) {
                Criterion name = Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Criterion barcode = Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Criterion sku = Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Disjunction or = Restrictions.or((Criterion[])new Criterion[]{name, barcode, sku});
                criteria.add((Criterion)or);
            }
            if (inventoryItemOnly.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!includeVariantParent.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)includeVariantParent));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (showInvisibleItems.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showInvisibleItems));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (fields != null && fields.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String field : fields) {
                    projectionList.add((Projection)Projections.property((String)field), field);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem findByName(String menuItemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)menuItemName));
            List result = criteria.list();
            if (result.size() == 0) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem findByBarcode(String barcode, Session session) {
        if (StringUtils.isEmpty((String)barcode)) {
            return null;
        }
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode.trim()));
        List list = criteria.list();
        if (list.size() > 0) {
            return (MenuItem)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(BeanTableModel model, Boolean menuItem, MenuGroup menuGroup, String itemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            String modelSortColumn;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)(modelSortColumn = model.getSortBy()))) {
                criteria.addOrder(model.isAscOrder() ? Order.asc((String)modelSortColumn) : Order.desc((String)modelSortColumn));
            } else {
                criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
                criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            }
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(PaginationSupport model, MenuGroup menuGroup, String itemName) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.START), Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.START)}));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllInventoryItems() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateStockQuantity(String menuItemId, double unitQuantity, boolean updateAvailableUnit, boolean updateOnHandUnit, Session session) {
        MenuItemInventoryStatus status = MenuItemInventoryStatusDAO.getInstance().get(menuItemId, session);
        if (status == null) {
            status = new MenuItemInventoryStatus();
            status.setId(menuItemId);
        }
        if (updateAvailableUnit) {
            status.setAvailableUnit(status.getAvailableUnit() + unitQuantity);
        }
        if (updateOnHandUnit) {
            status.setUnitOnHand(status.getUnitOnHand() + unitQuantity);
        }
        MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(status, session);
    }

    public void updateStockQuantity(String menuItemId, double unitQuantity, double unitCost, boolean updateAvailableUnit, boolean updateOnHandUnit, Session session) {
        String sql = null;
        sql = updateAvailableUnit && updateOnHandUnit ? String.format("update MenuItem set availableUnit = (availableUnit + %s),unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", unitQuantity, unitQuantity, unitCost, menuItemId) : (updateOnHandUnit ? String.format("update MenuItem set unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", unitQuantity, unitCost, menuItemId) : String.format("update MenuItem set availableUnit = (availableUnit + %s),cost = %s where id = '%s'", unitQuantity, unitCost, menuItemId));
        session.createQuery(sql).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuItem(MenuGroup menuGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateLastPurchaseCost(String menuItemId, double cost, boolean updateLastPurchasePrice, Session session) {
        String sql = null;
        double avgCost = InventoryTransactionDAO.getInstance().findItemAvgCost(menuItemId, session);
        double actualCost = updateLastPurchasePrice ? cost : avgCost;
        actualCost = NumberUtil.roundToTwoDigit(actualCost);
        sql = String.format("update MenuItem set lastPurchasedCost = %s,avgCost=%s, cost = %s where id = '%s'", cost, avgCost, actualCost, menuItemId);
        session.createQuery(sql).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastPurchaseCost(PurchaseOrder order, boolean updateLastPurchasePrice) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<PurchaseOrderItem> orderItems = order.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : orderItems) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                double baseUnitQuantity = menuItem.getBaseUnitQuantity(purchaseOrderItem.getItemUnitName());
                double unitPrice = NumberUtil.roundToTwoDigit(purchaseOrderItem.getUnitPrice() / baseUnitQuantity);
                this.updateLastPurchaseCost(menuItem.getId(), unitPrice, updateLastPurchasePrice, session);
            }
            session.saveOrUpdate((Object)order);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemWithFields(String menuItemId, String ... fields) throws Exception {
        Session session = null;
        try {
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemWithFields(session, menuItemId, fields);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public MenuItem getMenuItemWithFields(Session session, String menuItemId, String ... fields) throws Exception {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItemId));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_ID), MenuItem.PROP_ID);
        for (String field : fields) {
            projectionList.add((Projection)Projections.property((String)field), field);
        }
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        if (menuItem != null) {
            Hibernate.initialize(menuItem.getStockUnits());
        }
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, String searchItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotEmpty((String)searchItem)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchItem.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)false));
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuItems(List<MenuItem> dataList, Session session) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (MenuItem item : dataList) {
                this.saveOrUpdateMenuItem(session, item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    private void saveOrUpdateMenuItem(Session session, MenuItem item) throws Exception {
        MenuItem existingItem = this.get(item.getId());
        if (existingItem != null) {
            String id = existingItem.getId();
            long version = existingItem.getVersion();
            PropertyUtils.copyProperties((Object)existingItem, (Object)item);
            existingItem.setId(id);
            existingItem.setVersion(version);
            this.update(existingItem, session);
        } else {
            this.save(item, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllUnSyncMenuItems() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)MenuItem.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)MenuItem.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateMenuItemSync(List<String> ids, Boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update MenuItem set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, MenuItem.PROP_CLOUD_SYNCED, MenuItem.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

