/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.BaseMenuPageItemDAO;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class MenuPageItemDAO
extends BaseMenuPageItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuPageItem> getPageItems(MenuPage menuPage) {
        Session session = null;
        if (menuPage == null) {
            return null;
        }
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (menuPage != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPageItem.PROP_MENU_PAGE_ID, (Object)menuPage.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuPageItem> getPageItemFor(MenuItem menuItem) {
        Session session = null;
        try {
            session = this.createNewSession();
            List<MenuPageItem> list = this.getPageItemFor(menuItem, session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuPageItem> getPageItemFor(MenuItem menuItem, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)MenuPageItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsForGroup(MenuGroup menuGroup) {
        Session session = null;
        try {
            session = this.getSession();
            List menuGroupIds = null;
            Criteria criteria = session.createCriteria(MenuGroup.class);
            if (menuGroup.getId() == null) {
                criteria.setProjection((Projection)Projections.property((String)MenuGroup.PROP_ID));
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuGroup.getMenuCategoryId()));
                menuGroupIds = criteria.list();
                if (menuGroupIds == null || menuGroupIds.isEmpty()) {
                    List<MenuItem> list = null;
                    return list;
                }
            }
            criteria = session.createCriteria(MenuPage.class);
            criteria.setProjection((Projection)Projections.property((String)MenuPage.PROP_ID));
            criteria.add((Criterion)(menuGroupIds != null ? Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, (Collection)menuGroupIds) : Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId())));
            List menuPageIds = criteria.list();
            if (menuPageIds == null || menuPageIds.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            criteria = session.createCriteria(MenuPageItem.class);
            criteria.setProjection((Projection)Projections.property((String)MenuPageItem.PROP_MENU_ITEM_ID));
            criteria.add(Restrictions.in((String)MenuPageItem.PROP_MENU_PAGE_ID, (Collection)menuPageIds));
            List<MenuItem> list = this.getItemWithNameAndPrice(criteria.list(), session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    private List<MenuItem> getItemWithNameAndPrice(List menuItemIds, Session session) {
        if (menuItemIds == null || menuItemIds.isEmpty()) {
            return null;
        }
        Criteria criteria = session.createCriteria(MenuItem.class);
        ProjectionList projections = Projections.projectionList();
        projections.add((Projection)Projections.property((String)MenuItem.PROP_ID), MenuItem.PROP_ID);
        projections.add((Projection)Projections.property((String)MenuItem.PROP_NAME), MenuItem.PROP_NAME);
        projections.add((Projection)Projections.property((String)MenuItem.PROP_PRICE), MenuItem.PROP_PRICE);
        projections.add((Projection)Projections.property((String)MenuItem.PROP_IMAGE_ID), MenuItem.PROP_IMAGE_ID);
        projections.add((Projection)Projections.property((String)MenuItem.PROP_PROPERTIES_JSON), MenuItem.PROP_PROPERTIES_JSON);
        criteria.setProjection((Projection)projections);
        criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)menuItemIds));
        criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
        criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
        return criteria.list();
    }
}

