/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.BaseMultiplierDAO;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MultiplierDAO
extends BaseMultiplierDAO {
    @Override
    public List<Multiplier> findAll() {
        try {
            Session session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)Multiplier.PROP_SORT_ORDER));
            return criteria.list();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateMultipliers(List<Multiplier> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Multiplier multiplier : items) {
                session.saveOrUpdate((Object)multiplier);
            }
            tx.commit();
        }
    }

    public Multiplier getDefaultMutltiplier() {
        try {
            Session session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_DEFAULT_MULTIPLIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                return (Multiplier)list.get(0);
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_ID, (Object)name).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMultiplier(Multiplier multiplier) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            String sqlDeleteItem = "delete from MODIFIER_MULTIPLIER_PRICE where MULTIPLIER_ID='%s'";
            sqlDeleteItem = String.format(sqlDeleteItem, multiplier.getId());
            SQLQuery query = session.createSQLQuery(sqlDeleteItem);
            query.executeUpdate();
            session.delete((Object)multiplier);
            tx.commit();
        }
    }
}

