/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.BaseOrderTypeDAO;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.sql.JoinType;

public class OrderTypeDAO
extends BaseOrderTypeDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderType> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)OrderType.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderType> findEnabledOrderTypesForTerminal(Terminal terminal) {
        List list;
        Session session = null;
        try {
            TerminalType terminalType = terminal.getTerminalType();
            Department department = terminal.getDepartment();
            SalesArea salesArea = terminal.getSalesArea();
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            if (terminalType != null) {
                criteria.createAlias("c.terminalTypes", "terminalType", JoinType.LEFT_OUTER_JOIN);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.terminalTypes"), (Criterion)Restrictions.in((String)"terminalType.id", Arrays.asList(terminalType.getId()))));
            }
            if (department != null) {
                criteria.createAlias("c.departments", "department", JoinType.LEFT_OUTER_JOIN);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.departments"), (Criterion)Restrictions.in((String)"department.id", Arrays.asList(department.getId()))));
            }
            if (salesArea != null) {
                criteria.add(Restrictions.eqOrIsNull((String)OrderType.PROP_SALES_AREA_ID, (Object)salesArea.getId()));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            list = criteria.list();
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderType> findLoginScreenViewOrderTypes() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_SHOW_IN_LOGIN_SCREEN, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType findByName(String orderType) {
        Session session = null;
        try {
            session = this.createNewSession();
            OrderType orderType2 = this.findByName(orderType, session);
            return orderType2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public OrderType findByName(String orderType, Session session) {
        if (session == null) {
            session = this.getSession();
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_NAME, (Object)orderType));
        return (OrderType)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOrderTypeObj() {
        Session session = null;
        try {
            session = this.createNewSession();
            SQLQuery query = session.createSQLQuery("select count(s.MENU_ITEM_ID), count(s.ORDER_TYPE_ID) from ITEM_ORDER_TYPE s");
            List result = query.list();
            Object[] object = (Object[])result.get(0);
            Integer menuItemCount = this.getInt(object, 0);
            Integer orderTypeCount = this.getInt(object, 1);
            if (menuItemCount < 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = orderTypeCount > 0;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMenuItemOrderType() {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            SQLQuery query = session.createSQLQuery("Update ITEM_ORDER_TYPE t SET t.ORDER_TYPE_ID=(Select o.id from ORDER_TYPE o where o.NAME=t.ORDER_TYPE)");
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private Integer getInt(Object[] array, int index) {
        if (array.length < index + 1) {
            return null;
        }
        if (array[index] instanceof Number) {
            return ((Number)array[index]).intValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getFirstOrderType() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(0);
            criteria.setMaxResults(1);
            List result = criteria.list();
            if (result.size() > 0) {
                OrderType orderType = (OrderType)result.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getOrderType(boolean dineIn) {
        Session session = null;
        Criteria criteria = null;
        try {
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_SHOW_TABLE_SELECTION, (Object)dineIn));
            if (!dineIn) {
                criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_DELIVERY, (Object)Boolean.FALSE));
            }
            if ((result = criteria.list()).size() > 0) {
                OrderType orderType = (OrderType)result.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getHomeDeliveryOrderType() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_DELIVERY, (Object)Boolean.TRUE));
            List result = criteria.list();
            if (result.size() > 0) {
                OrderType orderType = (OrderType)result.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOrderType(OrderType ordersType, List<Department> checkedValues) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)ordersType);
            for (Department object : checkedValues) {
                session.saveOrUpdate((Object)object);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType initialize(OrderType orderType) {
        if (orderType == null || orderType.getId() == null) {
            return orderType;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)orderType);
            Hibernate.initialize(orderType.getDepartments());
            Hibernate.initialize(orderType.getTerminalTypes());
            Hibernate.initialize(orderType.getCategories());
            OrderType orderType2 = orderType;
            return orderType2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderType> findAllUnSyncOrderType() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)OrderType.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)OrderType.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateOrderTypeSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update OrderType set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, OrderType.PROP_CLOUD_SYNCED, OrderType.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOrderTypes(List<OrderType> orderTypes) throws Exception {
        if (orderTypes == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (OrderType orderType : orderTypes) {
                OrderType existingOrderType = this.get(orderType.getId());
                if (existingOrderType != null) {
                    String id = existingOrderType.getId();
                    long version = existingOrderType.getVersion();
                    PropertyUtils.copyProperties((Object)existingOrderType, (Object)orderType);
                    existingOrderType.setId(id);
                    existingOrderType.setVersion(version);
                    this.update(existingOrderType, session);
                    continue;
                }
                orderType.setVersion(0L);
                this.save(orderType, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

