/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BasePosTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.HibernateProjectionsUtil;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionSummary;
import com.floreantpos.report.CustomerPaymentReportView;
import com.floreantpos.services.PosTransactionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PosTransactionDAO
extends BasePosTransactionDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId())) {
            transaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId())) {
            transaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId())) {
            transaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.saveOrUpdate(obj, s);
    }

    public List<PosTransaction> findUnauthorizedTransactions() {
        return this.findUnauthorizedTransactions(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findUnauthorizedTransactions(User owner) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasUnauthorizedTransactions(User owner) {
        Session session = null;
        try {
            Number rowCount;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            Boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class transactionClass, Date from, Date to) {
        return this.findTransactions(terminal, transactionClass, from, to, true);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class transactionClass, Date from, Date to, boolean excludeNullTicket) {
        return this.findTransactions(terminal, null, transactionClass, from, to, excludeNullTicket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class transactionClass, Date from, Date to, boolean excludeNullTicket) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(transactionClass);
            if (excludeNullTicket) {
                criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (outlet != null) {
                // empty if block
            }
            if (from != null && to != null) {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from, (Object)to));
            }
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_TYPE), PosTransaction.PROP_CARD_TYPE);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_READER), PosTransaction.PROP_CARD_READER);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_AUTH_CODE), PosTransaction.PROP_CARD_AUTH_CODE);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), PosTransaction.PROP_TIPS_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TERMINAL_ID), PosTransaction.PROP_TERMINAL_ID);
            pList.add((Projection)Projections.property((String)CustomerAccountTransaction.PROP_CUSTOMER_ID), CustomerAccountTransaction.PROP_CUSTOMER_ID);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSummary getTransactionSummary(Terminal terminal, Class transactionClass, Date from, Date to) {
        Session session = null;
        TransactionSummary summary = new TransactionSummary();
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(transactionClass);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (from != null && to != null) {
                criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from));
                criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)to));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.count((String)PosTransaction.PROP_ID));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                TransactionSummary transactionSummary = summary;
                return transactionSummary;
            }
            Object[] o = (Object[])list.get(0);
            int index = 0;
            summary.setCount(HibernateProjectionsUtil.getInt(o, index++));
            summary.setAmount(HibernateProjectionsUtil.getDouble(o, index++));
            summary.setTipsAmount(HibernateProjectionsUtil.getDouble(o, index++));
            TransactionSummary transactionSummary = summary;
            return transactionSummary;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionListByGiftCardNumber(String giftCardNumber, Date fromDate, Date toDate) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(fromDate), (Object)DateUtil.endOfDay(toDate)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_GIFT_CERT_NUMBER, (Object)giftCardNumber));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findCapturedTransactions(User owner) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date startOfDay = DateUtil.startOfDay(calendar.getTime());
            Date endOfDay = DateUtil.endOfDay(new Date());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)startOfDay, (Object)endOfDay));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getStoreSessionTransactions(StoreSession storeOperationData) {
        List<String> cashDrawerIds;
        Session session;
        block3: {
            List<PosTransaction> list;
            session = null;
            try {
                cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
                if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block3;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        criteria.add((Criterion)Restrictions.eq((String)"ticket.closed", (Object)true));
        criteria.add((Criterion)Restrictions.eq((String)"ticket.voided", (Object)false));
        criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
        List list = criteria.list();
        this.closeSession(session);
        return list;
    }

    public void saveReversalTransaction(Ticket ticket, PosTransaction transaction, ReversalTransaction reversalTransaction) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.delete(transaction, session);
            this.saveOrUpdate(reversalTransaction, session);
            TicketDAO.getInstance().update(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception x) {
                PosLog.error(PosTransactionService.class, x);
                x.printStackTrace();
            }
            throw e;
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findCreditTransactions(Date fromDate, Date toDate, User user) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            this.addMultiUserFilter(user, criteria);
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getCloudStoreSessionTransactions(StoreSession storeOperationData) {
        List<String> cashDrawerIds;
        Session session;
        block3: {
            List<PosTransaction> list;
            session = null;
            try {
                cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
                if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block3;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
        criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
        List list = criteria.list();
        this.closeSession(session);
        return list;
    }

    private void addMultiUserFilter(User user, Criteria criteria) {
        if (user != null) {
            PosLog.info(this.getClass(), "setting multi user filter for root user '" + user.getFullName() + "', id: " + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
            List<User> linkedUsers = user.getLinkedUser();
            if (linkedUsers != null) {
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), "linked user '" + linkedUser.getFullName() + "', id: " + linkedUser.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)linkedUser.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CustomerPaymentReportView.CustomerAccountTransactionItem> findCustomerAccountTransactions(Date fromDate, Date toDate, Customer customer) {
        Session session = null;
        try {
            session = this.getSession();
            String hql = "select t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, c.%s from PosTransaction as t, Customer as c where t.%s=c.%s ";
            hql = String.format(hql, PosTransaction.PROP_ID, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_TIPS_AMOUNT, PosTransaction.PROP_AMOUNT, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_NAME, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_ID);
            if (customer != null) {
                hql = hql + "and c.id= '" + customer.getId() + "'";
            }
            Query query = session.createQuery(hql);
            List list = query.list();
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> items = new ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem>();
            for (Object[] object : list) {
                CustomerPaymentReportView.CustomerAccountTransactionItem accountTransactionItem = new CustomerPaymentReportView.CustomerAccountTransactionItem();
                accountTransactionItem.setTransactionNo(String.valueOf(object[0]));
                Ticket ticket = (Ticket)object[1];
                accountTransactionItem.setTicketNo(ticket.getId());
                accountTransactionItem.setDate((Date)object[2]);
                accountTransactionItem.setTips((double)((Double)object[3]));
                accountTransactionItem.setTotalAmount((double)((Double)object[4]));
                accountTransactionItem.setCustomerId(String.valueOf(object[5]));
                accountTransactionItem.setCustomerName(String.valueOf(object[6]));
                items.add(accountTransactionItem);
            }
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList = items;
            return arrayList;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForCashDrawer(String cashDrawerId, boolean voided) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)cashDrawerId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)voided));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForServer(String storeSessionId, String serverId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)serverId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)storeSessionId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findTransactionsForSession(String storeSessionId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)storeSessionId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLastTxPaymentTypeName(Ticket ticket) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TICKET, (Object)ticket));
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_TRANSACTION_TIME));
            criteria.setMaxResults(1);
            criteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            String paymentTypeString = (String)criteria.uniqueResult();
            if (StringUtils.isNotEmpty((String)paymentTypeString)) {
                String string = PaymentType.valueOf(paymentTypeString).getDisplayString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getTransactionsByOutlet(Date from, Date to, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, from, to, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, from, to, outlet);
            if (pagination != null) {
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date from, Date to, Outlet outlet) {
        if (from != null && to != null) {
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from, (Object)to));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> getUnSyncTransactionsByStoreSession(StoreSession storeOperationData) {
        List<String> cashDrawerIds;
        Session session;
        block3: {
            List<PosTransaction> list;
            session = null;
            try {
                cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
                if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block3;
                list = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CLOUD_SYNCED, (Object)false));
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        criteria.add((Criterion)Restrictions.eq((String)"ticket.closed", (Object)true));
        criteria.add((Criterion)Restrictions.eq((String)"ticket.voided", (Object)false));
        criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
        List list = criteria.list();
        this.closeSession(session);
        return list;
    }

    public void updatePosTransSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update PosTransaction set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, PosTransaction.PROP_CLOUD_SYNCED, PosTransaction.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePosTransactions(List<PosTransaction> posTransactions) {
        if (posTransactions == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (PosTransaction item : posTransactions) {
                PosTransaction existPosTransaction = this.get(item.getId());
                PaymentType paymentType = item.getPaymentType();
                if (existPosTransaction == null) {
                    item.setVersion(0L);
                    existPosTransaction = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)existPosTransaction, (Object)item);
                    this.save(existPosTransaction, session);
                    continue;
                }
                item.setVersion(existPosTransaction.getVersion());
                PropertyUtils.copyProperties((Object)existPosTransaction, (Object)item);
                this.update(existPosTransaction, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            PosLog.error(this.getClass(), e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

