/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PurchaseOrderItemDAO
extends BasePurchaseOrderItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(InventoryVendor vendor) {
        ArrayList<MenuItem> arrayList;
        Session session = null;
        Criteria criteria = null;
        try {
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            session = this.getSession();
            criteria = session.createCriteria(PurchaseOrderItem.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)PurchaseOrderItem.PROP_MENU_ITEM_ID)));
            criteria.createAlias(PurchaseOrderItem.PROP_PURCHASE_ORDER, "p");
            criteria.add((Criterion)Restrictions.eq((String)"p.vendor", (Object)vendor));
            List list = criteria.list();
            if (list != null) {
                for (Integer item : list) {
                    MenuItem menuItem = MenuItemDAO.getInstance().getReplenishedMenuItem(item, session);
                    if (menuItem == null) continue;
                    menuItems.add(menuItem);
                }
            }
            arrayList = menuItems;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return arrayList;
    }

    public void loadCustomers(PurchaseOrderItem purchaseOrderItem) {
        if (purchaseOrderItem == null || purchaseOrderItem.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(purchaseOrderItem.getCustomers())) {
            return;
        }
        Session session = this.createNewSession();
        try {
            session.refresh((Object)purchaseOrderItem);
            Hibernate.initialize(purchaseOrderItem.getCustomers());
        }
        finally {
            this.closeSession(session);
        }
    }
}

