/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TicketDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ShopTableDAO
extends BaseShopTableDAO {
    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)ShopTable.PROP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextTableNumber() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)ShopTable.PROP_ID));
            int n = ((Number)criteria.uniqueResult()).intValue();
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable getByNumber(int tableNumber) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)tableNumber));
            ShopTable shopTable = (ShopTable)criteria.uniqueResult();
            return shopTable;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByFloor(ShopFloor shopFloor) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_FLOOR_ID, (Object)shopFloor.getId()));
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getAllUnassigned() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)ShopTable.PROP_FLOOR_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByNumbers(Collection<Integer> tableNumbers) {
        if (tableNumbers == null || tableNumbers.size() == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            for (Integer tableNumber : tableNumbers) {
                disjunction.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)tableNumber));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTable> getTables(Ticket ticket) {
        return this.getByNumbers(ticket.getTableNumbers());
    }

    public void bookedTables(List<ShopTableStatus> tables) {
        if (tables == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : tables) {
                shopTableStatus.setTableStatus(TableStatus.Booked);
                session.saveOrUpdate((Object)shopTableStatus);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.occupyTables(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket, Session session) {
        List<Integer> tableNumbers = ticket.getTableNumbers();
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        ticketNumbers.add(ticket.getId());
        User owner = ticket.getOwner();
        for (Integer tableId : tableNumbers) {
            ShopTableStatus shopTableStatus = ShopTableStatusDAO.getInstance().get(tableId, session);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(tableId);
            }
            shopTableStatus.setTableTicket(ticket.getId(), ticket.getTokenNo(), owner.getId(), owner.getFirstName());
            shopTableStatus.setTableStatus(TableStatus.Seat);
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
        }
    }

    public void freeTables(List<ShopTableStatus> tableStatusList) {
        if (tableStatusList == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : tableStatusList) {
                shopTableStatus.setTableStatus(TableStatus.Available);
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTablesByNumbers(List<Integer> tableNumbers) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.freeTables(tableNumbers, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTables(List<Integer> tableNumbers, Session session) {
        for (Integer tableId : tableNumbers) {
            ShopTableStatus shopTableStatus = (ShopTableStatus)session.get(ShopTableStatus.class, (Serializable)tableId);
            shopTableStatus.setTicketId(null);
            shopTableStatus.setTableStatus(TableStatus.Available);
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void releaseTables(Ticket ticket) {
        List<ShopTable> tables = this.getTables(ticket);
        if (tables == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : tables) {
                shopTable.setTableStatus(TableStatus.Available);
                this.saveOrUpdate(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseAndDeleteTicketTables(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.releaseTables(ticket);
            ticket.setTableNumbers(null);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTables(Collection<ShopTable> tables) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : tables) {
                super.delete(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTableType> getTableByTypes(List<ShopTableType> types) {
        ArrayList<String> typeIds = new ArrayList<String>();
        for (ShopTableType shopTableType : types) {
            typeIds.add(shopTableType.getId());
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(ShopTable.class);
        criteria.createAlias("types", "t");
        criteria.add(Restrictions.in((String)"t.id", typeIds));
        criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
        return criteria.list();
    }

    public void createNewTables(int totalNumberOfTableHaveToCreate) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (int i = 0; i < totalNumberOfTableHaveToCreate; ++i) {
                ShopTable table = new ShopTable();
                table.setId(i + 1);
                table.setCapacity(4);
                super.save(table, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableStatus(List tableNumbers, Integer status, Ticket ticket, boolean saveTicket) {
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.updateTableStatus((List<Integer>)tableNumbers, status, ticket, session);
            if (saveTicket) {
                session.saveOrUpdate((Object)ticket);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableStatus(List<Integer> tableNumbers, Integer status, Ticket ticket, Session session) {
        String ticketId = null;
        ArrayList<String> tickets = new ArrayList<String>();
        String userId = null;
        String userName = null;
        if (ticket != null) {
            ticketId = ticket.getId();
            userId = ticket.getOwner().getId();
            userName = ticket.getOwner().getFirstName();
            tickets.add(ticket.getId());
        }
        for (Integer integer : tableNumbers) {
            ShopTableStatus tableStatus = ShopTableStatusDAO.getInstance().get(integer, session);
            if (tableStatus == null) continue;
            if (ticket != null) {
                tableStatus.setTableTicket(ticketId, ticket.getTokenNo(), userId, userName);
            } else {
                tableStatus.setTicketId(null);
            }
            session.saveOrUpdate((Object)tableStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findBy(String searchSubject) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isEmpty((String)searchSubject)) {
                List<ShopTable> list2 = null;
                return list2;
            }
            if (StringUtils.isNumeric((String)searchSubject)) {
                criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_CAPACITY, (Object)Integer.valueOf(searchSubject)));
            }
            if ((list = criteria.list()) != null || list.size() > 0) {
                List list3 = list;
                return list3;
            }
            List<ShopTable> list4 = null;
            return list4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames(List tableNumbers) {
        Session session = null;
        try {
            session = this.createNewSession();
            String queryString = String.format("select %s, %s from %s table where ", ShopTable.PROP_ID, ShopTable.PROP_NAME, ShopTable.class.getSimpleName());
            Query query = session.createQuery(queryString + "table.id IN (:tableNumbers)");
            query.setParameterList("tableNumbers", (Collection)tableNumbers);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                List<String> list2 = null;
                return list2;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Object[] obj = (Object[])list.get(i);
                if (obj[1] != null) {
                    names.add((String)obj[1]);
                    continue;
                }
                names.add(String.valueOf(obj[0]));
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (Exception e) {
            PosLog.error(ShopTableDAO.class, e.getMessage(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable loadWithSeats(Integer tableId) {
        if (tableId == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            ShopTable shopTable = this.get(tableId, session);
            Hibernate.initialize(shopTable.getSeats());
            Set<ShopSeat> seats = shopTable.getSeats();
            for (ShopSeat shopSeat : seats) {
                shopSeat.setShopTable(shopTable);
            }
            ShopTable shopTable2 = shopTable;
            return shopTable2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeSeats(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getSeats())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getSeats());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTablesSeats(List<ShopTable> tables) {
        Session session = null;
        try {
            session = this.createNewSession();
            for (ShopTable table : tables) {
                session.refresh((Object)table);
                Hibernate.initialize(table.getSeats());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void detachFloor(List<ShopTable> selectedTables) {
        if (selectedTables == null || selectedTables.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : selectedTables) {
                shopTable.setFloorId(null);
                this.saveOrUpdate(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findAllWithTypes() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            List list = criteria.list();
            for (ShopTable shopTable : list) {
                Hibernate.initialize(shopTable.getTypes());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeTypes(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getTypes())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getTypes());
        }
        finally {
            this.closeSession(session);
        }
    }
}

