/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.BaseStoreSessionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.swing.PaginationSupport;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionDAO
extends BaseStoreSessionDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStoreSession(PaginationSupport model) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(StoreSession.class);
            criteria.addOrder(Order.asc((String)StoreSession.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)endDate)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME), (Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)endDate))));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Outlet outlet, Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)endDate)));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            List openTimeList = criteria.list();
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)endDate)));
            List closeTimeList = criteria.list();
            if (!closeTimeList.isEmpty()) {
                for (StoreSession storeSession : closeTimeList) {
                    if (openTimeList.contains(storeSession)) continue;
                    openTimeList.add(storeSession);
                }
            }
            List list = openTimeList;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreSession findOpenSession(Outlet outlet) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            List openSessions = criteria.list();
            if (openSessions != null) {
                StoreSession storeSession = (StoreSession)openSessions.get(0);
                return storeSession;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getStoreSessionTotalGuest(StoreSession storeOperationData) {
        Session session;
        block5: {
            List<String> cashDrawerIds;
            block4: {
                Integer n;
                session = null;
                try {
                    cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
                    if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block4;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
                this.closeSession(session);
                return n;
            }
            session = this.getSession();
            Criteria criteria = session.createCriteria(PosTransaction.class, "t");
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
            criteria.setProjection((Projection)Projections.sum((String)"ticket.numberOfGuests"));
            Long guestNumber = (Long)criteria.uniqueResult();
            if (guestNumber == null) break block5;
            Integer n = guestNumber.intValue();
            this.closeSession(session);
            return n;
        }
        Integer n = 0;
        this.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> getTransactionsByOutlet(Date from, Date to, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, from, to, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, from, to, outlet);
            if (pagination != null) {
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date from, Date to, Outlet outlet) {
        if (from != null) {
            criteria.add((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)from));
        }
        if (to != null) {
            criteria.add((Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)to));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void saveOrUpdateStoreSessions(List<StoreSession> dataList) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (StoreSession item : dataList) {
                StoreSession existingItem = this.get(item.getId());
                String colseByUserId = item.getClosedByUserId();
                if (existingItem != null) {
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    if (colseByUserId != null) {
                        existingItem.setClosedByUserId(colseByUserId);
                    }
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    this.update(existingItem, session);
                    continue;
                }
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

