/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseTerminalDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TerminalDAO
extends BaseTerminalDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDrawerAssigned(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminal.getId()));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ASSIGNED_USER_ID));
            Object result = criteria.uniqueResult();
            boolean bl = result != null;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Integer createNewTerminalId() {
        Session session = null;
        try {
            session = this.getSession();
            Integer n = this.createNewTerminalId(session);
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Integer createNewTerminalId(Session session) {
        Integer terminalId;
        Criteria criteria;
        Object uniqueResult;
        Random random = new Random();
        do {
            terminalId = random.nextInt(10000) + 1;
            criteria = session.createCriteria(this.getClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminalId));
        } while ((uniqueResult = criteria.uniqueResult()) != null);
        return terminalId;
    }

    public Terminal createNewTerminal(String terminalKey, Integer terminalId, Outlet outlet) {
        return this.createNewTerminal(terminalKey, terminalId, outlet, null);
    }

    public Terminal createNewTerminal(String terminalKey, Integer terminalId, Outlet outlet, Session session) {
        if (terminalId == null || terminalId == -1) {
            terminalId = this.createNewTerminalId();
        }
        Terminal terminal = new Terminal();
        terminal.setId(terminalId);
        terminal.setTerminalKey(terminalKey);
        terminal.setName(String.valueOf("Terminal " + terminalId));
        if (outlet != null) {
            terminal.setOutletId(outlet.getId());
        }
        if (session == null) {
            this.save(terminal);
        } else {
            this.save(terminal, session);
        }
        return terminal;
    }

    public void refresh(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            session.refresh((Object)terminal);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findOpenTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNotNull((String)Terminal.PROP_ASSIGNED_USER_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findCashDrawerTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_HAS_CASH_DRAWER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void performBatchSave(Object ... objects) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Object object : objects) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void performBatchSave(List<String> customQueryList, Object ... objects) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Object object : objects) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            if (customQueryList != null) {
                for (String sql : customQueryList) {
                    Query query = session.createQuery(sql);
                    query.executeUpdate();
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetCashDrawer(CashDrawer report, Terminal terminal, User user, double balance) throws Exception {
        Session session = null;
        Transaction tx = null;
        report.setClosedBy(user);
        report.setReportTime(new Date());
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            terminal.setAssignedUserId(null);
            terminal.setCurrentCashDrawer(null);
            this.update(terminal, session);
            this.saveOrUpdate(report, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User closedByUser, CashDrawer cashDrawer) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.resetStaffBank(closedByUser, cashDrawer, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User closedByUser, CashDrawer cashDrawer, Session session) throws Exception {
        User assignedUser;
        cashDrawer.setClosedBy(closedByUser);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        String assignedUserId = cashDrawer.getAssignedUserId();
        if (StringUtils.isNotEmpty((String)assignedUserId) && (assignedUser = UserDAO.getInstance().get(assignedUserId)) != null) {
            assignedUser.setStaffBankStarted(false);
            assignedUser.setCurrentCashDrawer(null);
            UserDAO.getInstance().update(assignedUser, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal initialize(Terminal terminal) {
        if (terminal == null || terminal.getId() == null) {
            return terminal;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)terminal);
            Terminal terminal2 = terminal;
            return terminal2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal getByTerminalKey(String terminalKey) {
        Session session = null;
        try {
            session = this.createNewSession();
            Terminal terminal = this.getByTerminalKey(terminalKey, session);
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Terminal getByTerminalKey(String terminalKey, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)terminalKey));
        List list = criteria.list();
        if (list.size() > 0) {
            return (Terminal)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal findByAssignedUser(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            List list = criteria.list();
            if (list.size() > 0) {
                Terminal terminal = (Terminal)list.get(0);
                return terminal;
            }
            Terminal terminal = null;
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVersionEqual(Class beanClass, Object id, long versionToCompare) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(beanClass);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            Object result = criteria.uniqueResult();
            if (result instanceof Number) {
                boolean bl = ((Number)result).longValue() == versionToCompare;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion(Class beanClass, String column, Object id) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(beanClass);
            criteria.add((Criterion)Restrictions.eq((String)column, (Object)id));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            long l = (Long)criteria.uniqueResult();
            return l;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSqlQuery(List<String> sqlList) {
        if (sqlList == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (String sql : sqlList) {
                SQLQuery query = session.createSQLQuery(sql);
                query.executeUpdate();
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            PosLog.error(this.getClass(), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List executeSqlQuery(String sql) {
        return this.executeSqlQuery(sql, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSqlQuery(String sql, long startIndex, long maxResult) {
        Session session = null;
        try {
            session = this.createNewSession();
            SQLQuery sqlQuery = session.createSQLQuery(sql);
            if (maxResult > 0L) {
                sqlQuery.setFirstResult((int)startIndex);
                sqlQuery.setMaxResults((int)maxResult);
            }
            List list = sqlQuery.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findTerminalsByDeviceType(int deviceType, int limit) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_DEVICE_TYPE, (Object)deviceType));
            if (limit > 0) {
                criteria.setMaxResults(limit);
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

