/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.BaseUserTypeDAO;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class UserTypeDAO
extends BaseUserTypeDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserType> findAllUnSyncUserType() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)UserType.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)UserType.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateUserTypeSync(List<String> ids, boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update UserType set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, UserType.PROP_CLOUD_SYNCED, UserType.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateUserTypes(List<UserType> userTypes) throws Exception {
        if (userTypes == null) {
            return;
        }
        for (UserType userType : userTypes) {
            UserType existingUserType = this.get(userType.getId());
            if (existingUserType != null) {
                String id = existingUserType.getId();
                long version = existingUserType.getVersion();
                PropertyUtils.copyProperties((Object)existingUserType, (Object)userType);
                existingUserType.setId(id);
                existingUserType.setVersion(version);
                this.update(existingUserType);
                continue;
            }
            this.save(userType);
        }
    }
}

