/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Database;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.dao._BaseRootDAO;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.service.ServiceRegistry;

public abstract class _RootDAO
extends _BaseRootDAO {
    private static StandardServiceRegistry standardServiceRegistry;

    public static void initialize() {
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        _RootDAO.initialize("oropos.hibernate.cfg.xml", database, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile) {
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        _RootDAO.initialize(hibernanetCfgFile, database, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, Database database, String connectString, String databaseUser, String databasePassword) {
        _RootDAO.initialize(hibernanetCfgFile, database.getHibernateDialect(), database.getHibernateConnectionDriverClass(), connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, String hibernateDialectClass, String driverClass, String connectString, String databaseUser, String databasePassword) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", hibernateDialectClass);
        map.put("hibernate.connection.driver_class", driverClass);
        map.put("hibernate.connection.url", connectString);
        map.put("hibernate.connection.username", databaseUser);
        map.put("hibernate.connection.password", databasePassword);
        map.put("hibernate.connection.autocommit", "false");
        map.put("hibernate.max_fetch_depth", "3");
        map.put("hibernate.show_sql", "false");
        map.put("hibernate.connection.isolation", String.valueOf(1));
        map.put("hibernate.cache.use_second_level_cache", "false");
        _RootDAO.initialize(hibernanetCfgFile, map);
    }

    public static void initialize(Map<String, String> properties) {
        _RootDAO.initialize("oropos.hibernate.cfg.xml", properties);
    }

    public static void initialize(String hibernanetCfgFile, Map<String, String> properties) {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        URL resource = _RootDAO.class.getResource("/" + hibernanetCfgFile);
        registryBuilder.configure(resource);
        registryBuilder.applySettings(properties);
        _RootDAO.setupCconnectionPoolSettings(registryBuilder);
        standardServiceRegistry = registryBuilder.build();
        Metadata metaData = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
        _RootDAO.setSessionFactory(metaData.buildSessionFactory());
    }

    public static void setupCconnectionPoolSettings(StandardServiceRegistryBuilder builder) {
        builder.applySetting("hibernate.c3p0.min_size", (Object)"0");
        builder.applySetting("hibernate.c3p0.max_size", (Object)"5");
        builder.applySetting("hibernate.c3p0.timeout", (Object)"300");
        builder.applySetting("hibernate.c3p0.max_statements", (Object)"0");
        builder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"5000");
        builder.applySetting("hibernate.c3p0.acquireRetryAttempts", (Object)"1");
        builder.applySetting("hibernate.c3p0.acquireRetryDelay", (Object)"100");
        builder.applySetting("hibernate.c3p0.acquireIncrement", (Object)"1");
        builder.applySetting("testConnectionOnCheckout", (Object)"true");
        builder.applySetting("hibernate.c3p0.breakAfterAcquireFailure", (Object)"false");
    }

    public static void setupHikariCPSettings(StandardServiceRegistryBuilder builder) {
        builder.applySetting("hibernate.connection.provider_class", (Object)"org.hibernate.hikaricp.internal.HikariCPConnectionProvider");
        builder.applySetting("hibernate.hikari.idleTimeout", (Object)"30000");
        builder.applySetting("hibernate.hikari.minimumIdle", (Object)"0");
        builder.applySetting("hibernate.hikari.maximumPoolSize", (Object)"5");
    }

    public static void initialize(String configFileName, Configuration configuration) {
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
        _RootDAO.initialize();
    }

    public static void releaseConnection() {
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
    }

    public void refresh(Object obj) {
        Session session = this.createNewSession();
        super.refresh(obj, session);
        session.close();
    }

    public int rowCount() {
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        return ((Long)criteria.uniqueResult()).intValue();
    }

    public int rowCount(Criteria criteria) {
        criteria.setProjection(Projections.rowCount());
        int intValue = ((Long)criteria.uniqueResult()).intValue();
        criteria.setProjection(null);
        return intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPageData(int pageNum, int pageSize) {
        Session session = this.getSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(pageNum * pageSize);
            criteria.setMaxResults(pageSize);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Map<String, Object> restrictions) {
        Session session = this.getSession();
        try {
            Number result;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (restrictions != null) {
                for (String key : restrictions.keySet()) {
                    criteria.add((Criterion)Restrictions.eq((String)key, (Object)restrictions.get(key)));
                }
            }
            if ((result = (Number)criteria.uniqueResult()) != null) {
                int n = result.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPageData(int pageNum, int pageSize, Map<String, Object> restrictions) {
        Session session = this.getSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(pageNum * pageSize);
            criteria.setMaxResults(pageSize);
            if (restrictions != null) {
                for (String key : restrictions.keySet()) {
                    criteria.add((Criterion)Restrictions.eq((String)key, (Object)restrictions.get(key)));
                }
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

