/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao.util;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Address;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.StoreUtil;
import com.orocube.common.util.TerminalUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.hibernate.Session;

public class DefaultDataProvider
extends DataProvider {
    private Store store;
    private Outlet outlet;
    private Terminal terminal;
    private InventoryLocation defaultInLocation;
    private InventoryLocation defaultOutLocation;
    private Map<String, OrderType> orderTypes = null;
    private Map<String, UserType> userTypeMap = new LinkedHashMap<String, UserType>();
    private Map<String, Shift> shiftMap = new LinkedHashMap<String, Shift>();
    private Map<String, Currency> currencyMap = new LinkedHashMap<String, Currency>();
    private Map<String, TerminalType> terminalTypeMap = new LinkedHashMap<String, TerminalType>();
    private Map<String, Multiplier> multiplierMap = new LinkedHashMap<String, Multiplier>();
    private Map<String, Department> departmentMap = new LinkedHashMap<String, Department>();
    private Map<String, InventoryLocation> inventoryLocationMap = new LinkedHashMap<String, InventoryLocation>();
    private Map<String, InventoryUnit> inventoryUnitMap = new HashMap<String, InventoryUnit>();
    private Map<String, TaxGroup> taxGroupMap = new HashMap<String, TaxGroup>();
    private Map<String, PrinterGroup> printerGroupMap = new HashMap<String, PrinterGroup>();
    private Map<String, ReportGroup> reportGroupMap = new HashMap<String, ReportGroup>();
    private Map<String, Course> courseMap = new HashMap<String, Course>();
    private static List<DayPart> daypartShifts;
    private static List<PriceShift> priceShifts;
    private static List<MenuShift> menuShifts;
    private Map<Integer, Terminal> terminalMap = new LinkedHashMap<Integer, Terminal>();
    private Map<String, User> userMap = new LinkedHashMap<String, User>();
    private List<OrderType> orderTypeList = new ArrayList<OrderType>();
    private List<Multiplier> multiplierList = new ArrayList<Multiplier>();
    private String defaultCourseId;
    private PosPrinters printers;
    private StoreSession currentSession;

    @Override
    public void initialize() {
        this.terminalMap.clear();
        this.userMap.clear();
        this.multiplierList.clear();
        this.orderTypeList.clear();
        this.loadStore();
        this.initializeShifts();
        this.loadTerminalTypes();
        this.loadUserTypes();
        this.loadTerminal();
        this.loadOrderTypes();
        this.loadCurrencies();
        this.loadCourses();
        this.loadMultipliers();
        this.loadInventoryLocations();
        this.loadPrinterGroups();
        this.loadInventoryUnits();
        this.loadReportGroups();
        this.loadTaxGroups();
        this.loadDepartments();
        this.loadPrinters();
    }

    private void initializeShifts() {
        List<Shift> dataList = ShiftDAO.getInstance().findAll();
        this.clear(this.shiftMap);
        if (dataList != null && dataList.size() > 0) {
            for (Shift obj : dataList) {
                this.shiftMap.put(obj.getId(), obj);
            }
        }
        daypartShifts = DayPartDAO.getInstance().findAll();
        Iterator<DayPart> iterator = daypartShifts.iterator();
        while (iterator.hasNext()) {
            Shift shift = iterator.next();
            if (!"DEFAULT SHIFT".equalsIgnoreCase(shift.getName())) continue;
            iterator.remove();
            break;
        }
        priceShifts = PriceShiftDAO.getInstance().findAllActive();
        menuShifts = MenuShiftDAO.getInstance().findAllActive();
    }

    private void loadMultipliers() {
        List<Multiplier> dataList = MultiplierDAO.getInstance().findAll();
        this.clear(this.multiplierMap);
        if (dataList != null && dataList.size() > 0) {
            for (Multiplier obj : dataList) {
                this.multiplierMap.put(obj.getId(), obj);
                this.multiplierList.add(obj);
            }
        }
    }

    private void loadTerminalTypes() {
        List<TerminalType> dataList = TerminalTypeDAO.getInstance().findAll();
        this.clear(this.terminalTypeMap);
        if (dataList != null && dataList.size() > 0) {
            for (TerminalType obj : dataList) {
                this.terminalTypeMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadCurrencies() {
        List<Currency> dataList = CurrencyDAO.getInstance().findAll();
        this.clear(this.currencyMap);
        if (dataList != null && dataList.size() > 0) {
            for (Currency obj : dataList) {
                this.currencyMap.put(obj.getId(), obj);
            }
        }
        CurrencyUtil.populateCurrency();
    }

    private void loadCourses() {
        List<Course> dataList = CourseDAO.getInstance().findAll();
        this.clear(this.courseMap);
        if (dataList != null && dataList.size() > 0) {
            this.defaultCourseId = dataList.get(0).getId();
            for (Course obj : dataList) {
                this.courseMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadUserTypes() {
        List<UserType> dataList = UserTypeDAO.getInstance().findAll();
        this.clear(this.userTypeMap);
        if (dataList != null && dataList.size() > 0) {
            for (UserType obj : dataList) {
                this.userTypeMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadDepartments() {
        List<Department> dataList = DepartmentDAO.getInstance().findAll();
        this.clear(this.departmentMap);
        if (dataList != null && dataList.size() > 0) {
            for (Department obj : dataList) {
                this.departmentMap.put(obj.getId(), obj);
            }
        }
    }

    public void loadCloudCacheData() {
        this.loadStore();
        this.loadTerminal();
        this.loadPrinterGroups();
    }

    @Override
    public void refreshStore() {
        this.store = StoreDAO.getRestaurant();
    }

    @Override
    public void refreshCurrentTerminal() {
        TerminalDAO.getInstance().refresh(this.terminal);
    }

    private void loadStore() {
        StoreSessionControl currentStoreOperation;
        this.store = StoreDAO.getRestaurant();
        if (this.store.getUniqueId() == null || this.store.getUniqueId() == 0) {
            this.store.setUniqueId(RandomUtils.nextInt());
            StoreDAO.getInstance().saveOrUpdate(this.store);
        }
        this.outlet = OutletDAO.getInstance().get(String.valueOf(this.store.getUniqueId()));
        if (this.outlet == null) {
            this.outlet = new Outlet();
            this.outlet.setId(String.valueOf(this.store.getUniqueId()));
            this.outlet.setName(this.store.getOutletName());
            Address address = new Address();
            address.setAddressLine(this.store.getAddressLine1());
            this.outlet.setAddress(address);
            AddressDAO.getInstance().saveOrUpdate(address);
            OutletDAO.getInstance().save(this.outlet);
        }
        if ((currentStoreOperation = StoreUtil.getCurrentStoreOperation()) != null) {
            this.currentSession = currentStoreOperation.getCurrentData();
        }
    }

    @Override
    public void setStoreSession(StoreSession session) {
        this.currentSession = session;
    }

    @Override
    public StoreSession getStoreSession() {
        return this.currentSession;
    }

    private void loadOrderTypes() {
        this.orderTypes = new LinkedHashMap<String, OrderType>();
        List<OrderType> dataList = OrderTypeDAO.getInstance().findEnabledOrderTypesForTerminal(this.terminal);
        this.orderTypeList.clear();
        if (dataList != null && dataList.size() > 0) {
            for (OrderType obj : dataList) {
                this.orderTypes.put(obj.getId(), obj);
                this.orderTypeList.add(obj);
            }
        }
    }

    private void loadTerminal() {
        try {
            int terminalId = 0;
            String terminalKey = TerminalUtil.getSystemUID();
            TerminalDAO terminalDAO = TerminalDAO.getInstance();
            this.terminal = terminalDAO.getByTerminalKey(terminalKey);
            if (this.terminal != null) {
                TerminalConfig.setTerminalId(this.terminal.getId());
                return;
            }
            terminalId = TerminalConfig.getTerminalId();
            this.terminal = terminalDAO.get(terminalId);
            Outlet outlet = DataProvider.get().getOutlet();
            if (this.terminal == null) {
                this.terminal = terminalDAO.createNewTerminal(terminalKey, terminalId, outlet);
            } else if (!terminalKey.equals(this.terminal.getTerminalKey())) {
                this.terminal = terminalDAO.createNewTerminal(terminalKey, null, outlet);
            }
            if (this.terminal.getOutlet() == null) {
                this.terminal.setOutlet(outlet);
                terminalDAO.saveOrUpdate(this.terminal);
            }
            TerminalConfig.setTerminalId(terminalId);
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e);
        }
    }

    private void loadTaxGroups() {
        List<TaxGroup> dataList = TaxGroupDAO.getInstance().findAll();
        this.clear(this.taxGroupMap);
        if (dataList != null && dataList.size() > 0) {
            for (TaxGroup obj : dataList) {
                this.taxGroupMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadReportGroups() {
        List<ReportGroup> dataList = ReportGroupDAO.getInstance().findAll();
        this.clear(this.reportGroupMap);
        if (dataList != null && dataList.size() > 0) {
            for (ReportGroup obj : dataList) {
                this.reportGroupMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadInventoryUnits() {
        List<InventoryUnit> dataList = InventoryUnitDAO.getInstance().findAll();
        this.clear(this.inventoryUnitMap);
        if (dataList != null && dataList.size() > 0) {
            for (InventoryUnit obj : dataList) {
                this.inventoryUnitMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadPrinterGroups() {
        List<PrinterGroup> dataList = PrinterGroupDAO.getInstance().findAll();
        this.clear(this.printerGroupMap);
        if (dataList != null && dataList.size() > 0) {
            for (PrinterGroup obj : dataList) {
                this.printerGroupMap.put(obj.getId(), obj);
            }
        }
    }

    private void loadInventoryLocations() {
        this.defaultInLocation = null;
        this.defaultOutLocation = null;
        Terminal currentTerminal = this.getCurrentTerminal();
        String inventoryInLocationId = currentTerminal.getInventoryInLocationId();
        String inventoryOutLocationId = currentTerminal.getInventoryOutLocationId();
        if (StringUtils.isNotEmpty((String)inventoryInLocationId)) {
            this.defaultInLocation = InventoryLocationDAO.getInstance().get(inventoryInLocationId);
        }
        if (StringUtils.isNotEmpty((String)inventoryOutLocationId)) {
            this.defaultOutLocation = InventoryLocationDAO.getInstance().get(inventoryOutLocationId);
        }
        List<InventoryLocation> dataList = InventoryLocationDAO.getInstance().findAll();
        this.clear(this.inventoryLocationMap);
        if (dataList != null && dataList.size() > 0) {
            for (InventoryLocation location : dataList) {
                this.inventoryLocationMap.put(location.getId(), location);
                if (this.defaultInLocation == null && location.isDefaultInLocation().booleanValue()) {
                    this.defaultInLocation = location;
                }
                if (this.defaultOutLocation != null || !location.isDefaultOutLocation().booleanValue()) continue;
                this.defaultOutLocation = location;
            }
        }
    }

    private void clear(Map map) {
        if (map.size() > 0) {
            map.clear();
        }
    }

    @Override
    public Terminal getCurrentTerminal() {
        return this.terminal;
    }

    @Override
    public void setCloudTerminal(Terminal terminal) {
        this.terminalMap.put(terminal.getId(), terminal);
        this.terminal = terminal;
    }

    @Override
    public OrderType getOrderType(String orderTypeId) {
        return this.orderTypes.get(orderTypeId);
    }

    @Override
    public List<OrderType> getOrderTypes() {
        return this.orderTypeList;
    }

    @Override
    public UserType getUserType(String userTypeId) {
        UserType userType = this.userTypeMap.get(userTypeId);
        if (userType == null) {
            return UserTypeDAO.getInstance().get(userTypeId);
        }
        return userType;
    }

    @Override
    public Currency getCurrency(String currencyId) {
        return this.currencyMap.get(currencyId);
    }

    @Override
    public Course getCourse(String courseId) {
        return this.courseMap.get(courseId);
    }

    @Override
    public TerminalType getTerminalType(String terminalTypeId) {
        return this.terminalTypeMap.get(terminalTypeId);
    }

    @Override
    public Multiplier getMultiplierById(String id) {
        return this.multiplierMap.get(id);
    }

    @Override
    public List<Multiplier> getMultiplierList() {
        return this.multiplierList;
    }

    @Override
    public InventoryLocation getDefaultInLocation() {
        return this.defaultInLocation;
    }

    @Override
    public InventoryLocation getDefaultOutLocation() {
        return this.defaultOutLocation;
    }

    @Override
    public List<Course> getCourses() {
        if (this.courseMap.size() > 0) {
            return new ArrayList<Course>(this.courseMap.values());
        }
        return new ArrayList<Course>();
    }

    @Override
    public String getDefaultCourseId() {
        return this.defaultCourseId;
    }

    @Override
    public String getRecipeMenuItemName(Recepie recipe) {
        return RecepieDAO.getInstance().getMenuItemName(recipe);
    }

    @Override
    public MenuItemInventoryStatus getMenuItemStockStatus(MenuItem menuItem) {
        MenuItemInventoryStatusDAO dao = MenuItemInventoryStatusDAO.getInstance();
        try (Session session = dao.createNewSession();){
            MenuItemInventoryStatus stockStatus = dao.get(menuItem.getId(), session);
            if (stockStatus == null) {
                stockStatus = new MenuItemInventoryStatus(menuItem.getId());
                dao.save(stockStatus, session);
            }
            MenuItemInventoryStatus menuItemInventoryStatus = stockStatus;
            return menuItemInventoryStatus;
        }
    }

    @Override
    public SalesArea getSalesArea(String salesAreaId) {
        if (StringUtils.isEmpty((String)salesAreaId)) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(salesAreaId);
    }

    @Override
    public Customer getCustomer(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return CustomerDAO.getInstance().get(id);
    }

    @Override
    public double getPriceFromPriceRule(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup) {
        Double price = PriceRuleDAO.getInstance().getPrice(menuItem, orderType, department, salesArea, customerGroup);
        if (price == null) {
            return menuItem.getPrice();
        }
        return price;
    }

    @Override
    public PosPrinters getPrinters() {
        return this.printers;
    }

    private void loadPrinters() {
        this.printers = PosPrinters.load();
        if (this.printers == null) {
            this.printers = new PosPrinters();
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public Outlet getOutlet() {
        return this.outlet;
    }

    @Override
    public InventoryUnit getInventoryUnitById(String unitId) {
        if (StringUtils.isEmpty((String)unitId)) {
            return null;
        }
        return this.inventoryUnitMap.get(unitId);
    }

    @Override
    public TaxGroup getTaxGroupById(String taxGroupId) {
        if (StringUtils.isEmpty((String)taxGroupId)) {
            return null;
        }
        return this.taxGroupMap.get(taxGroupId);
    }

    @Override
    public ReportGroup getReportGroupById(String reportGroupId) {
        if (StringUtils.isEmpty((String)reportGroupId)) {
            return null;
        }
        return this.reportGroupMap.get(reportGroupId);
    }

    @Override
    public PrinterGroup getPrinterGroupById(String printerGroupId) {
        if (StringUtils.isEmpty((String)printerGroupId)) {
            return null;
        }
        return this.printerGroupMap.get(printerGroupId);
    }

    @Override
    public Department getDepartmentById(String departmentId) {
        if (StringUtils.isEmpty((String)departmentId)) {
            return null;
        }
        return this.departmentMap.get(departmentId);
    }

    @Override
    public OrderType getOrderTypeById(String orderTypeId) {
        if (StringUtils.isEmpty((String)orderTypeId)) {
            return null;
        }
        if (this.orderTypes != null) {
            return this.orderTypes.get(orderTypeId);
        }
        return OrderTypeDAO.getInstance().get(orderTypeId);
    }

    @Override
    public InventoryLocation getInventoryLocationById(String inventoryLocationId) {
        if (StringUtils.isEmpty((String)inventoryLocationId)) {
            return null;
        }
        return this.inventoryLocationMap.get(inventoryLocationId);
    }

    @Override
    public User getUserById(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        User user = this.userMap.get(userId);
        if (user == null) {
            user = UserDAO.getInstance().get(userId);
            this.userMap.put(userId, user);
        }
        return user;
    }

    @Override
    public Terminal getTerminalById(Integer terminalId) {
        if (terminalId == null) {
            return null;
        }
        Terminal terminal2 = this.terminalMap.get(terminalId);
        if (terminal2 == null) {
            terminal2 = TerminalDAO.getInstance().get(terminalId);
            this.terminalMap.put(terminalId, terminal2);
        }
        return terminal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectOf(Class clazz, Serializable id) {
        Session session = null;
        try {
            session = StoreDAO.getInstance().createNewSession();
            Object object = session.get(clazz, id);
            return object;
        }
        finally {
            StoreDAO.getInstance().closeSession(session);
        }
    }

    @Override
    public Shift getShiftById(String shiftId) {
        if (StringUtils.isEmpty((String)shiftId)) {
            return null;
        }
        return this.shiftMap.get(shiftId);
    }

    @Override
    public List<DayPart> getDaryPartShifts() {
        return daypartShifts;
    }

    @Override
    public List<PriceShift> getPriceShifts() {
        return priceShifts;
    }

    @Override
    public List<MenuShift> getMenuShifts() {
        return menuShifts;
    }

    @Override
    public File getAppConfigFileLocation() {
        return new File(".");
    }
}

