/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportTableModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.PrintServiceUtil;
import java.awt.print.PrinterAbortException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosPrintService {
    private static final SimpleDateFormat date_formatter = new SimpleDateFormat("dd MMM, yyyy hh:mm aaa");
    private static Log logger = LogFactory.getLog(PosPrintService.class);

    public static void printDrawerPullReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateDrawerPullReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterAbortException jasperPrint) {
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
        }
    }

    public static void printCashDrawerSummaryReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterAbortException jasperPrint) {
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
        }
    }

    public static void printReportByJasperPrint(JasperPrint jasperPrint) {
        try {
            PrintService printServiceForPrinter = PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty("printerName"));
            JRPrintServiceExporter exporter = new JRPrintServiceExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
            configuration.setPrintService(printServiceForPrinter);
            configuration.setDisplayPageDialog(Boolean.valueOf(false));
            configuration.setDisplayPrintDialog(Boolean.valueOf(false));
            exporter.setConfiguration((ExporterConfiguration)configuration);
            exporter.exportReport();
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
        }
    }

    public static void printServerTipsReport(TipsCashoutReport report) {
        try {
            JasperPrint jasperPrint = PosPrintService.createServerTipsReport(report);
            jasperPrint.setName("SERVER_TIPS_" + report.getServer());
            jasperPrint.setProperty("printerName", Application.getPrinters().getReceiptPrinter());
            ReceiptPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
            logger.error((Object)"error print tips report", (Throwable)e);
        }
    }

    public static JasperPrint createServerTipsReport(TipsCashoutReport report) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("server", report.getServer());
        if (report.getFromDate() != null) {
            parameters.put("fromDate", Application.formatDate(report.getFromDate()));
        }
        if (report.getToDate() != null) {
            parameters.put("toDate", Application.formatDate(report.getToDate()));
        }
        parameters.put("reportDate", new SimpleDateFormat("dd MMM yyyy, hh:mm aaa").format(report.getReportTime()));
        parameters.put("transactionCount", report.getDatas() == null ? "0" : "" + report.getDatas().size());
        parameters.put("cashTips", NumberUtil.formatNumber(report.getCashTipsAmount()));
        parameters.put("chargedTips", NumberUtil.formatNumber(report.getChargedTipsAmount()));
        parameters.put("declaredTips", report.getDeclaredTipsAmount());
        parameters.put("tipsDue", report.getTipsDue());
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        JasperReport mainReport = ReportUtil.getReport("ServerTipsReport");
        JRTableModelDataSource dataSource = new JRTableModelDataSource((TableModel)new TipsCashoutReportTableModel(report.getDatas(), new String[]{"ticketId", "saleType", "ticketTotal", "tips", "chargedTips", "tipsPaid"}));
        return JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
    }

    public static JasperPrint populateDrawerPullReportParameters(CashDrawer cashDrawer) throws Exception {
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        parameters.put("reportTitle", staffBankReport ? "Staff bank report" : "Cash drawer report");
        parameters.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", (staffBankReport ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + userInfo);
        }
        if (cashDrawer.getStartTime() != null) {
            parameters.put("startTime", "Started: " + date_formatter.format(cashDrawer.getStartTime()));
        }
        parameters.put("date", "Report Time: " + date_formatter.format(new Date()));
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        PosPrinters printers = Application.getPrinters();
        if (printers != null) {
            jasperPrint.setProperty("printerName", printers.getReceiptPrinter());
        }
        jasperPrint.setName("DrawerPullReport" + cashDrawer.getId());
        return jasperPrint;
    }

    public static JasperPrint populateStoreSessionSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        parameters.put("reportTitle", "End of day sales report");
        parameters.put("IS_IGNORE_PAGINATION", true);
        parameters.put("startTime", "Opening time: " + date_formatter.format(cashDrawer.getStartTime()));
        parameters.put("user", "Opened by: " + cashDrawer.getAssignedBy());
        if (cashDrawer.getReportTime() != null) {
            parameters.put("date", "Closing time: " + date_formatter.format(cashDrawer.getReportTime()));
            parameters.put("reportUser", "Closed by: " + cashDrawer.getClosedBy());
        }
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("store-session-summary-report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", Application.getPrinters().getReceiptPrinter());
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer) throws Exception {
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        parameters.put("reportTitle", staffBankReport ? "Staff bank report" : "Cash drawer report");
        JasperPrint jasperPrint = PosPrintService.populateTerminalStatusReport(cashDrawer, staffBankReport, parameters);
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer, boolean staffBankReport, HashMap parameters) throws JRException {
        parameters.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", (staffBankReport ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + userInfo);
        }
        if (cashDrawer.getStartTime() != null) {
            parameters.put("startTime", "Started: " + date_formatter.format(cashDrawer.getStartTime()));
        }
        parameters.put("date", "Report Time: " + date_formatter.format(new Date()));
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, (Map)parameters, (JRDataSource)dataSource);
        PosPrinters printers = Application.getPrinters();
        if (printers != null) {
            jasperPrint.setProperty("printerName", printers.getReceiptPrinter());
        }
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> reportList) {
        CashDrawer cashDrawersReportSummary = new CashDrawer();
        HashMap<String, CashBreakdown> summaryCashBreakdownMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> cashDrawerIds = new ArrayList<String>();
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                if (report.getReportTime() == null) {
                    try {
                        CashDrawerReportService reportService2 = new CashDrawerReportService(report);
                        reportService2.populateReport();
                    }
                    catch (Exception reportService2) {
                        // empty catch block
                    }
                }
                cashDrawerIds.add(report.getId());
                cashDrawersReportSummary.setBeginCash(cashDrawersReportSummary.getBeginCash() + report.getBeginCash());
                cashDrawersReportSummary.setNetSales(cashDrawersReportSummary.getNetSales() + report.getNetSales());
                cashDrawersReportSummary.setSalesTax(cashDrawersReportSummary.getSalesTax() + report.getSalesTax());
                cashDrawersReportSummary.setSalesDeliveryCharge(cashDrawersReportSummary.getSalesDeliveryCharge() + report.getSalesDeliveryCharge());
                cashDrawersReportSummary.setChargedTips(cashDrawersReportSummary.getChargedTips() + report.getChargedTips());
                cashDrawersReportSummary.setTotalVoid(cashDrawersReportSummary.getTotalVoid() + report.getTotalVoid());
                cashDrawersReportSummary.setTotalVoidWst(cashDrawersReportSummary.getTotalVoidWst() + report.getTotalVoidWst());
                cashDrawersReportSummary.setTipsPaid(cashDrawersReportSummary.getTipsPaid() + report.getTipsPaid());
                cashDrawersReportSummary.setTotalDiscountCount(cashDrawersReportSummary.getTotalDiscountCount() + report.getTotalDiscountCount());
                cashDrawersReportSummary.setTotalDiscountAmount(cashDrawersReportSummary.getTotalDiscountAmount() + report.getTotalDiscountAmount());
                cashDrawersReportSummary.setCashReceiptCount(cashDrawersReportSummary.getCashReceiptCount() + report.getCashReceiptCount());
                cashDrawersReportSummary.setCashReceiptAmount(cashDrawersReportSummary.getCashReceiptAmount() + report.getCashReceiptAmount());
                cashDrawersReportSummary.setCreditCardReceiptCount(cashDrawersReportSummary.getCreditCardReceiptCount() + report.getCreditCardReceiptCount());
                cashDrawersReportSummary.setCreditCardReceiptAmount(cashDrawersReportSummary.getCreditCardReceiptAmount() + report.getCreditCardReceiptAmount());
                cashDrawersReportSummary.setDebitCardReceiptCount(cashDrawersReportSummary.getDebitCardReceiptCount() + report.getDebitCardReceiptCount());
                cashDrawersReportSummary.setDebitCardReceiptAmount(cashDrawersReportSummary.getDebitCardReceiptAmount() + report.getDebitCardReceiptAmount());
                cashDrawersReportSummary.setGiftCertReturnCount(cashDrawersReportSummary.getGiftCertReturnCount() + report.getGiftCertReturnCount());
                cashDrawersReportSummary.setGiftCertReturnAmount(cashDrawersReportSummary.getGiftCertReturnAmount() + report.getGiftCertReturnAmount());
                cashDrawersReportSummary.setGiftCertChangeAmount(cashDrawersReportSummary.getGiftCertChangeAmount() + report.getGiftCertChangeAmount());
                cashDrawersReportSummary.setCustomPaymentCount(cashDrawersReportSummary.getCustomPaymentCount() + report.getCustomPaymentCount());
                cashDrawersReportSummary.setCustomPaymentAmount(cashDrawersReportSummary.getCustomPaymentAmount() + report.getCustomPaymentAmount());
                cashDrawersReportSummary.setRefundReceiptCount(cashDrawersReportSummary.getRefundReceiptCount() + report.getRefundReceiptCount());
                cashDrawersReportSummary.setRefundAmount(cashDrawersReportSummary.getRefundAmount() + report.getRefundAmount());
                cashDrawersReportSummary.setPayOutCount(cashDrawersReportSummary.getPayOutCount() + report.getPayOutCount());
                cashDrawersReportSummary.setPayOutAmount(cashDrawersReportSummary.getPayOutAmount() + report.getPayOutAmount());
                cashDrawersReportSummary.setDrawerBleedCount(cashDrawersReportSummary.getDrawerBleedCount() + report.getDrawerBleedCount());
                cashDrawersReportSummary.setDrawerBleedAmount(cashDrawersReportSummary.getDrawerBleedAmount() + report.getDrawerBleedAmount());
                cashDrawersReportSummary.setCashTips(cashDrawersReportSummary.getCashTips() + report.getCashTips());
                cashDrawersReportSummary.setChargedTips(cashDrawersReportSummary.getChargedTips() + report.getChargedTips());
                cashDrawersReportSummary.setCashBack(cashDrawersReportSummary.getCashBack() + report.getCashBack());
                cashDrawersReportSummary.setCashToDeposit(cashDrawersReportSummary.getCashToDeposit() + report.getCashToDeposit());
                List<CashBreakdown> cashBreakdowns = report.getCashBreakdownList();
                if (cashBreakdowns != null) {
                    for (CashBreakdown cashBreakdown : cashBreakdowns) {
                        CashBreakdown breakdown = (CashBreakdown)summaryCashBreakdownMap.get(cashBreakdown.getCurrency().getName());
                        if (breakdown == null) {
                            breakdown = new CashBreakdown();
                            summaryCashBreakdownMap.put(cashBreakdown.getCurrency().getName(), breakdown);
                        }
                        breakdown.setBalance(breakdown.getBalance() + cashBreakdown.getBalance());
                        breakdown.setBalance(breakdown.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawersReportSummary.setStoreOperationData(report.getStoreOperationData());
            }
        }
        cashDrawersReportSummary.calculate();
        cashDrawersReportSummary.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(cashDrawerIds)));
        return cashDrawersReportSummary;
    }

    public static void printCashDrawerReportSummary(StoreSession currentData) {
        List<CashDrawer> drawerReports = CashDrawerDAO.getInstance().findByStoreOperationData(currentData, false);
        CashDrawer cashDrawersReportSummary = PosPrintService.populateCashDrawerReportSummary(drawerReports);
        cashDrawersReportSummary.setStartTime(currentData.getOpenTime());
        cashDrawersReportSummary.setAssignedBy(currentData.getOpenedBy());
        cashDrawersReportSummary.setReportTime(currentData.getCloseTime());
        cashDrawersReportSummary.setClosedBy(currentData.getClosedBy());
        PosPrintService.printCashDrawerSummaryReport(cashDrawersReportSummary);
    }

    public static JasperPrint populateServerSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        parameters.put("reportTitle", "Server summary report");
        parameters.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", "Staff : " + userInfo);
        }
        String storeSessionStartTime = DateUtil.formatFullDateAndTimeAsString(cashDrawer.getStartTime());
        if (cashDrawer.getReportTime() != null) {
            parameters.put("date", "<b>From:</b> " + storeSessionStartTime + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(cashDrawer.getReportTime()));
        } else {
            parameters.put("date", "<b>From:</b> " + storeSessionStartTime + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(new Date()));
        }
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("server-summary-report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", Application.getPrinters().getReceiptPrinter());
        jasperPrint.setName("ServerSummaryReport");
        return jasperPrint;
    }

    public static CashDrawer populateCloudCashDrawerReportSummary(List<CashDrawer> reportList) {
        CashDrawer cashDrawersReportSummary = new CashDrawer();
        HashMap<String, CashBreakdown> summaryCashBreakdownMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> cashDrawerIds = new ArrayList<String>();
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                cashDrawerIds.add(report.getId());
                cashDrawersReportSummary.setBeginCash(cashDrawersReportSummary.getBeginCash() + report.getBeginCash());
                cashDrawersReportSummary.setNetSales(cashDrawersReportSummary.getNetSales() + report.getNetSales());
                cashDrawersReportSummary.setSalesTax(cashDrawersReportSummary.getSalesTax() + report.getSalesTax());
                cashDrawersReportSummary.setSalesDeliveryCharge(cashDrawersReportSummary.getSalesDeliveryCharge() + report.getSalesDeliveryCharge());
                cashDrawersReportSummary.setTotalVoid(cashDrawersReportSummary.getTotalVoid() + report.getTotalVoid());
                cashDrawersReportSummary.setTotalVoidWst(cashDrawersReportSummary.getTotalVoidWst() + report.getTotalVoidWst());
                cashDrawersReportSummary.setTipsPaid(cashDrawersReportSummary.getTipsPaid() + report.getTipsPaid());
                cashDrawersReportSummary.setTotalDiscountCount(cashDrawersReportSummary.getTotalDiscountCount() + report.getTotalDiscountCount());
                cashDrawersReportSummary.setTotalDiscountAmount(cashDrawersReportSummary.getTotalDiscountAmount() + report.getTotalDiscountAmount());
                cashDrawersReportSummary.setCashReceiptCount(cashDrawersReportSummary.getCashReceiptCount() + report.getCashReceiptCount());
                cashDrawersReportSummary.setCashReceiptAmount(cashDrawersReportSummary.getCashReceiptAmount() + report.getCashReceiptAmount());
                cashDrawersReportSummary.setCreditCardReceiptCount(cashDrawersReportSummary.getCreditCardReceiptCount() + report.getCreditCardReceiptCount());
                cashDrawersReportSummary.setCreditCardReceiptAmount(cashDrawersReportSummary.getCreditCardReceiptAmount() + report.getCreditCardReceiptAmount());
                cashDrawersReportSummary.setDebitCardReceiptCount(cashDrawersReportSummary.getDebitCardReceiptCount() + report.getDebitCardReceiptCount());
                cashDrawersReportSummary.setDebitCardReceiptAmount(cashDrawersReportSummary.getDebitCardReceiptAmount() + report.getDebitCardReceiptAmount());
                cashDrawersReportSummary.setGiftCertReturnCount(cashDrawersReportSummary.getGiftCertReturnCount() + report.getGiftCertReturnCount());
                cashDrawersReportSummary.setGiftCertReturnAmount(cashDrawersReportSummary.getGiftCertReturnAmount() + report.getGiftCertReturnAmount());
                cashDrawersReportSummary.setGiftCertChangeAmount(cashDrawersReportSummary.getGiftCertChangeAmount() + report.getGiftCertChangeAmount());
                cashDrawersReportSummary.setCustomPaymentCount(cashDrawersReportSummary.getCustomPaymentCount() + report.getCustomPaymentCount());
                cashDrawersReportSummary.setCustomPaymentAmount(cashDrawersReportSummary.getCustomPaymentAmount() + report.getCustomPaymentAmount());
                cashDrawersReportSummary.setRefundReceiptCount(cashDrawersReportSummary.getRefundReceiptCount() + report.getRefundReceiptCount());
                cashDrawersReportSummary.setRefundAmount(cashDrawersReportSummary.getRefundAmount() + report.getRefundAmount());
                cashDrawersReportSummary.setPayOutCount(cashDrawersReportSummary.getPayOutCount() + report.getPayOutCount());
                cashDrawersReportSummary.setPayOutAmount(cashDrawersReportSummary.getPayOutAmount() + report.getPayOutAmount());
                cashDrawersReportSummary.setDrawerBleedCount(cashDrawersReportSummary.getDrawerBleedCount() + report.getDrawerBleedCount());
                cashDrawersReportSummary.setDrawerBleedAmount(cashDrawersReportSummary.getDrawerBleedAmount() + report.getDrawerBleedAmount());
                cashDrawersReportSummary.setCashTips(cashDrawersReportSummary.getCashTips() + report.getCashTips());
                cashDrawersReportSummary.setChargedTips(cashDrawersReportSummary.getChargedTips() + report.getChargedTips());
                cashDrawersReportSummary.setCashBack(cashDrawersReportSummary.getCashBack() + report.getCashBack());
                cashDrawersReportSummary.setCashToDeposit(cashDrawersReportSummary.getCashToDeposit() + report.getCashToDeposit());
                List<CashBreakdown> cashBreakdowns = report.getCashBreakdownList();
                if (cashBreakdowns != null) {
                    for (CashBreakdown cashBreakdown : cashBreakdowns) {
                        CashBreakdown breakdown = (CashBreakdown)summaryCashBreakdownMap.get(cashBreakdown.getCurrency().getName());
                        if (breakdown == null) {
                            breakdown = new CashBreakdown();
                            summaryCashBreakdownMap.put(cashBreakdown.getCurrency().getName(), breakdown);
                        }
                        breakdown.setBalance(breakdown.getBalance() + cashBreakdown.getBalance());
                        breakdown.setBalance(breakdown.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawersReportSummary.setStoreOperationData(report.getStoreOperationData());
            }
        }
        cashDrawersReportSummary.calculate();
        cashDrawersReportSummary.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(cashDrawerIds)));
        return cashDrawersReportSummary;
    }
}

