/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CashDrawerTransactionReportModel
extends AbstractTableModel {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yy, hh:mm a");
    private String[] columnNames = new String[]{"transTime", "ticketId", "member", "totalAmount", "transType"};
    private List<PosTransaction> items;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PosTransaction transaction = this.items.get(rowIndex);
        Ticket ticket = transaction.getTicket();
        switch (columnIndex) {
            case 0: {
                return dateFormat.format(transaction.getTransactionTime());
            }
            case 1: {
                if (ticket != null) {
                    return ticket.getId();
                }
                return null;
            }
            case 2: {
                String customerId = transaction.getCustomerId();
                if (customerId == null) {
                    return "Guest";
                }
                Customer customer = CustomerDAO.getInstance().findById(customerId);
                return customer == null ? "Guest" : customer.getName();
            }
            case 3: {
                if (transaction instanceof RefundTransaction || transaction instanceof CashDropTransaction || transaction instanceof PayOutTransaction) {
                    return transaction.getAmount() * -1.0;
                }
                return transaction.getAmount();
            }
            case 4: {
                return transaction.getPaymentTypeString().replaceAll("_", " ");
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.items;
    }

    public void setItems(List<PosTransaction> items) {
        this.items = items;
    }
}

