/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CardReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PanelTester;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CreditCardReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;

    public CreditCardReportView() {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CreditCardReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(CreditCardReportView.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
    }

    private void viewReport() throws Exception {
        Class[] transactionTypes;
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        fromDate = DateUtil.startOfDay(fromDate);
        toDate = DateUtil.endOfDay(toDate);
        Date currentTime = new Date();
        int saleCount = 0;
        double totalSales = 0.0;
        double totalTips = 0.0;
        ArrayList<PosTransaction> newTransactionList = new ArrayList<PosTransaction>();
        for (Class class1 : transactionTypes = new Class[]{CreditCardTransaction.class, DebitCardTransaction.class, CustomPaymentTransaction.class, CustomerAccountTransaction.class}) {
            List<? extends PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactions(null, class1, fromDate, toDate);
            for (PosTransaction posTransaction : transactions) {
                ++saleCount;
                totalSales += posTransaction.getAmount().doubleValue();
                totalTips += posTransaction.getTipsAmount().doubleValue();
                newTransactionList.add(posTransaction);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map);
        map.put("reportTitle", Messages.getString("CreditCardReportView.0"));
        map.put("fromDate", ReportService.formatFullDate(fromDate));
        map.put("toDate", ReportService.formatFullDate(toDate));
        map.put("reportTime", ReportService.formatFullDate(currentTime));
        map.put("tips", "Tips (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("totalHeader", "Total (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("saleCount", String.valueOf(saleCount));
        map.put("totalSales", NumberUtil.formatNumber(totalSales - totalTips));
        map.put("totalTips", NumberUtil.formatNumber(totalTips));
        map.put("total", NumberUtil.formatNumber(totalSales));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("credit-card-report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)new CardReportModel(newTransactionList)));
        JRViewer viewer = new JRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }

    public static void main(String[] args) {
        PanelTester.width = 800;
        PanelTester.height = 500;
        PanelTester.test(new CreditCardReportView());
    }
}

