/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Discount;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.swing.ListTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SalesExceptionReport {
    private Date fromDate;
    private Date toDate;
    private Date reportTime;
    private List<VoidData> voidedTickets = new ArrayList<VoidData>();
    private Map<String, DiscountData> disountMap = new HashMap<String, DiscountData>();
    private List<RefundData> refundTickets = new ArrayList<RefundData>();

    public void addVoidToVoidData(Ticket ticket) {
        double amount = ticket.getSubtotalAmount();
        String voidReason = ticket.getVoidReason();
        VoidData voidData = new VoidData();
        voidData.ticketid = ticket.getId();
        voidData.setReasonCode(voidReason);
        voidData.setCount(1);
        voidData.setAmount(amount);
        voidData.wasted = ticket.isWasted();
        this.voidedTickets.add(voidData);
    }

    public void addRefundToRefundData(RefundTransaction refundTransaction) {
        double amount = refundTransaction.getAmount();
        RefundData refundData = new RefundData();
        refundData.ticketId = refundTransaction.getTicketId();
        refundData.setTime(refundTransaction.getTransactionTime());
        refundData.setTransactionId(refundTransaction.getId());
        refundData.setPaymentType(refundTransaction.getPaymentTypeString());
        refundData.setAmount(amount);
        this.refundTickets.add(refundData);
    }

    public void addDiscountOnTicketItem(TicketItem ticketItem) {
        List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount discount : discounts) {
                String name = discount.getName();
                DiscountData discountData = this.disountMap.get(discount.getDiscountId());
                if (discountData == null) {
                    discountData = new DiscountData();
                    discountData.code = discount.getDiscountId();
                    discountData.name = name;
                    this.disountMap.put(discount.getDiscountId(), discountData);
                }
                discountData.totalCount = ++discountData.totalCount;
                discountData.totalDiscount = discountData.totalDiscount + discount.getAmount();
                discountData.totalNetSales = discountData.totalNetSales + ticketItem.getSubtotalAmount();
                discountData.partySize = discountData.partySize + (double)ticketItem.getTicket().getNumberOfGuests().intValue();
                discountData.checkSize = discountData.totalNetSales / (double)discountData.totalCount;
            }
        }
    }

    public void addDiscountOnTicket(Ticket ticket) {
        List<TicketDiscount> discounts = ticket.getDiscounts();
        if (discounts != null) {
            for (TicketDiscount discount : discounts) {
                String name = discount.getName();
                DiscountData discountData = this.disountMap.get(discount.getDiscountId());
                if (discountData == null) {
                    discountData = new DiscountData();
                    discountData.code = discount.getDiscountId();
                    discountData.name = name;
                    this.disountMap.put(discount.getDiscountId(), discountData);
                }
                discountData.totalCount = ++discountData.totalCount;
                discountData.totalDiscount = discountData.totalDiscount + discount.getTotalDiscountAmount();
                discountData.totalNetSales = discountData.totalNetSales + ticket.getSubtotalAmount();
                discountData.partySize = discountData.partySize + (double)ticket.getNumberOfGuests().intValue();
                discountData.checkSize = discountData.totalNetSales / (double)discountData.totalCount;
            }
        }
    }

    public void addEmptyDiscounts(List<Discount> discounts) {
        if (discounts != null) {
            for (Discount discount : discounts) {
                String name = discount.getName();
                DiscountData discountData = this.disountMap.get(discount.getId());
                if (discountData != null) continue;
                discountData = new DiscountData();
                discountData.code = discount.getId();
                discountData.name = name;
                this.disountMap.put(discount.getId(), discountData);
            }
        }
    }

    public static void main(String[] args) {
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(Date reportTime) {
        this.reportTime = reportTime;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public VoidTableModel getVoidTableModel() {
        VoidTableModel model = new VoidTableModel();
        model.setRows(this.voidedTickets);
        return model;
    }

    public RefundTableModel getRefundTableModel() {
        RefundTableModel model = new RefundTableModel();
        model.setRows(this.refundTickets);
        return model;
    }

    public DiscountTableModel getDiscountTableModel() {
        DiscountTableModel model = new DiscountTableModel();
        ArrayList<DiscountData> list = new ArrayList<DiscountData>(this.disountMap.values());
        model.setRows(list);
        return model;
    }

    public class RefundTableModel
    extends ListTableModel {
        public RefundTableModel() {
            this.setColumnNames(new String[]{"time", "ticketId", "transactionId", "paymentType", "amount"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RefundData data = (RefundData)this.rows.get(rowIndex);
            if (data == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return data.getTime();
                }
                case 1: {
                    return data.getTicketId();
                }
                case 2: {
                    return data.getTransactionId();
                }
                case 3: {
                    return data.getPaymentType();
                }
                case 4: {
                    return data.getAmount();
                }
            }
            return null;
        }
    }

    public static class RefundData {
        private Date time;
        private String ticketId;
        private String transactionId;
        private String paymentType;
        private double amount;

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public String getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(String paymentType) {
            this.paymentType = paymentType;
        }
    }

    public class DiscountTableModel
    extends ListTableModel {
        public DiscountTableModel() {
            this.setColumnNames(new String[]{"no", "name", "code", "totalCount", "totalDiscount", "totalNetSales", "totalGuests", "partySize", "checkSize", "countPercent", "ratioDnet"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DiscountData data = (DiscountData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.code;
                }
                case 1: {
                    return data.name;
                }
                case 2: {
                    return data.code;
                }
                case 3: {
                    return data.totalCount;
                }
                case 4: {
                    return data.totalDiscount;
                }
                case 5: {
                    return data.totalNetSales;
                }
                case 7: {
                    return data.partySize;
                }
                case 8: {
                    return data.checkSize;
                }
            }
            return null;
        }
    }

    public class VoidTableModel
    extends ListTableModel {
        public VoidTableModel() {
            this.setColumnNames(new String[]{"code", "reason", "wast", "qty", "amount"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VoidData data = (VoidData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(data.ticketid);
                }
                case 1: {
                    return data.getReasonCode();
                }
                case 2: {
                    return data.wasted ? "Y" : "N";
                }
                case 3: {
                    return String.valueOf(data.getCount());
                }
                case 4: {
                    return data.getAmount();
                }
            }
            return null;
        }
    }

    public static class DiscountData {
        private String code;
        private String name;
        private int totalCount;
        private double totalDiscount;
        private double totalNetSales;
        private double partySize;
        private double checkSize;

        public double getCheckSize() {
            return this.checkSize;
        }

        public void setCheckSize(double checkSize) {
            this.checkSize = checkSize;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getPartySize() {
            return this.partySize;
        }

        public void setPartySize(double partySize) {
            this.partySize = partySize;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public double getTotalDiscount() {
            return this.totalDiscount;
        }

        public void setTotalDiscount(double totalDiscount) {
            this.totalDiscount = totalDiscount;
        }

        public double getTotalNetSales() {
            return this.totalNetSales;
        }

        public void setTotalNetSales(double totalNetSales) {
            this.totalNetSales = totalNetSales;
        }
    }

    public static class VoidData {
        String ticketid;
        private String reasonCode;
        private int count;
        private double amount;
        boolean wasted;

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getReasonCode() {
            return this.reasonCode;
        }

        public void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }
    }
}

