/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TicketReportModel
extends AbstractTableModel {
    private static DecimalFormat formatter = new DecimalFormat("#,##0.00");
    private String[] columnNames = new String[]{"id", "date", "orderType", "owner", "total", "due"};
    private List<Ticket> items;
    private double grandTotal;
    private double totalDue;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Ticket ticket = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(ticket.getId());
            }
            case 1: {
                return DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate());
            }
            case 2: {
                return ticket.getOrderType().getName();
            }
            case 3: {
                return ticket.getOwner().getFullName();
            }
            case 4: {
                return NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            }
            case 5: {
                return NumberUtil.formatNumber(ticket.getDueAmount());
            }
        }
        return null;
    }

    public List<Ticket> getItems() {
        return this.items;
    }

    public void setItems(List<Ticket> items) {
        this.items = items;
    }

    public String getGrandTotalAsString() {
        return formatter.format(this.grandTotal);
    }

    public void setGrandTotal(double grandTotal) {
        this.grandTotal = grandTotal;
    }

    public void calculateGrandTotal() {
        this.grandTotal = 0.0;
        if (this.items == null) {
            return;
        }
        for (Ticket item : this.items) {
            this.grandTotal += item.getDueAmount().doubleValue();
        }
    }

    public String getTotalDueAsString() {
        return formatter.format(this.totalDue);
    }

    public void setTotalDue(double totalDue) {
        this.totalDue = totalDue;
    }

    public void calculateTotalDue() {
        this.totalDue = 0.0;
        if (this.items == null) {
            return;
        }
        for (Ticket item : this.items) {
            this.totalDue += item.getDueAmount().doubleValue();
        }
    }
}

