/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TransactionReportModel
extends AbstractTableModel {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm a");
    private String[] columnNames = new String[]{"transTime", "transNo", "owner", "paymentType", "totalAmount"};
    private List<PosTransaction> items;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PosTransaction transaction = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return dateFormat.format(transaction.getTransactionTime());
            }
            case 1: {
                return transaction.getId();
            }
            case 2: {
                User user = transaction.getUser();
                if (user == null) {
                    return "";
                }
                return user.getFirstName() + " [" + user.getId() + "]";
            }
            case 3: {
                return transaction.getPaymentTypeString();
            }
            case 4: {
                return transaction.getAmount();
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.items;
    }

    public void setItems(List<PosTransaction> items) {
        this.items = items;
    }
}

