/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.VoidItemReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.calendar.DateUtils;

public class VoidItemReport
extends Report {
    private VoidItemReportModel voidItemReportModel;
    private VoidItemReportModel voidTicketReportModel;

    @Override
    public void refresh() throws Exception {
        boolean isModelAdded = this.createModels();
        if (!isModelAdded) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "No Information found!");
            this.viewer = null;
            return;
        }
        JasperReport itemReport = ReportUtil.getReport("deleteItem_sub_report");
        JasperReport ticketReport = ReportUtil.getReport("deleteItem_ticket_sub_report");
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map);
        map.put("reportTitle", "Void Item Report");
        map.put("reportTime", ReportService.formatFullDate(new Date()));
        map.put("dateRange", ReportService.formatShortDate(this.getStartDate()) + " to " + ReportService.formatShortDate(this.getEndDate()));
        map.put("terminalName", this.getTerminal() == null ? POSConstants.ALL : this.getTerminal().getName());
        map.put("currency", Messages.getString("SalesReport.8") + CurrencyUtil.getCurrencyName() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("itemDataSource", (String)new JRTableModelDataSource((TableModel)this.voidItemReportModel));
        map.put("ticketDataSource", (String)new JRTableModelDataSource((TableModel)this.voidTicketReportModel));
        map.put("ticketSection", "Void Tickets");
        map.put("itemSection", "Void Items");
        map.put("itemReport", (String)itemReport);
        map.put("ticketReport", (String)ticketReport);
        JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("void_item_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        this.viewer = new JRViewer(print);
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public boolean createModels() {
        DeletedItem deletedItem;
        Date date1 = DateUtils.startOfDay((Date)this.getStartDate());
        Date date2 = DateUtils.endOfDay((Date)this.getEndDate());
        List<VoidItem> voidItems = VoidItemDAO.getInstance().findByDate(date1, date2, this.getTerminal());
        if (voidItems == null || voidItems.isEmpty()) {
            return false;
        }
        List<Ticket> voidTickets = TicketDAO.getInstance().findVoidTicketByDate(date1, date2, this.getTerminal());
        ArrayList<DeletedItem> deletedItems = new ArrayList<DeletedItem>();
        ArrayList<DeletedItem> deletedTickets = new ArrayList<DeletedItem>();
        for (VoidItem voidItem : voidItems) {
            deletedItem = new DeletedItem();
            deletedItem.setId(voidItem.getId());
            deletedItem.setVoidDate(voidItem.getVoidDate());
            deletedItem.setTicketId(voidItem.getTicketId());
            deletedItem.setQuantity(voidItem.getQuantity());
            deletedItem.setName(voidItem.getMenuItemName());
            deletedItem.setTotal(voidItem.getTotalPrice());
            deletedItem.setVoidReason(voidItem.getVoidReason());
            User owner = TicketDAO.getInstance().findOwner(voidItem.getTicketId());
            deletedItem.setOwner(owner);
            deletedItem.setVoidUser(voidItem.getVoidByUser());
            deletedItems.add(deletedItem);
        }
        this.voidItemReportModel = new VoidItemReportModel();
        this.voidItemReportModel.setItems(deletedItems);
        for (Ticket voidTicket : voidTickets) {
            deletedItem = new DeletedItem();
            deletedItem.setId(voidTicket.getId());
            deletedItem.setVoidDate(voidTicket.getClosingDate());
            deletedItem.setTicketId(voidTicket.getId());
            List<VoidItem> voidItemList = VoidItemDAO.getInstance().getVoidItems(voidTicket.getId());
            double amount = 0.0;
            double quantity = 0.0;
            if (voidItemList != null) {
                for (VoidItem item : voidItemList) {
                    amount += item.getTotalPrice().doubleValue();
                    quantity += item.getQuantity().doubleValue();
                }
                deletedItem.setQuantity(quantity);
                deletedItem.setTotal(amount);
            }
            deletedItem.setVoidReason(voidTicket.getVoidReason());
            deletedItem.setOwner(voidTicket.getOwner());
            deletedItem.setVoidUser(voidTicket.getVoidedBy());
            deletedTickets.add(deletedItem);
        }
        this.voidTicketReportModel = new VoidItemReportModel();
        this.voidTicketReportModel.setItems(deletedTickets);
        return true;
    }
}

