/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PosTransactionService {
    private static PosTransactionService paymentService = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction transaction, User currentUser) throws Exception {
        this.settleTicket(ticket, transaction, currentUser, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction transaction, User currentUser, PostPaymentProcessor postPaymentService) throws Exception {
        if (currentUser == null) {
            currentUser = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Session session = null;
        Transaction tx = null;
        try {
            String giftCardNumber;
            StoreSession storeSession;
            Date currentDate = StoreDAO.getServerTimestamp();
            session = TerminalDAO.getInstance().createNewSession();
            tx = session.beginTransaction();
            if (terminal.isEnableMultiCurrency().booleanValue()) {
                session.saveOrUpdate((Object)currentUser.getActiveDrawerPullReport());
            }
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
            if (ticket.isSourceOnline()) {
                ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
            } else {
                ticket.calculatePrice();
            }
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setPaid(true);
                this.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setServer(ticket.getOwner());
            transaction.setCashDrawer(currentUser.getActiveDrawerPullReport());
            transaction.setTransactionTime(currentDate);
            transaction.setCustomerId(ticket.getCustomerId());
            StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
            if (storeSessionControl != null && (storeSession = storeSessionControl.getCurrentData()) != null) {
                transaction.setStoreSessionId(storeSession.getId());
            }
            ticket.setCashier(currentUser);
            if (transaction.getAmount() > 0.0) {
                ticket.addTotransactions(transaction);
            }
            this.calculateToleranceAmount(ticket, transaction);
            this.adjustGratuityIfNeeded(ticket, transaction);
            transaction.calculateTaxAmount();
            transaction.calculateServiceChargeAmount();
            if (ticket.getOrderType() != null && ticket.getOrderType().getName() == "BAR_TAB") {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (postPaymentService != null) {
                postPaymentService.paymentDone(transaction, session);
            }
            if ((giftCardNumber = ticket.getProperty("cardNumber")) != null) {
                GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(giftCardNumber);
                transaction.setTransactionType(TransactionType.CREDIT.name());
                transaction.setGiftCertNumber(giftCardNumber);
                Double totalAmount = ticket.getTotalAmountWithTips();
                giftCard.setBalance(giftCard.getBalance() + totalAmount);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception x) {
                PosLog.error(PosTransactionService.class, x);
                x.printStackTrace();
            }
            throw e;
        }
        finally {
            TerminalDAO.getInstance().closeSession(session);
        }
        String actionMessage = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        actionMessage = actionMessage + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, actionMessage);
    }

    private void calculateToleranceAmount(Ticket ticket, PosTransaction transaction) {
        double changeAmount;
        double toleranceAmountFactor = 0.0;
        Currency mainCurrency = CurrencyUtil.getMainCurrency();
        if (mainCurrency != null) {
            toleranceAmountFactor = mainCurrency.getTolerance();
        }
        if (ticket.getRoundedDueAmount() == 0.0 || ticket.getRoundedDueAmount() <= toleranceAmountFactor) {
            transaction.setToleranceAmount(ticket.getToleranceAmount());
        }
        if ((changeAmount = NumberUtil.round(transaction.getTenderAmount() - transaction.getAmount())) == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double roundedChangeAmount = store.isAllowPenyRounding() ? (double)Math.round(changeAmount * 100.0 / 5.0) * 5.0 / 100.0 : changeAmount;
        double toleranceAmount = changeAmount - roundedChangeAmount;
        if (Math.abs(roundedChangeAmount) <= toleranceAmountFactor) {
            transaction.setToleranceAmount(changeAmount);
            transaction.setChangeAmount(0.0);
        } else {
            transaction.setToleranceAmount(toleranceAmount);
            transaction.setChangeAmount(roundedChangeAmount);
        }
        transaction.setAmount(transaction.getAmount() + transaction.getToleranceAmount());
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction transaction, boolean closed, User currentUser) throws Exception {
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Session session = null;
        Transaction tx = null;
        GenericDAO dao = new GenericDAO();
        try {
            Date currentDate = StoreDAO.getServerTimestamp();
            session = dao.createNewSession();
            tx = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
            ticket.calculatePrice();
            if (closed) {
                ticket.setPaid(true);
                this.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setServer(ticket.getOwner());
            transaction.setCashDrawer(currentUser.getActiveDrawerPullReport());
            transaction.setTransactionTime(currentDate);
            ticket.setCashier(currentUser);
            ticket.addTotransactions(transaction);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            dao.closeSession(session);
        }
        String actionMessage = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        actionMessage = actionMessage + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, actionMessage);
    }

    private void closeTicketIfApplicable(Ticket ticket, Date currentDate) {
        OrderType ticketType = ticket.getOrderType();
        if (ticketType.isCloseOnPaid().booleanValue() || ticketType.isBarTab().booleanValue()) {
            ticket.setClosed(true);
            ticket.setClosingDate(currentDate);
        }
    }

    private void adjustGratuityIfNeeded(Ticket ticket, PosTransaction transaction) {
        double gratuityAmount = ticket.getGratuityAmount();
        if (gratuityAmount <= 0.0) {
            return;
        }
        double gratuityPaidAmount = 0.0;
        Set<PosTransaction> transactions = ticket.getTransactions();
        if (transactions != null && transactions.size() > 0) {
            for (PosTransaction posTransaction : transactions) {
                if (posTransaction instanceof RefundTransaction || posTransaction.isVoided().booleanValue()) continue;
                gratuityPaidAmount += posTransaction.getTipsAmount().doubleValue();
            }
        }
        double gratuityDueAmount = gratuityAmount - gratuityPaidAmount;
        double payableTipsAmount = gratuityDueAmount + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (gratuityDueAmount > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                transaction.setTipsAmount(gratuityDueAmount);
            } else if (payableTipsAmount > 0.0) {
                Double transactionAmount = transaction.getAmount();
                if (payableTipsAmount > transactionAmount) {
                    transaction.setTipsAmount(transactionAmount);
                } else {
                    transaction.setTipsAmount(NumberUtil.roundToTwoDigit(payableTipsAmount));
                }
            }
        }
    }

    public void voidTicket(Ticket ticket, User currentUser) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(currentUser);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getRefundableAmount(PosTransaction posTransaction) {
        double refundedAmountForTransaction = 0.0;
        String refundedAmountText = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)refundedAmountText)) {
            try {
                refundedAmountForTransaction = Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(posTransaction.getAmount() - refundedAmountForTransaction);
    }

    public double refundTicket(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, List<PosTransaction> transactions, boolean forceCashRefund) throws Exception {
        return this.refundTicket(ticket, refundTenderedAmount, refundItemTaxAmount, currentUser, transactions, forceCashRefund, null);
    }

    public double refundTicket(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, List<PosTransaction> transactions, boolean forceCashRefund, String giftCardNo) throws Exception {
        double refundTenderedRemaining = refundTenderedAmount;
        boolean refundToCustomerBalance = false;
        if (transactions == null || transactions.isEmpty()) {
            RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, refundTenderedAmount);
            refundTransaction.setUser(currentUser);
            if (StringUtils.isEmpty((String)giftCardNo)) {
                refundTransaction.setPaymentType(PaymentType.CASH);
            } else {
                refundTransaction.setPaymentType(PaymentType.GIFT_CERTIFICATE);
            }
            ticket.setRefunded(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            ticket.setCashier(currentUser);
            ticket.calculateRefundAmount();
            ticket.setRefundableAmount(0.0);
            ticket.setRefundAmount(refundTenderedAmount);
            ticket.addTotransactions(refundTransaction);
            ticket.calculatePrice();
            Session session = null;
            Transaction transaction = null;
            try {
                GiftCard giftCard;
                session = TicketDAO.getInstance().createNewSession();
                transaction = session.beginTransaction();
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (refundToCustomerBalance) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                if (StringUtils.isNotEmpty((String)giftCardNo) && (giftCard = GiftCardDAO.getInstance().get(giftCardNo, session)) != null) {
                    giftCard.setBalance(giftCard.getBalance() + refundTransaction.getAmount());
                    GiftCardDAO.getInstance().update(giftCard, session);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            finally {
                TicketDAO.getInstance().closeSession(session);
            }
            return refundTenderedAmount;
        }
        if (transactions.size() > 1) {
            for (PosTransaction posTransaction : transactions) {
                if (this.getRefundableAmount(posTransaction) != refundTenderedAmount) continue;
                transactions = new ArrayList<PosTransaction>();
                transactions.add(posTransaction);
                break;
            }
        }
        for (PosTransaction posTransaction : transactions) {
            double refundAmount = this.getRefundableAmount(posTransaction);
            if (refundAmount > refundTenderedRemaining) {
                refundAmount = refundTenderedRemaining;
            }
            if (!(refundAmount <= refundTenderedRemaining)) continue;
            double refundTaxAmount = refundItemTaxAmount * refundAmount / refundTenderedAmount;
            this.refundTicket(ticket, refundAmount, refundTaxAmount, currentUser, posTransaction, forceCashRefund, giftCardNo);
            if (!posTransaction.isRefunded()) continue;
            refundTenderedRemaining -= refundAmount;
            if (!(posTransaction instanceof CustomerAccountTransaction)) continue;
            refundToCustomerBalance = true;
        }
        if (refundTenderedAmount != refundTenderedRemaining) {
            ticket.setRefunded(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            ticket.setCashier(currentUser);
            ticket.calculateRefundAmount();
            ticket.setRefundableAmount(ticket.getRefundableAmount() - refundTenderedAmount - refundTenderedRemaining);
            ticket.calculatePrice();
            this.mergeCashRefundTransactions(ticket);
            Session session = null;
            Transaction transaction = null;
            try {
                session = TicketDAO.getInstance().createNewSession();
                transaction = session.beginTransaction();
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (refundToCustomerBalance) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            finally {
                TicketDAO.getInstance().closeSession(session);
            }
        }
        return refundTenderedAmount - refundTenderedRemaining;
    }

    private void mergeCashRefundTransactions(Ticket ticket) {
        BasePosTransaction refundTransaction = null;
        Iterator<PosTransaction> iterator = ticket.getTransactions().iterator();
        while (iterator.hasNext()) {
            PosTransaction posTransaction = iterator.next();
            if (!(posTransaction instanceof RefundTransaction) || posTransaction.getId() != null || posTransaction.getPaymentType() != PaymentType.CASH) continue;
            if (refundTransaction != null) {
                refundTransaction.setAmount(refundTransaction.getAmount() + posTransaction.getAmount());
                refundTransaction.setTipsAmount(refundTransaction.getTipsAmount() + posTransaction.getTipsAmount());
                refundTransaction.setTaxAmount(refundTransaction.getTaxAmount() + posTransaction.getTaxAmount());
                iterator.remove();
                continue;
            }
            if (posTransaction.getId() != null) continue;
            refundTransaction = (RefundTransaction)posTransaction;
        }
    }

    public void refundTicket(Ticket ticket, double refundAmount, double refundTaxAmount, User currentUser, PosTransaction transaction, boolean forceCashRefund) throws Exception {
        this.refundTicket(ticket, refundAmount, refundTaxAmount, currentUser, transaction, forceCashRefund, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refundTicket(Ticket ticket, double refundAmount, double refundTaxAmount, User currentUser, PosTransaction transaction, boolean forceCashRefund, String giftCardNo) throws Exception {
        if (refundAmount <= 0.0) {
            return;
        }
        boolean refundedUsingCard = false;
        boolean voidedUsingCard = false;
        if (StringUtils.isNotEmpty((String)giftCardNo)) {
            GiftCardPaymentPlugin paymentGateway = GiftCardConfig.getPaymentGateway();
            GiftCardProcessor giftCardProcessor = paymentGateway.getProcessor();
            giftCardProcessor.refund(giftCardNo, refundAmount);
        } else if (!forceCashRefund) {
            if (transaction != null) {
                if (transaction instanceof CustomerAccountTransaction) {
                    Customer customer = ticket.getCustomer();
                    if (customer == null) {
                        throw new PosException("Failed to refund because member not found.");
                    }
                    customer.setBalance(customer.getBalance() + refundAmount);
                    transaction.setRefunded(true);
                } else if (transaction instanceof CreditCardTransaction) {
                    double transactionAmount = transaction.getAmount();
                    CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
                    try {
                        transaction.setAmount(refundAmount);
                        if (transactionAmount == refundAmount) {
                            cardProcessor.voidTransaction(transaction);
                            voidedUsingCard = transaction.isVoided();
                        }
                        if (!voidedUsingCard) {
                            cardProcessor.refundTransaction(transaction, refundAmount);
                            refundedUsingCard = transaction.isRefunded();
                        }
                    }
                    catch (Exception e) {
                        try {
                            cardProcessor.refundTransaction(transaction, refundAmount);
                            refundedUsingCard = transaction.isRefunded();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        transaction.setAmount(transactionAmount);
                    }
                }
            }
            if (transaction instanceof CreditCardTransaction && !refundedUsingCard && !voidedUsingCard) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Failed to refund.");
                throw new PosException("Failed to refund.");
            }
        }
        PaymentType paymentType = null;
        paymentType = StringUtils.isNotEmpty((String)giftCardNo) ? PaymentType.GIFT_CERTIFICATE : (forceCashRefund ? PaymentType.CASH : transaction.getPaymentType());
        RefundTransaction posTransaction = this.createRefundTransaction(ticket, transaction, refundAmount);
        posTransaction.setPaymentType(paymentType);
        posTransaction.setUser(currentUser);
        posTransaction.setServer(ticket.getOwner());
        posTransaction.setTaxAmount(refundTaxAmount);
        if (transaction instanceof CustomerAccountTransaction) {
            posTransaction.setCustomerId(ticket.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)giftCardNo)) {
            posTransaction.setGiftCertNumber(giftCardNo);
        }
        ticket.addTotransactions(posTransaction);
        transaction.setRefunded(true);
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction transaction, double refundAmount) {
        RefundTransaction posTransaction = new RefundTransaction();
        posTransaction.setAmount(refundAmount);
        posTransaction.setTicket(ticket);
        posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        posTransaction.setTransactionType(TransactionType.DEBIT.name());
        posTransaction.setCashDrawer(Application.getCurrentUser().getActiveDrawerPullReport());
        posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        posTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        if (transaction == null) {
            return posTransaction;
        }
        posTransaction.setCardExpMonth(transaction.getCardExpMonth());
        posTransaction.setCardHolderName(transaction.getCardHolderName());
        posTransaction.setCardAuthCode(transaction.getCardAuthCode());
        posTransaction.setCardMerchantGateway(transaction.getCardMerchantGateway());
        posTransaction.setCardNumber(transaction.getCardNumber());
        posTransaction.setCardTrack(transaction.getCardTrack());
        posTransaction.setCardTransactionId(transaction.getCardTransactionId());
        posTransaction.setCardReader(transaction.getCardReader());
        posTransaction.setCardType(transaction.getCardType());
        posTransaction.addProperty("REFUNDED_TRANSACTION_ID", transaction.getId());
        String refundedAmountText = transaction.getProperty("REFUNDED_AMOUNT");
        double previousRefundedAmount = 0.0;
        if (StringUtils.isNotEmpty((String)refundedAmountText)) {
            try {
                previousRefundedAmount = Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        transaction.addProperty("REFUNDED_AMOUNT", String.valueOf(refundAmount + previousRefundedAmount));
        if (transaction.getTipsAmount() > 0.0) {
            double transactionAmountWithoutTips;
            double totalRefundedAmount;
            double tipsRefundAmount;
            String refundedTipsAmountText = transaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double previousRefundedTipsAmount = 0.0;
            if (StringUtils.isNotEmpty((String)refundedAmountText)) {
                try {
                    previousRefundedTipsAmount = Double.parseDouble(refundedTipsAmountText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((tipsRefundAmount = (totalRefundedAmount = previousRefundedAmount + refundAmount) - (transactionAmountWithoutTips = transaction.getAmount() - transaction.getTipsAmount()) - previousRefundedTipsAmount) > 0.0) {
                posTransaction.setTipsAmount(tipsRefundAmount);
                transaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(tipsRefundAmount + previousRefundedTipsAmount));
                Gratuity gratuity = ticket.getGratuity();
                gratuity.setAmount(gratuity.getAmount() - tipsRefundAmount);
            }
        }
        return posTransaction;
    }

    public double refundTicket(Ticket ticket, PosTransaction transaction, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, Session session) throws Exception {
        ticket.setRefunded(true);
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        ticket.setCashier(currentUser);
        ticket.calculateRefundAmount();
        ticket.setRefundableAmount(0.0);
        ticket.setRefundAmount(refundTenderedAmount);
        ticket.addTotransactions(transaction);
        ticket.calculatePrice();
        TicketDAO.getInstance().saveOrUpdate(ticket, session);
        return refundTenderedAmount;
    }

    public void bookBartabTicket(Ticket ticket, PosTransaction transaction, boolean closed) throws Exception {
        Application application = Application.getInstance();
        User currentUser = Application.getCurrentUser();
        Terminal terminal = application.refreshAndGetTerminal();
        Session session = null;
        Transaction tx = null;
        GenericDAO dao = new GenericDAO();
        try {
            Date currentDate = new Date();
            session = dao.createNewSession();
            tx = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.calculatePrice();
            if (closed) {
                ticket.setPaid(true);
                this.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setTransactionTime(currentDate);
            ticket.addTotransactions(transaction);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
            dao.closeSession(session);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    tx.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                dao.closeSession(session);
                throw throwable;
            }
        }
        String actionMessage = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId();
        actionMessage = actionMessage + ";" + POSConstants.TOTAL + ":" + NumberUtil.formatNumber(ticket.getTotalAmount());
        ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.SETTLE_CHECK, actionMessage);
    }

    public static PosTransactionService getInstance() {
        return paymentService;
    }
}

