/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class SplitTicketService {
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;

    static List<Double> splitValue(double value, int count) {
        ArrayList<Double> result = new ArrayList<Double>(count);
        double runningTotal = 0.0;
        for (int i = 0; i < count; ++i) {
            double remainder = value - runningTotal;
            double d = count - i;
            double share = remainder > 0.0 ? Math.max(NumberUtil.roundToTwoDigit(remainder / d), 0.01) : 0.0;
            result.add(share);
            runningTotal += share;
        }
        Double double1 = (Double)result.get(count - 1);
        if (runningTotal < value) {
            double1 = double1 + (value - runningTotal);
            result.set(count - 1, double1);
        }
        return result;
    }

    public static List<Ticket> doEquallySplit(Ticket ticket, int splitQuantity) throws Exception {
        HashMap<Integer, Ticket> listOfSplitTickets = new HashMap<Integer, Ticket>();
        listOfSplitTickets.put(1, ticket);
        for (int i = 1; i < splitQuantity; ++i) {
            Ticket splitTicket = SplitTicketService.createNewTicket(ticket, splitQuantity);
            splitTicket.setSplitOrder(i + 1);
            for (TicketItem item : ticket.getTicketItems()) {
                SplitTicketService.transferTicketItem(item, splitTicket, splitQuantity);
            }
            splitTicket.calculatePrice();
            listOfSplitTickets.put(i + 1, splitTicket);
        }
        SplitTicketService.updateTicket(ticket, null, 0, splitQuantity);
        return new ArrayList<Ticket>(listOfSplitTickets.values());
    }

    public static List<Ticket> doSplitBySeatNumber(Ticket ticket) throws Exception {
        ArrayList<Ticket> splitTickets = new ArrayList<Ticket>();
        List<TicketItem> ticketItems = ticket.getTicketItems();
        ArrayList<TicketItem> sharedTicketItems = new ArrayList<TicketItem>();
        HashMap<Integer, Customer> customerMap = new HashMap<Integer, Customer>();
        HashMap<Integer, ArrayList<TicketItem>> itemMap = new HashMap<Integer, ArrayList<TicketItem>>();
        for (TicketItem ticketItem : ticketItems) {
            TicketItemSeat seat = ticketItem.getSeat();
            Integer seatNumber = seat == null ? ticketItem.getSeatNumber() : seat.getSeatNumber();
            ArrayList<TicketItem> ticketItemList = (ArrayList<TicketItem>)itemMap.get(seatNumber);
            if (seatNumber == 0) {
                sharedTicketItems.add(ticketItem);
                continue;
            }
            if (ticketItemList == null) {
                ticketItemList = new ArrayList<TicketItem>();
                ticketItemList.add(ticketItem);
                if (seat != null) {
                    customerMap.put(ticketItem.getSeatNumber(), seat.getMember());
                }
                itemMap.put(ticketItem.getSeatNumber(), ticketItemList);
                continue;
            }
            ticketItemList.add(ticketItem);
        }
        if (itemMap.size() <= 1) {
            return null;
        }
        int splitNumber = 1;
        Iterator iterator = itemMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer seatNumber = (Integer)iterator.next();
            List splitTicketItems = (List)itemMap.get(seatNumber);
            if (splitTicketItems == null || splitTicketItems.size() != 1 || !((TicketItem)splitTicketItems.get(0)).isTreatAsSeat().booleanValue()) continue;
            iterator.remove();
        }
        int totalSplitQuantity = 0;
        if (itemMap.keySet().size() > 1) {
            totalSplitQuantity = itemMap.keySet().size();
        }
        Integer firstTicketSeatNumber = (Integer)itemMap.keySet().iterator().next();
        ticket.setTicketItems((List)itemMap.get(firstTicketSeatNumber));
        splitTickets.add(ticket);
        for (Integer seatNumber : itemMap.keySet()) {
            if (seatNumber.intValue() == firstTicketSeatNumber.intValue()) continue;
            List splitTicketItems = (List)itemMap.get(seatNumber);
            Ticket cloneTicket = SplitTicketService.cloneTicket(ticket, splitTicketItems, sharedTicketItems, splitNumber, totalSplitQuantity, 1);
            Customer customer = (Customer)customerMap.get(seatNumber);
            if (customer != null) {
                cloneTicket.setCustomer(customer);
            }
            splitTickets.add(cloneTicket);
            ++splitNumber;
        }
        SplitTicketService.updateTicket(ticket, sharedTicketItems, splitNumber, totalSplitQuantity, 1);
        Customer customer = (Customer)customerMap.get(firstTicketSeatNumber);
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        return splitTickets;
    }

    private static Ticket cloneTicket(Ticket ticket, List<TicketItem> ticketItems, List<TicketItem> sharedTicketItems, int splitViewNumber, int totalSplitQuantity, int splitValue) throws Exception {
        Ticket splitCheck = SplitTicketService.createNewTicket(ticket, splitValue);
        splitCheck.setSplitOrder(splitViewNumber + 1);
        for (TicketItem ticketItem : ticketItems) {
            TicketItem newTicketItem = SplitTicketService.createNewTicketItem(ticketItem, 1);
            newTicketItem.setTicket(splitCheck);
            newTicketItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
            splitCheck.addToticketItems(newTicketItem);
        }
        if (sharedTicketItems != null && totalSplitQuantity > 1) {
            for (TicketItem ticketItem : sharedTicketItems) {
                TicketItem sharedNewItem = SplitTicketService.createNewTicketItem(ticketItem, totalSplitQuantity);
                sharedNewItem.setFractionalUnit(true);
                sharedNewItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
                splitCheck.addToticketItems(sharedNewItem);
                sharedNewItem.setTicket(splitCheck);
            }
        }
        splitCheck.calculatePrice();
        return splitCheck;
    }

    private static List<TicketDiscount> cloneTicketDiscounts(List<TicketDiscount> ticketDiscounts, int splitQuantity) throws Exception {
        ArrayList<TicketDiscount> newTicketDiscounts = new ArrayList<TicketDiscount>();
        if (ticketDiscounts != null && !ticketDiscounts.isEmpty()) {
            for (TicketDiscount ticketDiscount : ticketDiscounts) {
                TicketDiscount newTicketDiscount = new TicketDiscount();
                PropertyUtils.copyProperties((Object)newTicketDiscount, (Object)ticketDiscount);
                newTicketDiscount.setId(null);
                if (ticketDiscount.getType() != 1) {
                    newTicketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)splitQuantity);
                }
                newTicketDiscounts.add(newTicketDiscount);
            }
        }
        return newTicketDiscounts;
    }

    public static void transferTicketItem(TicketItem ticketItem, Ticket toTicket, int splitQuantity) {
        TicketItem newTicketItem = SplitTicketService.createNewTicketItem(ticketItem, splitQuantity);
        if (Double.isInfinite(splitQuantity)) {
            return;
        }
        if (splitQuantity % 1 != 0) {
            newTicketItem.setFractionalUnit(true);
        }
        newTicketItem.setMenuItemId(ticketItem.getMenuItemId());
        newTicketItem.setTicket(toTicket);
        newTicketItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
        toTicket.addToticketItems(newTicketItem);
    }

    private static TicketItem createNewTicketItem(TicketItem ticketItem, int splitQuantity) {
        try {
            TicketItem newTicketItem = ticketItem.cloneAsNew();
            newTicketItem.setQuantity(ticketItem.getQuantity() / (double)splitQuantity);
            List<TicketItemDiscount> newDiscounts = newTicketItem.getDiscounts();
            newTicketItem.calculatePrice();
            SplitTicketService.updateTicketItemDiscounts(newDiscounts, splitQuantity);
            return newTicketItem;
        }
        catch (Exception exception) {
            return ticketItem;
        }
    }

    private static Ticket createNewTicket(Ticket ticket, int splitQuantity) throws Exception {
        Ticket splitTicket = new Ticket(true);
        PropertyUtils.copyProperties((Object)splitTicket, (Object)ticket);
        splitTicket.setProperties(null);
        splitTicket.setTransactions(null);
        splitTicket.setId(null);
        splitTicket.setTokenNo(null);
        splitTicket.setShortId(null);
        splitTicket.setTicketItems(null);
        splitTicket.setDiscounts(SplitTicketService.cloneTicketDiscounts(ticket.getDiscounts(), splitQuantity));
        ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
        List<Integer> ticketTableNumbers = ticket.getTableNumbers();
        if (ticketTableNumbers != null) {
            tableNumbers.addAll(ticketTableNumbers);
        }
        splitTicket.setTableNumbers(tableNumbers);
        return splitTicket;
    }

    private static void updateTicket(Ticket ticket, List<TicketItem> sharedTicketItems, int splitViewNumber, int totalSplitQuantity) throws Exception {
        SplitTicketService.updateTicket(ticket, sharedTicketItems, splitViewNumber, totalSplitQuantity, totalSplitQuantity);
    }

    private static void updateTicket(Ticket ticket, List<TicketItem> sharedTicketItems, int splitViewNumber, int totalSplitQuantity, int splitValue) throws Exception {
        ticket.setSplitOrder(splitViewNumber + 1);
        SplitTicketService.updateTicketItems(ticket.getTicketItems(), splitValue);
        if (sharedTicketItems != null && totalSplitQuantity > 1) {
            ArrayList<TicketItem> sharedNewItemList = new ArrayList<TicketItem>();
            for (TicketItem ticketItem : sharedTicketItems) {
                TicketItem sharedNewItem = SplitTicketService.createNewTicketItem(ticketItem, totalSplitQuantity);
                sharedNewItem.setFractionalUnit(true);
                sharedNewItemList.add(sharedNewItem);
                sharedNewItem.setTicket(ticket);
            }
            for (TicketItem sharedNewItem : sharedNewItemList) {
                ticket.addToticketItems(sharedNewItem);
            }
        }
        SplitTicketService.updateTicketDiscounts(ticket.getDiscounts(), totalSplitQuantity);
        ticket.calculatePrice();
    }

    private static void updateTicketItems(List<TicketItem> ticketItems, int totalSplitQuantity) throws Exception {
        for (TicketItem ticketItem : ticketItems) {
            ticketItem.setQuantity(ticketItem.getQuantity() / (double)totalSplitQuantity);
            ticketItem.setFractionalUnit(true);
            ticketItem.calculatePrice();
            SplitTicketService.updateTicketItemDiscounts(ticketItem.getDiscounts(), totalSplitQuantity);
        }
    }

    private static void updateTicketDiscounts(List<TicketDiscount> ticketDiscounts, int splitQuantity) throws Exception {
        if (ticketDiscounts != null && !ticketDiscounts.isEmpty()) {
            for (TicketDiscount ticketDiscount : ticketDiscounts) {
                if (ticketDiscount.getType() == 1) continue;
                ticketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)splitQuantity);
            }
        }
    }

    private static void updateTicketItemDiscounts(List<TicketItemDiscount> ticketItemDiscounts, int splitQuantity) throws Exception {
        if (ticketItemDiscounts != null && !ticketItemDiscounts.isEmpty()) {
            for (TicketItemDiscount discount : ticketItemDiscounts) {
                if (discount.getType() != 1) {
                    discount.setCouponQuantity(discount.getCouponQuantity() / (double)splitQuantity);
                }
                discount.calculateDiscount(discount.getTicketItem().getSubtotalAmount());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String decrypt = AESencrp.decrypt("ICniG0w+rKbFnd+T2TUDUA==");
        System.out.println(decrypt);
    }
}

