/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageComponent
extends JPanel {
    private Image image;
    private Integer imageWidth;
    private Integer imageHeight;
    private boolean scaleToSize = true;

    public ImageComponent() {
    }

    public ImageComponent(Image image) {
        this.image = image;
        if (image != null) {
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            this.imageWidth = bimage.getWidth();
            this.imageHeight = bimage.getHeight();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.scaleToSize) {
            g.drawImage(this.image, x, y, width, height, this);
        } else {
            g.drawImage(this.image, x, y, this);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            this.imageWidth = bimage.getWidth();
            this.imageHeight = bimage.getHeight();
        }
    }

    public void setImage(Image image, int width, int height) {
        this.image = image;
        if (image != null) {
            BufferedImage bimage = new BufferedImage(width, height, 2);
            this.imageWidth = bimage.getWidth();
            this.imageHeight = bimage.getHeight();
        }
    }

    public boolean isScaleToSize() {
        return this.scaleToSize;
    }

    public void setScaleToSize(boolean scaleToSize) {
        this.scaleToSize = scaleToSize;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }
}

